/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.meta;

import leap.lang.Strings;
import leap.web.api.config.ApiConfig;
import leap.web.api.meta.ApiMetadataBuilder;
import leap.web.api.meta.ApiMetadataStrategy;
import leap.web.api.meta.model.MApiOperationBuilder;
import leap.web.api.meta.model.MApiPathBuilder;

public class DefaultApiMetadataStrategy
implements ApiMetadataStrategy {
    @Override
    public boolean tryCreateOperationId(ApiConfig c, ApiMetadataBuilder m, MApiPathBuilder p, MApiOperationBuilder op) {
        if (!c.isUniqueOperationId()) {
            op.setId(op.getName());
            return true;
        }
        String name = op.getName();
        String method = op.getMethod().name().toLowerCase();
        if (Strings.contains((String)name, (String)"$Lambda$")) {
            return false;
        }
        if (!name.equalsIgnoreCase(method)) {
            if (this.trySetUniqueOperationId(m, op, name)) {
                return true;
            }
            String id = name + "With" + Strings.upperFirst((String)method);
            if (this.trySetUniqueOperationId(m, op, id)) {
                return true;
            }
        }
        for (String tag : op.getTags()) {
            if (name.toLowerCase().contains(tag.toLowerCase())) continue;
            String id = name + Strings.upperFirst((String)tag);
            if (this.trySetUniqueOperationId(m, op, id)) {
                return true;
            }
            if (!this.trySetUniqueOperationId(m, op, id = id + "With" + Strings.upperFirst((String)method))) continue;
            return true;
        }
        return false;
    }

    protected boolean trySetUniqueOperationId(ApiMetadataBuilder m, MApiOperationBuilder op, String id) {
        if (m.getOperationIds().contains(id)) {
            return false;
        }
        op.setId(id);
        m.getOperationIds().add(id);
        return true;
    }
}

