/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.meta;

import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.Part;
import leap.core.annotation.Inject;
import leap.core.meta.MTypeContainer;
import leap.core.meta.MTypeManager;
import leap.core.web.path.PathTemplate;
import leap.lang.Classes;
import leap.lang.Enums;
import leap.lang.Strings;
import leap.lang.http.HTTP;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.lang.meta.MComplexType;
import leap.lang.meta.MSimpleTypes;
import leap.lang.meta.MType;
import leap.lang.meta.MTypeStrategy;
import leap.web.App;
import leap.web.action.Action;
import leap.web.action.Argument;
import leap.web.api.Api;
import leap.web.api.annotation.ApiModel;
import leap.web.api.annotation.Response;
import leap.web.api.config.ApiConfig;
import leap.web.api.config.model.ModelConfig;
import leap.web.api.config.model.OAuthConfig;
import leap.web.api.meta.ApiMetadata;
import leap.web.api.meta.ApiMetadataBuilder;
import leap.web.api.meta.ApiMetadataContext;
import leap.web.api.meta.ApiMetadataFactory;
import leap.web.api.meta.ApiMetadataProcessor;
import leap.web.api.meta.ApiMetadataStrategy;
import leap.web.api.meta.model.MApiModelBuilder;
import leap.web.api.meta.model.MApiOperation;
import leap.web.api.meta.model.MApiOperationBuilder;
import leap.web.api.meta.model.MApiParameter;
import leap.web.api.meta.model.MApiParameterBuilder;
import leap.web.api.meta.model.MApiPath;
import leap.web.api.meta.model.MApiPathBuilder;
import leap.web.api.meta.model.MApiPermission;
import leap.web.api.meta.model.MApiResponse;
import leap.web.api.meta.model.MApiResponseBuilder;
import leap.web.api.meta.model.MApiSecurityDef;
import leap.web.api.meta.model.MApiTag;
import leap.web.api.meta.model.MOAuth2ApiSecurityDef;
import leap.web.api.route.ApiRoute;
import leap.web.multipart.MultipartFile;
import leap.web.route.Route;

public class DefaultApiMetadataFactory
implements ApiMetadataFactory {
    private static final Log log = LogFactory.get(DefaultApiMetadataFactory.class);
    @Inject
    protected App app;
    @Inject
    protected ApiMetadataProcessor[] processors;
    @Inject
    protected MTypeManager mtypeManager;
    @Inject
    protected ApiMetadataStrategy strategy;
    private static final Set<Class<?>> PARAM_FILE_TYPES = new HashSet();

    @Override
    public ApiMetadata createMetadata(Api api) {
        ApiMetadataBuilder md = api.getConfigurator().getMetadata();
        if (null == md) {
            md = new ApiMetadataBuilder();
        }
        ApiMetadataContext context = this.createContext(api, md);
        this.prepareMetadata(context, md);
        this.setBaseInfo(context, md);
        this.createResponses(context, md);
        this.createPermissions(context, md);
        this.createSecurityDefs(context, md);
        this.createPaths(context, md);
        this.createModels(context, md);
        return this.processMetadata(context, md);
    }

    private void prepareMetadata(ApiMetadataContext context, ApiMetadataBuilder md) {
        ApiConfig c = context.getConfig();
        c.getApiRoutes().forEach(ar -> {
            Route route = ar.getRoute();
            if (!c.isCorsDisabled() && !route.isCorsDisabled()) {
                route.setCorsEnabled(Boolean.valueOf(true));
            }
        });
    }

    @Override
    public MApiOperationBuilder createOperation(ApiMetadataContext context, ApiMetadataBuilder m, Route route) {
        MApiOperationBuilder op = (MApiOperationBuilder)((Object)route.getAction().getExtension(MApiOperationBuilder.class));
        if (null != op) {
            op.setRoute(route);
            return op;
        }
        op = new MApiOperationBuilder(route);
        op.setName(route.getAction().getName());
        op.setCorsEnabled(route.isCorsEnabled());
        this.setApiMethod(context, m, route, op);
        log.debug(" {}", new Object[]{op.getMethod()});
        this.createApiSecurity(context, m, route, op);
        this.createApiParameters(context, m, route, op);
        this.createApiResponses(context, m, route, op);
        return op;
    }

    protected ApiMetadataContext createContext(final Api api, ApiMetadataBuilder md) {
        final MTypeContainer tf = this.createMTypeFactory(api.getConfig(), md);
        return new ApiMetadataContext(){

            @Override
            public MTypeContainer getMTypeContainer() {
                return tf;
            }

            @Override
            public Api getApi() {
                return api;
            }
        };
    }

    protected MTypeContainer createMTypeFactory(final ApiConfig c, ApiMetadataBuilder md) {
        return this.mtypeManager.factory().setStrategy(new MTypeStrategy(){

            public String getComplexTypeName(String name) {
                for (String prefix : c.getRemovalModelNamePrefixes()) {
                    if (!Strings.startsWithIgnoreCase((String)name, (String)prefix)) continue;
                    name = Strings.removeStartIgnoreCase((String)name, (String)prefix);
                    break;
                }
                return name;
            }
        }).setAlwaysReturnComplexTypeRef(true).create();
    }

    protected void setBaseInfo(ApiMetadataContext context, ApiMetadataBuilder md) {
        ApiConfig c = context.getConfig();
        md.setBasePath(c.getBasePath());
        md.setName(c.getName());
        md.setTitle(c.getTitle());
        md.setVersion(c.getVersion());
        md.setSummary(c.getSummary());
        md.setDescription(c.getDescription());
        md.addProtocols(c.getProtocols());
        md.addProduces(c.getProduces());
        md.addConsumes(c.getConsumes());
    }

    protected void createResponses(ApiMetadataContext context, ApiMetadataBuilder m) {
        ApiConfig c = context.getConfig();
        c.getCommonResponses().forEach((name, r) -> {
            MType type = r.getType();
            if (type.isComplexType()) {
                MComplexType ct = type.asComplexType();
                if (!m.containsModel(ct.getName())) {
                    this.tryAddModel(context, m, ct);
                }
                type = ct.createTypeRef();
            }
            MApiResponseBuilder rb = new MApiResponseBuilder((MApiResponse)r);
            rb.setType(type);
            m.putResponse((String)name, rb);
        });
    }

    protected void createPermissions(ApiMetadataContext context, ApiMetadataBuilder md) {
        context.getConfig().getPermissions().values().forEach(p -> md.addPermission((MApiPermission)p));
    }

    protected void createSecurityDefs(ApiMetadataContext context, ApiMetadataBuilder md) {
        OAuthConfig oc = context.getConfig().getOAuthConfig();
        if (oc != null && oc.isEnabled()) {
            for (MApiSecurityDef sd : md.getSecurityDefs()) {
                if (!sd.isOAuth2()) continue;
                return;
            }
            MOAuth2ApiSecurityDef def = new MOAuth2ApiSecurityDef("oauth2", "oauth2", oc.getAuthorizationUrl(), oc.getTokenUrl(), oc.getFlow(), null);
            md.addSecurityDef(def);
        }
    }

    protected ApiMetadata processMetadata(ApiMetadataContext context, ApiMetadataBuilder md) {
        this.preProcessDefault(context, md);
        for (ApiMetadataProcessor p : this.processors) {
            p.preProcess(context, md);
        }
        this.postProcessDefault(context, md);
        for (ApiMetadataProcessor p : this.processors) {
            p.postProcess(context, md);
        }
        ApiMetadata m = md.build();
        this.completeProcessDefault(context, m);
        for (ApiMetadataProcessor p : this.processors) {
            p.completeProcess(context, m);
        }
        return m;
    }

    protected void preProcessDefault(ApiMetadataContext context, ApiMetadataBuilder m) {
        m.getPaths().forEach((k, p) -> this.preProcessPath(context, m, (MApiPathBuilder)p));
    }

    protected void preProcessPath(ApiMetadataContext context, ApiMetadataBuilder m, MApiPathBuilder p) {
        p.getOperations().forEach(op -> {
            this.createOperationTags(context, m, op.getRoute(), p, (MApiOperationBuilder)((Object)op));
            if (Strings.isEmpty((String)op.getId())) {
                this.strategy.tryCreateOperationId(context.getConfig(), m, p, (MApiOperationBuilder)((Object)op));
            }
        });
    }

    protected void postProcessDefault(ApiMetadataContext context, ApiMetadataBuilder m) {
        String defaultMimeType = "application/json";
        if (m.getConsumes().isEmpty()) {
            m.addConsume(defaultMimeType);
        }
        if (m.getProduces().isEmpty()) {
            m.addProduce(defaultMimeType);
        }
        m.getModels().forEach((name, model) -> this.postProcessModel(context, m, (String)name, (MApiModelBuilder)((Object)model)));
    }

    protected void completeProcessDefault(ApiMetadataContext context, ApiMetadata m) {
        ApiConfig c = context.getConfig();
        m.getPaths().forEach((k, path) -> {
            for (MApiOperation op : path.getOperations()) {
                Route route = op.getRoute();
                if (null == route) continue;
                route.setExtension(MApiPath.class, path);
                route.setExtension(MApiOperation.class, (Object)op);
            }
        });
    }

    protected void postProcessModel(ApiMetadataContext context, ApiMetadataBuilder m, String name, MApiModelBuilder model) {
        this.postProcessModelInheritance(context, m, name, model);
    }

    protected void postProcessModelInheritance(ApiMetadataContext context, ApiMetadataBuilder m, String name, MApiModelBuilder model) {
        if (null != model.getJavaTypes()) {
            for (Class<?> javaType : model.getJavaTypes()) {
                if (null != model.getBaseName()) {
                    return;
                }
                Class<?> c = javaType.getSuperclass();
                if (Object.class.equals(c) || model.getJavaTypes().contains(c)) {
                    return;
                }
                MApiModelBuilder parent = m.tryGetModel(c);
                if (null == parent) continue;
                this.postProcessModelInheritance(context, m, name, parent);
                model.setBaseName(parent.getName());
                parent.getProperties().keySet().forEach(p -> model.removeProperty((String)p));
            }
        }
    }

    protected void createPaths(ApiMetadataContext context, ApiMetadataBuilder md) {
        for (ApiRoute ar : context.getConfig().getApiRoutes()) {
            if (!ar.isOperation()) continue;
            this.createApiPath(context, md, ar.getRoute());
        }
    }

    protected void createModels(ApiMetadataContext context, ApiMetadataBuilder m) {
        ApiConfig config = context.getConfig();
        config.getResourceTypes().values().forEach(t -> {
            if (null == m.tryGetModel((Class<?>)t)) {
                context.getMTypeContainer().getMType(t);
            }
        });
        config.getModelConfigs().forEach(c -> {
            if (!Strings.isEmpty((String)c.getClassName()) && null == m.tryGetModelByClassName(c.getClassName())) {
                context.getMTypeContainer().getMType(Classes.forName((String)c.getClassName()));
            }
        });
        config.getModels().forEach(model -> m.addModel((MApiModelBuilder)((Object)model)));
        config.getComplexTypes().forEach(ct -> this.tryAddModel(context, m, (MComplexType)ct));
        context.getMTypeContainer().getComplexTypes().forEach((type, ct) -> this.tryAddModel(context, m, (MComplexType)ct));
    }

    @Override
    public MApiModelBuilder tryAddModel(ApiMetadataContext context, ApiMetadataBuilder md, MComplexType ct) {
        String name = this.modelName(context, ct);
        MApiModelBuilder model = md.tryGetModel(name);
        if (null != model) {
            if (null != ct.getJavaType() && !model.getJavaTypes().contains(ct.getJavaType())) {
                model.addJavaType(ct.getJavaType());
            }
            return null;
        }
        model = new MApiModelBuilder(ct, name);
        model.getProperties().values().forEach(p -> {
            MComplexType complexType;
            if (p.getType().isComplexType() && null == md.tryGetModel((complexType = (MComplexType)p.getType()).getName())) {
                this.tryAddModel(context, md, ct);
            }
        });
        md.addModel(model);
        return model;
    }

    protected String modelName(ApiMetadataContext context, MComplexType ct) {
        if (null != ct.getJavaType()) {
            String name;
            ApiModel a = ct.getJavaType().getAnnotation(ApiModel.class);
            if (null != a && !Strings.isEmpty((String)(name = Strings.firstNotEmpty((String[])new String[]{a.name(), a.value()})))) {
                return name;
            }
            ModelConfig mc = context.getConfig().getModelConfig(ct.getJavaType());
            if (null != mc && !Strings.isEmpty((String)mc.getName())) {
                return mc.getName();
            }
        }
        return ct.getName();
    }

    protected void createApiPath(ApiMetadataContext context, ApiMetadataBuilder md, Route route) {
        MApiPathBuilder path;
        PathTemplate pt = route.getPathTemplate();
        String pathTemplate = Strings.removeStart((String)pt.getTemplate(), (String)md.getBasePath());
        if (!Strings.startsWith((String)pathTemplate, (String)"/")) {
            pathTemplate = "/" + pathTemplate;
        }
        if (null == (path = md.getPath(pathTemplate))) {
            path = new MApiPathBuilder();
            path.setPathTemplate(pathTemplate);
            md.addPath(path);
        }
        log.debug("Path {} -> {} :", new Object[]{pt, route.getAction()});
        path.addOperation(this.createOperation(context, md, route));
    }

    protected void setApiMethod(ApiMetadataContext context, ApiMetadataBuilder m, Route route, MApiOperationBuilder op) {
        String method = route.getMethod();
        if ("*".equals(method)) {
            boolean hasBodyParameter = false;
            for (Argument a : route.getAction().getArguments()) {
                if (a.getLocation() != Argument.Location.REQUEST_BODY && a.getLocation() != Argument.Location.PART_PARAM) continue;
                hasBodyParameter = true;
            }
            if (hasBodyParameter) {
                op.setMethod(HTTP.Method.POST);
            } else {
                op.setMethod(HTTP.Method.GET);
            }
        } else {
            op.setMethod(HTTP.Method.valueOf((String)method));
        }
    }

    protected void createApiSecurity(ApiMetadataContext context, ApiMetadataBuilder m, Route route, MApiOperationBuilder op) {
    }

    protected void createApiParameters(ApiMetadataContext context, ApiMetadataBuilder m, Route route, MApiOperationBuilder op) {
        Action action = route.getAction();
        log.trace("  Parameters({})", new Object[]{action.getArguments().length});
        for (Argument a : action.getArguments()) {
            MApiParameterBuilder p = (MApiParameterBuilder)((Object)a.getExtension(MApiParameterBuilder.class));
            if (null != p) {
                op.addParameter(p);
                continue;
            }
            if (a.isWrapper()) {
                this.createApiWrapperParameter(context, m, route, op, a);
                if (!a.isRequestBody()) continue;
            }
            if (a.isContextual()) continue;
            this.createApiParameter(context, m, route, op, a);
        }
    }

    protected void createApiWrapperParameter(ApiMetadataContext context, ApiMetadataBuilder m, Route route, MApiOperationBuilder op, Argument a) {
        for (Argument wa : a.getWrappedArguments()) {
            if (wa.isContextual()) continue;
            this.createApiParameter(context, m, route, op, wa).setWrapperArgument(a);
        }
    }

    protected MApiParameterBuilder createApiParameter(ApiMetadataContext context, ApiMetadataBuilder m, Route route, MApiOperationBuilder op, Argument a) {
        MApiParameterBuilder p = new MApiParameterBuilder();
        p.setName(a.getName());
        p.setArgument(a);
        log.trace("{}", new Object[]{a.getName(), p.getLocation()});
        if (this.isParameterFileType(a.getType())) {
            p.setType((MType)MSimpleTypes.BINARY);
            p.setFile(true);
            op.addConsume("multipart/form-data");
        } else {
            p.setType(this.createMType(context, m, route.getAction().getControllerClass(), a.getType(), a.getGenericType()));
        }
        p.setLocation(this.getParameterLocation(context, route.getAction(), a, op, p));
        if (null != a.getRequired()) {
            p.setRequired(a.getRequired());
        } else if (p.getLocation() == MApiParameter.Location.PATH) {
            p.setRequired(true);
        }
        if (a.getType().isEnum()) {
            p.setEnumValues(Enums.getValues((Class)a.getType()));
        }
        op.addParameter(p);
        return p;
    }

    protected void createApiResponses(ApiMetadataContext context, ApiMetadataBuilder m, Route route, MApiOperationBuilder op) {
        MApiResponseBuilder[] resps = (MApiResponseBuilder[])route.getAction().getExtension(MApiResponseBuilder[].class);
        if (null != resps && resps.length > 0) {
            for (MApiResponseBuilder resp : resps) {
                op.addResponse(resp);
            }
            return;
        }
        Response[] annotations = (Response[])route.getAction().getAnnotationsByType(Response.class);
        ArrayList<MApiResponseBuilder> responses = new ArrayList<MApiResponseBuilder>();
        if (annotations.length > 0) {
            for (Response a : annotations) {
                responses.add(this.createApiResponse(context, m, route, a));
            }
        }
        boolean hasSuccess = false;
        for (MApiResponseBuilder r : responses) {
            if (r.getStatus() < 200 || r.getStatus() >= 300) continue;
            hasSuccess = true;
        }
        if (responses.isEmpty() || !hasSuccess) {
            Integer status = route.getSuccessStatus();
            if (null == status) {
                status = 200;
            }
            if (route.getAction().hasReturnValue()) {
                Class returnType = route.getAction().getReturnType();
                Type genericReturnType = route.getAction().getGenericReturnType();
                MApiResponseBuilder resp = MApiResponseBuilder.success(status);
                this.resolveApiResponseType(context, m, route.getAction().getControllerClass(), returnType, genericReturnType, resp);
                op.addResponse(resp);
            } else {
                op.addResponse(MApiResponseBuilder.success(status));
            }
        }
        responses.forEach(op::addResponse);
    }

    protected void createOperationTags(ApiMetadataContext context, ApiMetadataBuilder m, Route route, MApiPathBuilder path, MApiOperationBuilder op) {
        Class<?> resourceType;
        if (null == route) {
            return;
        }
        MApiTag[] tags = (MApiTag[])route.getAction().removeExtension(MApiTag[].class);
        if (null != tags) {
            for (MApiTag tag : tags) {
                op.addTag(tag.getName());
                if (m.getTags().get(tag.getName()) != null) continue;
                m.addTag(tag);
            }
        }
        if (null != (resourceType = context.getConfig().getResourceTypes().get(route))) {
            MApiModelBuilder model = m.tryGetModel(resourceType);
            if (null != model) {
                op.addTag(model.getName());
                MApiTag tag = m.getTags().get(model.getName());
                if (null == tag) {
                    m.addTag(new MApiTag(model.getName(), model.getTitle(), model.getSummary(), model.getDescription(), null));
                }
            } else {
                op.addTag(resourceType.getSimpleName());
                MApiTag tag = m.getTags().get(resourceType.getSimpleName());
                if (null == tag) {
                    m.addTag(new MApiTag(resourceType.getSimpleName()));
                }
            }
        }
    }

    protected MApiResponseBuilder createApiResponse(ApiMetadataContext context, ApiMetadataBuilder m, Route route, Response a) {
        MApiResponseBuilder resp = new MApiResponseBuilder();
        resp.setStatus(a.status());
        if (!route.getAction().hasReturnValue()) {
            return resp;
        }
        Class returnType = a.type();
        Type genericType = a.genericType();
        if (Void.class.equals(returnType)) {
            returnType = route.getAction().getReturnType();
            genericType = route.getAction().getGenericReturnType();
        }
        this.resolveApiResponseType(context, m, route.getAction().getControllerClass(), returnType, genericType, resp);
        return resp;
    }

    protected void resolveApiResponseType(ApiMetadataContext context, ApiMetadataBuilder m, Class<?> declaringClass, Class<?> type, Type genericType, MApiResponseBuilder resp) {
        if (this.isResponseFileType(type)) {
            resp.setType((MType)MSimpleTypes.BINARY);
            resp.setFile(true);
        } else {
            resp.setType(this.createMType(context, m, declaringClass, type, genericType));
        }
    }

    protected MType createMType(ApiMetadataContext context, ApiMetadataBuilder m, Class<?> declaringClass, Class<?> type, Type genericType) {
        return context.getMTypeContainer().getMType(declaringClass, type, genericType);
    }

    protected MApiParameter.Location getParameterLocation(ApiMetadataContext context, Action action, Argument arg, MApiOperationBuilder o, MApiParameterBuilder p) {
        Argument.Location from = arg.getLocation();
        if (null == from || from == Argument.Location.UNDEFINED) {
            if (p.getType().isTypeRef() || p.getType().isCollectionType()) {
                return MApiParameter.Location.BODY;
            }
            if (o.getMethod() == HTTP.Method.GET) {
                return MApiParameter.Location.QUERY;
            }
            return MApiParameter.Location.FORM;
        }
        if (from == Argument.Location.QUERY_PARAM) {
            return MApiParameter.Location.QUERY;
        }
        if (from == Argument.Location.PATH_PARAM) {
            return MApiParameter.Location.PATH;
        }
        if (from == Argument.Location.HEADER_PARAM) {
            return MApiParameter.Location.HEADER;
        }
        if (from == Argument.Location.PART_PARAM) {
            return MApiParameter.Location.FORM;
        }
        if (from == Argument.Location.REQUEST_BODY) {
            return MApiParameter.Location.BODY;
        }
        if (from == Argument.Location.REQUEST_PARAM) {
            if (o.getMethod() == HTTP.Method.GET) {
                return MApiParameter.Location.QUERY;
            }
            return MApiParameter.Location.FORM;
        }
        throw new IllegalStateException("Unsupported location '" + from + "' by swagger in parameter '" + arg + "'");
    }

    protected boolean isParameterFileType(Class<?> c) {
        return PARAM_FILE_TYPES.contains(c);
    }

    protected boolean isResponseFileType(Class<?> c) {
        return File.class.equals(c);
    }

    static {
        PARAM_FILE_TYPES.add(Part.class);
        PARAM_FILE_TYPES.add(MultipartFile.class);
    }
}

