/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.meta;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import leap.lang.Args;
import leap.lang.Arrays2;
import leap.lang.Builders;
import leap.lang.Collections2;
import leap.lang.Strings;
import leap.lang.exception.ObjectExistsException;
import leap.web.api.meta.ApiMetadata;
import leap.web.api.meta.model.MApiContactBuilder;
import leap.web.api.meta.model.MApiExtension;
import leap.web.api.meta.model.MApiModelBuilder;
import leap.web.api.meta.model.MApiNamedWithDescBuilder;
import leap.web.api.meta.model.MApiPathBuilder;
import leap.web.api.meta.model.MApiPermission;
import leap.web.api.meta.model.MApiResponse;
import leap.web.api.meta.model.MApiResponseBuilder;
import leap.web.api.meta.model.MApiSecurityDef;
import leap.web.api.meta.model.MApiTag;

public class ApiMetadataBuilder
extends MApiNamedWithDescBuilder<ApiMetadata> {
    protected String basePath;
    protected String termsOfService;
    protected MApiContactBuilder contact;
    protected String version;
    protected String host;
    protected Set<String> protocols = new LinkedHashSet<String>();
    protected Set<String> consumes = new LinkedHashSet<String>();
    protected Set<String> produces = new LinkedHashSet<String>();
    protected Map<String, MApiResponseBuilder> responses = new LinkedHashMap<String, MApiResponseBuilder>();
    protected Map<String, MApiPathBuilder> paths = new TreeMap<String, MApiPathBuilder>(String.CASE_INSENSITIVE_ORDER);
    protected Map<String, MApiModelBuilder> models = new TreeMap<String, MApiModelBuilder>(String.CASE_INSENSITIVE_ORDER);
    protected Map<String, MApiPermission> permissions = new LinkedHashMap<String, MApiPermission>();
    protected Map<String, MApiTag> tags = new LinkedHashMap<String, MApiTag>();
    protected List<MApiSecurityDef> securityDefs = new ArrayList<MApiSecurityDef>();
    protected Set<String> operationIds = new HashSet<String>();
    protected MApiExtension extension;

    public ApiMetadataBuilder() {
    }

    public ApiMetadataBuilder(String basePath) {
        this.basePath = basePath;
    }

    public ApiMetadataBuilder withPathMap(Map<String, MApiPathBuilder> map) {
        this.paths = map;
        return this;
    }

    public ApiMetadataBuilder withModelMap(Map<String, MApiModelBuilder> map) {
        this.models = map;
        return this;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getTermsOfService() {
        return this.termsOfService;
    }

    public void setTermsOfService(String termsOfService) {
        this.termsOfService = termsOfService;
    }

    public MApiContactBuilder getContact() {
        return this.contact;
    }

    public void setContact(MApiContactBuilder contact) {
        this.contact = contact;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Set<String> getProtocols() {
        return this.protocols;
    }

    public void addProtocol(String p) {
        this.protocols.add(p);
    }

    public void addProtocols(String ... ps) {
        Collections2.addAll(this.protocols, (Object[])ps);
    }

    public Set<String> getConsumes() {
        return this.consumes;
    }

    public void addConsume(String mimeType) {
        this.consumes.add(mimeType);
    }

    public void addConsumes(String ... cs) {
        Collections2.addAll(this.consumes, (Object[])cs);
    }

    public Set<String> getProduces() {
        return this.produces;
    }

    public void addProduce(String mimeType) {
        this.produces.add(mimeType);
    }

    public void addProduces(String ... ps) {
        Collections2.addAll(this.produces, (Object[])ps);
    }

    public Map<String, MApiResponseBuilder> getResponses() {
        return this.responses;
    }

    public void putResponse(String name, MApiResponseBuilder r) {
        this.responses.put(name, r);
    }

    public void putResponse(String name, MApiResponse r) {
        this.putResponse(name, new MApiResponseBuilder(r));
    }

    public void setResponses(Map<String, MApiResponseBuilder> responses) {
        this.responses = responses;
    }

    public void addPath(MApiPathBuilder path) throws ObjectExistsException {
        Args.notNull((Object)path, (String)"api path");
        Args.notEmpty((String)path.getPathTemplate(), (String)"path template");
        if (this.paths.containsKey(path.getPathTemplate())) {
            throw new ObjectExistsException("The path template '" + path.getPathTemplate() + "' already exists");
        }
        this.paths.put(path.getPathTemplate(), path);
    }

    public Map<String, MApiPathBuilder> getPaths() {
        return this.paths;
    }

    public MApiPathBuilder getPath(String pathTemplate) {
        Args.notEmpty((String)pathTemplate, (String)"path template");
        return this.paths.get(pathTemplate);
    }

    public MApiPathBuilder getOrAddPath(String pathTemplate) {
        MApiPathBuilder path = this.getPath(pathTemplate);
        if (null == path) {
            path = new MApiPathBuilder();
            path.setPathTemplate(pathTemplate);
            this.addPath(path);
        }
        return path;
    }

    public MApiPathBuilder addPath(String pathTemplate) {
        MApiPathBuilder path = new MApiPathBuilder();
        path.setPathTemplate(pathTemplate);
        this.addPath(path);
        return path;
    }

    public Map<String, MApiModelBuilder> getModels() {
        return this.models;
    }

    public void addModel(MApiModelBuilder model) throws ObjectExistsException {
        Args.notNull((Object)((Object)model), (String)"model");
        if (this.models.containsKey(model.getName())) {
            throw new ObjectExistsException("The model '" + model.getName() + "' already exists");
        }
        this.models.put(model.getName(), model);
    }

    public boolean containsModel(String name) {
        return this.models.containsKey(name);
    }

    public Map<String, MApiPermission> getPermissions() {
        return this.permissions;
    }

    public void addPermission(MApiPermission p) {
        if (this.permissions.containsKey(p.getValue())) {
            throw new IllegalStateException("Permission '" + p.getValue() + "' already exists!");
        }
        this.permissions.put(p.getValue(), p);
    }

    public List<MApiSecurityDef> getSecurityDefs() {
        return this.securityDefs;
    }

    public void addSecurityDef(MApiSecurityDef def) {
        this.securityDefs.add(def);
    }

    public Map<String, MApiTag> getTags() {
        return this.tags;
    }

    public void addTag(MApiTag tag) {
        if (this.tags.containsKey(tag.getName())) {
            throw new IllegalStateException("Tag '" + tag.getName() + "' already exists!");
        }
        this.tags.put(tag.getName(), tag);
    }

    public boolean hasModel(String name) {
        for (MApiModelBuilder m : this.models.values()) {
            if (!name.equals(m.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasModel(Class<?> type) {
        return this.tryGetModel(type) != null;
    }

    public MApiModelBuilder tryGetModel(String name) {
        if (Strings.isEmpty((String)name)) {
            return null;
        }
        for (MApiModelBuilder m : this.models.values()) {
            if (!name.equalsIgnoreCase(m.getName())) continue;
            return m;
        }
        return null;
    }

    public MApiModelBuilder tryGetModel(Class<?> type) {
        if (null == type) {
            return null;
        }
        for (MApiModelBuilder m : this.models.values()) {
            for (Class<?> javaType : m.getJavaTypes()) {
                if (!type.equals(javaType)) continue;
                return m;
            }
        }
        return null;
    }

    public MApiModelBuilder tryGetModelByClassName(String className) {
        if (Strings.isEmpty((String)className)) {
            return null;
        }
        for (MApiModelBuilder m : this.models.values()) {
            for (Class<?> javaType : m.getJavaTypes()) {
                if (!javaType.getName().equals(className)) continue;
                return m;
            }
        }
        return null;
    }

    public Set<String> getOperationIds() {
        return this.operationIds;
    }

    public MApiExtension getExtension() {
        return this.extension;
    }

    public void setExtension(MApiExtension extension) {
        this.extension = extension;
    }

    public ApiMetadata build() {
        MApiPermission[] permissions = this.permissions.values().toArray(new MApiPermission[0]);
        MApiTag[] tags = this.tags.values().toArray(new MApiTag[0]);
        return new ApiMetadata(this.name, this.title, this.summary, this.description, this.termsOfService, null == this.contact ? null : this.contact.build(), this.version, this.host, this.basePath, this.protocols.toArray(Arrays2.EMPTY_STRING_ARRAY), this.consumes.toArray(Arrays2.EMPTY_STRING_ARRAY), this.produces.toArray(Arrays2.EMPTY_STRING_ARRAY), Builders.buildMap(this.responses), Builders.buildMap(this.paths), Builders.buildMap(this.models), permissions, this.securityDefs.toArray(new MApiSecurityDef[0]), tags, this.extension, this.attrs);
    }
}

