/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.meta;

import java.util.Collections;
import java.util.Map;
import leap.lang.exception.ObjectNotFoundException;
import leap.lang.http.HTTP;
import leap.web.api.meta.model.MApiContact;
import leap.web.api.meta.model.MApiExtension;
import leap.web.api.meta.model.MApiModel;
import leap.web.api.meta.model.MApiNamedWithDesc;
import leap.web.api.meta.model.MApiOperation;
import leap.web.api.meta.model.MApiPath;
import leap.web.api.meta.model.MApiPermission;
import leap.web.api.meta.model.MApiResponse;
import leap.web.api.meta.model.MApiSecurityDef;
import leap.web.api.meta.model.MApiTag;

public class ApiMetadata
extends MApiNamedWithDesc {
    protected final String termsOfService;
    protected final MApiContact concat;
    protected final String version;
    protected final String host;
    protected final String basePath;
    protected final String[] protocols;
    protected final String[] consumes;
    protected final String[] produces;
    protected final Map<String, MApiResponse> responses;
    protected final Map<String, MApiPath> paths;
    protected final Map<String, MApiModel> models;
    protected final MApiPermission[] permissions;
    protected final MApiSecurityDef[] securityDefs;
    protected final MApiTag[] tags;
    protected final MApiExtension extension;

    public ApiMetadata(String name, String title, String summary, String description, String termsOfService, MApiContact concat, String version, String host, String basePath, String[] protocols, String[] consumes, String[] produces, Map<String, MApiResponse> responses, Map<String, MApiPath> paths, Map<String, MApiModel> models, MApiPermission[] permissions, MApiSecurityDef[] securityDefs, MApiTag[] tags, MApiExtension extension, Map<String, Object> attrs) {
        super(name, title, summary, description, attrs);
        this.termsOfService = termsOfService;
        this.concat = concat;
        this.version = version;
        this.host = host;
        this.basePath = basePath;
        this.protocols = protocols;
        this.consumes = consumes;
        this.produces = produces;
        this.responses = Collections.unmodifiableMap(responses);
        this.paths = Collections.unmodifiableMap(paths);
        this.models = Collections.unmodifiableMap(models);
        this.permissions = permissions;
        this.securityDefs = securityDefs;
        this.tags = tags;
        this.extension = extension;
    }

    public String getTermsOfService() {
        return this.termsOfService;
    }

    public MApiContact getConcat() {
        return this.concat;
    }

    public String getVersion() {
        return this.version;
    }

    public String getHost() {
        return this.host;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String[] getProtocols() {
        return this.protocols;
    }

    public String[] getConsumes() {
        return this.consumes;
    }

    public String[] getProduces() {
        return this.produces;
    }

    public Map<String, MApiResponse> getResponses() {
        return this.responses;
    }

    public Map<String, MApiPath> getPaths() {
        return this.paths;
    }

    public MApiPath getPath(String pathTemplate) {
        MApiPath p = this.paths.get(pathTemplate);
        if (null == p) {
            throw new ObjectNotFoundException("The path '" + pathTemplate + "' not exists!");
        }
        return p;
    }

    public MApiOperation getOperation(String path, HTTP.Method method) {
        return this.getPath(path).getOperation(method);
    }

    public MApiOperation getOperation(String path, String method) {
        return this.getPath(path).getOperation(HTTP.Method.valueOf((String)method));
    }

    public Map<String, MApiModel> getModels() {
        return this.models;
    }

    public MApiModel tryGetModel(String name) {
        return this.models.get(name);
    }

    public MApiModel tryGetModel(Class<?> type) {
        for (MApiModel m : this.models.values()) {
            for (Class<?> javaType : m.getJavaTypes()) {
                if (!type.equals(javaType)) continue;
                return m;
            }
        }
        return null;
    }

    public MApiModel getModel(String name) {
        MApiModel m = this.models.get(name);
        if (null == m) {
            throw new ObjectNotFoundException("The model '" + name + "' not exists!");
        }
        return m;
    }

    public MApiModel getModel(Class<?> type) {
        MApiModel m = this.tryGetModel(type);
        if (null != m) {
            return m;
        }
        throw new ObjectNotFoundException("No api model of type '" + type + "'");
    }

    public MApiPermission[] getPermissions() {
        return this.permissions;
    }

    public MApiSecurityDef[] getSecurityDefs() {
        return this.securityDefs;
    }

    public MApiTag[] getTags() {
        return this.tags;
    }

    public MApiExtension getExtension() {
        return this.extension;
    }
}

