/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.dyna;

import leap.core.annotation.Inject;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.web.App;
import leap.web.api.Api;
import leap.web.api.Apis;
import leap.web.api.config.ApiConfig;
import leap.web.api.dyna.DefaultDynaApi;
import leap.web.api.dyna.DynaApi;
import leap.web.api.dyna.DynaApiFactory;
import leap.web.route.RoutesPrinter;

public class DefaultDynaApiFactory
implements DynaApiFactory {
    private static final Log log = LogFactory.get(DefaultDynaApiFactory.class);
    @Inject
    protected Apis apis;
    @Inject
    protected App app;
    @Inject
    protected RoutesPrinter routesPrinter;

    @Override
    public DynaApi newDynaApi(String name, String basePath, boolean register) {
        Api api = this.apis.newDynamic(name, basePath);
        if (register) {
            this.apis.add(api);
        }
        return new DefaultDynaApi(api);
    }

    @Override
    public void destroyDynaApi(DynaApi api) {
        ApiConfig config = api.getConfig();
        if (log.isDebugEnabled()) {
            log.debug("Routes before destroying api '{}': \n\n{}\n", new Object[]{api.getName(), this.routesPrinter.print((Iterable)this.app.routes())});
        }
        config.getApiRoutes().forEach(ar -> {
            if (ar.isDynamic()) {
                this.app.routes().remove(ar.getRoute());
            }
        });
        if (log.isDebugEnabled()) {
            log.debug("Routes after destroying api '{}': \n\n{}\n", new Object[]{api.getName(), this.routesPrinter.print((Iterable)this.app.routes())});
        }
        this.apis.remove(api);
    }
}

