/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.doc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import leap.core.annotation.Inject;
import leap.core.doc.DocResolver;
import leap.lang.Classes;
import leap.lang.Exceptions;
import leap.lang.Strings;
import leap.lang.beans.BeanProperty;
import leap.lang.reflect.ReflectMethod;
import leap.lang.resource.Resource;
import leap.lang.resource.Resources;
import leap.web.action.Argument;
import leap.web.api.config.ApiConfigException;
import leap.web.api.meta.ApiMetadataBuilder;
import leap.web.api.meta.ApiMetadataContext;
import leap.web.api.meta.ApiMetadataProcessor;
import leap.web.api.meta.model.MApiModelBuilder;
import leap.web.api.meta.model.MApiOperationBuilder;
import leap.web.api.meta.model.MApiParameterBuilder;
import leap.web.api.meta.model.MApiPropertyBuilder;
import leap.web.api.meta.model.MApiResponseBuilder;

public class ConventionalDocProcessor
implements ApiMetadataProcessor {
    @Inject
    private DocResolver docResolver;
    private static final String CLASSPATH_PREFIX = "classpath:doc/";

    @Override
    public void postProcess(ApiMetadataContext context, ApiMetadataBuilder m) {
        String desc = m.getDescription();
        if (Strings.isNotEmpty((String)desc)) {
            m.setDescription(this.docResolver.resolveDesc(desc));
        }
        HashMap docs = new HashMap();
        m.getPaths().forEach((k, p) -> p.getOperations().forEach(o -> this.processOperation(context, docs, (MApiOperationBuilder)((Object)((Object)o)))));
        m.getModels().forEach((k, model) -> this.processModel(context, docs, (MApiModelBuilder)((Object)model)));
    }

    protected void processOperation(ApiMetadataContext context, Map<Class<?>, ClassDoc> docs, MApiOperationBuilder o) {
        ReflectMethod method = o.getRoute().getAction().getMethod();
        if (null != method) {
            ClassDoc cdoc = this.resolveClassDoc(docs, method.getDeclaringClass(), false);
            MethodDoc mdoc = cdoc.methods.get(method.getName());
            if (null != mdoc) {
                if (!Strings.isEmpty((String)mdoc.description)) {
                    o.setDescription(mdoc.description);
                }
                if (!Strings.isEmpty((String)mdoc.response)) {
                    for (MApiResponseBuilder resp : o.getResponses()) {
                        if (resp.getStatus() < 200 || resp.getStatus() >= 300) continue;
                        resp.setDescription(mdoc.response);
                        break;
                    }
                }
                o.getParameters().forEach(param -> this.processParameter(context, docs, mdoc, (MApiParameterBuilder)((Object)param), method));
            }
        }
    }

    protected void processParameter(ApiMetadataContext context, Map<Class<?>, ClassDoc> docs, MethodDoc doc, MApiParameterBuilder param, ReflectMethod method) {
        Argument a = param.getArgument();
        if (null != a) {
            if (null != param.getWrapperArgument()) {
                ClassDoc wrapperDoc = this.resolveClassDoc(docs, param.getWrapperArgument().getType(), true);
                String desc = wrapperDoc.properties.get(a.getDeclaredName());
                if (!Strings.isEmpty((String)desc)) {
                    param.setDescription(desc);
                }
            } else {
                String desc = doc.params.get(a.getDeclaredName());
                if (!Strings.isEmpty((String)desc)) {
                    param.setDescription(desc);
                }
            }
        }
    }

    protected void processModel(ApiMetadataContext context, Map<Class<?>, ClassDoc> docs, MApiModelBuilder model) {
        for (Class<?> c : model.getJavaTypes()) {
            ClassDoc doc = this.resolveClassDoc(docs, c, true);
            if (!Strings.isEmpty((String)doc.description)) {
                model.setDescription(doc.description);
            }
            model.getProperties().forEach((k, p) -> this.processProperty(context, doc, (MApiPropertyBuilder)((Object)p)));
        }
    }

    protected void processProperty(ApiMetadataContext context, ClassDoc doc, MApiPropertyBuilder p) {
        String desc;
        BeanProperty bp = p.getBeanProperty();
        if (null != bp && !Strings.isEmpty((String)(desc = doc.properties.get(bp.getName())))) {
            p.setDescription(desc);
        }
    }

    protected ClassDoc resolveClassDoc(Map<Class<?>, ClassDoc> docs, Class<?> cls, boolean properties) {
        ClassDoc doc = docs.get(cls);
        if (null == doc) {
            for (String file : this.getCandidateDocFiles(cls)) {
                String loc = CLASSPATH_PREFIX + file;
                Resource resource = Resources.getResource((String)loc);
                if (!resource.exists()) continue;
                doc = this.readClassDoc(cls, resource, properties);
                break;
            }
            if (null == doc) {
                doc = ClassDoc.EMPTY;
            }
            docs.put(cls, doc);
        }
        return doc;
    }

    protected ClassDoc readClassDoc(Class<?> cls, Resource resource, boolean properties) {
        ClassDoc doc = new ClassDoc(cls);
        doc.parse(resource.getURLString(), resource.getContent(), properties);
        return doc;
    }

    protected Set<String> getCandidateDocFiles(Class<?> cls) {
        LinkedHashSet<String> files = new LinkedHashSet<String>();
        String pkg = Classes.getPackageName(cls);
        if (!Strings.isEmpty((String)pkg)) {
            String[] parts = Strings.split((String)pkg, (char)'.');
            for (int i = 0; i < parts.length; ++i) {
                StringBuilder dir = new StringBuilder();
                for (int j = i; j < parts.length; ++j) {
                    if (j > i) {
                        dir.append('/');
                    }
                    dir.append(parts[j]);
                }
                files.add(dir.toString() + "/" + cls.getSimpleName() + ".md");
            }
        }
        files.add(cls.getSimpleName() + ".md");
        return files;
    }

    protected static boolean isHead1(String line) {
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return c == '#' && ++i < line.length() && line.charAt(i) != '#';
        }
        return false;
    }

    protected static boolean isHead2(String line) {
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return c == '#' && ++i < line.length() && line.charAt(i) == '#' && (++i == line.length() - 1 || line.charAt(i) != '#');
        }
        return false;
    }

    protected static final class MethodDoc {
        protected String description;
        protected Map<String, String> params = new HashMap<String, String>();
        protected String response;
        private String url;
        private int curr;

        public MethodDoc(String url, int curr) {
            this.url = url;
            this.curr = curr;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Map<String, String> getParams() {
            return this.params;
        }

        public void setParams(Map<String, String> params) {
            this.params = params;
        }

        public String getResponse() {
            return this.response;
        }

        public void setResponse(String response) {
            this.response = response;
        }

        protected int parse(String[] lines) {
            this.readDescription(lines);
            this.readParams(lines);
            this.readResponse(lines);
            return this.curr;
        }

        protected void readDescription(String[] lines) {
            this.description = this.readContent(lines);
        }

        protected void readParams(String[] lines) {
            int i;
            if (this.isEOF(lines) || !ConventionalDocProcessor.isHead2(lines[this.curr])) {
                return;
            }
            for (i = this.curr; i < lines.length; ++i) {
                if (!this.readParam(lines)) {
                    return;
                }
                if (this.curr >= lines.length - 1 || ConventionalDocProcessor.isHead1(lines[this.curr])) {
                    return;
                }
                i = this.curr;
            }
            this.curr = i;
        }

        protected boolean readParam(String[] lines) {
            String line = lines[this.curr].trim().substring(2).trim();
            if (Strings.startsWithIgnoreCase((String)line, (String)"response")) {
                return false;
            }
            if (Strings.startsWithIgnoreCase((String)line, (String)"param")) {
                line = Strings.removeStartIgnoreCase((String)line, (String)"param").trim();
                String name = line.substring(1).trim();
                String desc = this.readContent(lines);
                this.params.put(name, desc);
                return true;
            }
            throw new ApiConfigException("Invalid param line '" + lines[this.curr] + "' at file :" + this.url);
        }

        protected void readResponse(String[] lines) {
            if (!this.isEOF(lines) && ConventionalDocProcessor.isHead2(lines[this.curr])) {
                String line = lines[this.curr].substring(2).trim();
                if (Strings.startsWithIgnoreCase((String)line, (String)"response")) {
                    if (Strings.startsWithIgnoreCase((String)line, (String)"response")) {
                        this.response = this.readContent(lines);
                    }
                } else {
                    throw new ApiConfigException("Invalid response line '" + lines[this.curr] + "' at file :" + this.url);
                }
            }
        }

        protected String readContent(String[] lines) {
            int i;
            StringBuilder s = new StringBuilder();
            for (i = this.curr + 1; i < lines.length && !ConventionalDocProcessor.isHead1(lines[i]) && !ConventionalDocProcessor.isHead2(lines[i]); ++i) {
                s.append(lines[i]).append('\n');
            }
            this.curr = i;
            return s.toString().trim();
        }

        protected boolean isEOF(String[] lines) {
            return this.curr >= lines.length;
        }
    }

    protected static final class ClassDoc {
        static final ClassDoc EMPTY = new ClassDoc(null);
        protected Class<?> cls;
        protected String description;
        protected Map<String, MethodDoc> methods = new HashMap<String, MethodDoc>();
        protected Map<String, String> properties = new HashMap<String, String>();

        public ClassDoc(Class<?> cls) {
            this.cls = cls;
        }

        protected void parse(String url, String content, boolean forProperties) {
            String[] lines = this.readLines(content);
            boolean classEnd = false;
            StringBuilder classDesc = new StringBuilder();
            for (int i = 0; i < lines.length; ++i) {
                if (ConventionalDocProcessor.isHead1(lines[i])) {
                    classEnd = true;
                    if (forProperties) {
                        String prop = lines[i].trim().substring(1).trim();
                        ++i;
                        StringBuilder s = new StringBuilder();
                        while (i < lines.length && !ConventionalDocProcessor.isHead1(lines[i])) {
                            s.append(lines[i]).append('\n');
                            ++i;
                        }
                        this.properties.put(prop, s.toString().trim());
                        continue;
                    }
                    String method = lines[i].trim().substring(1).trim();
                    boolean exists = false;
                    for (Method m : this.cls.getMethods()) {
                        if (!m.getName().equals(method)) continue;
                        exists = true;
                        break;
                    }
                    if (!exists) {
                        throw new ApiConfigException("Method '" + method + "' not exists in class '" + this.cls.getName() + ", check file : " + url);
                    }
                    MethodDoc doc = new MethodDoc(url, i);
                    i = doc.parse(lines) - 1;
                    this.methods.put(method, doc);
                    continue;
                }
                if (classEnd) continue;
                classDesc.append(lines[i]).append('\n');
            }
            this.description = classDesc.toString().trim();
        }

        protected String[] readLines(String content) {
            BufferedReader reader = new BufferedReader(new StringReader(content));
            ArrayList<String> lines = new ArrayList<String>();
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    lines.add(line);
                }
            }
            catch (IOException e) {
                throw Exceptions.uncheck((Throwable)e);
            }
            return lines.toArray(new String[lines.size()]);
        }
    }
}

