/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.doc;

import leap.lang.Described;
import leap.lang.Titled;
import leap.web.api.config.model.ModelConfig;
import leap.web.api.config.model.ParamConfig;
import leap.web.api.doc.ConventionalDocProcessor;
import leap.web.api.meta.ApiMetadataBuilder;
import leap.web.api.meta.ApiMetadataContext;
import leap.web.api.meta.ApiMetadataProcessor;
import leap.web.api.meta.model.MApiModelBuilder;
import leap.web.api.meta.model.MApiParameterBaseBuilder;
import leap.web.api.meta.model.MApiParameterBuilder;
import leap.web.api.meta.model.MApiPropertyBuilder;

public class ConfigDocProcessor
implements ApiMetadataProcessor {
    protected ConventionalDocProcessor conventionalProcessor;

    public void setConventionalProcessor(ConventionalDocProcessor conventionalProcessor) {
        this.conventionalProcessor = conventionalProcessor;
    }

    @Override
    public void postProcess(ApiMetadataContext context, ApiMetadataBuilder m) {
        this.conventionalProcessor.postProcess(context, m);
        m.getPaths().forEach((k, p) -> p.getOperations().forEach(o -> o.getParameters().forEach(param -> this.processParameter(context, (MApiParameterBuilder)((Object)((Object)((Object)param)))))));
        m.getModels().forEach((k, model) -> this.processModel(context, (MApiModelBuilder)((Object)model)));
    }

    protected void processParameter(ApiMetadataContext context, MApiParameterBuilder p) {
        ParamConfig wrapperParam;
        ParamConfig pc = null;
        if (null != p.getWrapperArgument() && null != (wrapperParam = context.getConfig().getParam(p.getWrapperArgument().getType())) && null == (pc = wrapperParam.getWrappedParam(p.getArgument().getDeclaredName()))) {
            pc = wrapperParam.getWrappedParam(p.getName());
        }
        this.trySetDoc(p, pc, pc);
    }

    protected void processModel(ApiMetadataContext context, MApiModelBuilder m) {
        ModelConfig mc = null;
        for (Class<?> javaType : m.getJavaTypes()) {
            mc = context.getConfig().getModelConfig(javaType);
            if (null == mc) continue;
            break;
        }
        if (null == mc) {
            mc = context.getConfig().getModelConfig(m.getName());
        }
        for (MApiPropertyBuilder p : m.getProperties().values()) {
            ModelConfig.Property c = null == mc ? null : mc.getProperty(p.getName());
            this.trySetDoc(p, c, c);
        }
    }

    protected void trySetDoc(MApiParameterBaseBuilder p, Titled titled, Described described) {
        if (null != titled) {
            p.trySetTitle(titled.getTitle());
        }
        if (null != described) {
            p.trySetSummary(described.getSummary());
            p.trySetDescription(described.getDescription());
        }
    }
}

