/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.doc;

import java.lang.reflect.Method;
import leap.core.annotation.Inject;
import leap.core.doc.DocResolver;
import leap.core.doc.annotation.Doc;
import leap.lang.Strings;
import leap.lang.beans.BeanProperty;
import leap.lang.meta.MNamedWithDescBuilder;
import leap.lang.reflect.ReflectMethod;
import leap.lang.reflect.ReflectParameter;
import leap.web.action.Argument;
import leap.web.api.meta.ApiMetadataBuilder;
import leap.web.api.meta.ApiMetadataContext;
import leap.web.api.meta.ApiMetadataProcessor;
import leap.web.api.meta.model.MApiModelBuilder;
import leap.web.api.meta.model.MApiOperationBuilder;
import leap.web.api.meta.model.MApiParameterBuilder;
import leap.web.api.meta.model.MApiPropertyBuilder;

public class AnnotationDocProcessor
implements ApiMetadataProcessor {
    @Inject
    protected DocResolver docResolver;

    @Override
    public void preProcess(ApiMetadataContext context, ApiMetadataBuilder m) {
        m.getPaths().forEach((k, p) -> p.getOperations().forEach(o -> this.processOperation(context, (MApiOperationBuilder)((Object)((Object)o)))));
        m.getModels().forEach((k, model) -> this.processModel(context, (MApiModelBuilder)((Object)model)));
    }

    protected void processOperation(ApiMetadataContext context, MApiOperationBuilder o) {
        ReflectMethod method = o.getRoute().getAction().getMethod();
        if (null != method) {
            Doc doc = (Doc)method.getAnnotation(Doc.class);
            if (null == doc) {
                doc = this.searchUp(method);
            }
            if (null != doc) {
                this.resolveDoc(context, o, doc);
            }
        }
        o.getParameters().forEach(param -> this.processParameter(context, (MApiParameterBuilder)((Object)param), method));
    }

    protected void processParameter(ApiMetadataContext context, MApiParameterBuilder param, ReflectMethod method) {
        Argument a = param.getArgument();
        if (null != a) {
            Doc doc = (Doc)param.getArgument().getAnnotation(Doc.class);
            if (null == doc && null == param.getWrapperArgument() && null != method && null != a.getParameter()) {
                doc = this.searchUp(method, a.getParameter());
            }
            if (null != doc) {
                this.resolveDoc(context, param, doc);
            }
        }
    }

    protected void processModel(ApiMetadataContext context, MApiModelBuilder model) {
        for (Class<?> c : model.getJavaTypes()) {
            Doc doc = c.getAnnotation(Doc.class);
            if (null == doc) continue;
            this.resolveDoc(context, model, doc);
        }
        model.getProperties().forEach((k, p) -> this.processProperty(context, (MApiPropertyBuilder)((Object)p)));
    }

    protected void processProperty(ApiMetadataContext context, MApiPropertyBuilder p) {
        Doc doc;
        BeanProperty bp = p.getBeanProperty();
        if (null != bp && null != (doc = (Doc)bp.getAnnotation(Doc.class))) {
            this.resolveDoc(context, p, doc);
        }
    }

    protected Doc searchUp(ReflectMethod m) {
        Class<?> c = m.getReflectedMethod().getDeclaringClass();
        for (Class<?> ic : c.getInterfaces()) {
            try {
                Method im = ic.getMethod(m.getName(), m.getReflectedMethod().getParameterTypes());
                return im.getAnnotation(Doc.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return null;
    }

    protected Doc searchUp(ReflectMethod m, ReflectParameter p) {
        Class<?> c = m.getReflectedMethod().getDeclaringClass();
        for (Class<?> ic : c.getInterfaces()) {
            try {
                Method im = ic.getMethod(m.getName(), m.getReflectedMethod().getParameterTypes());
                return im.getParameters()[p.getIndex() - 1].getAnnotation(Doc.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return null;
    }

    protected void resolveDoc(ApiMetadataContext context, MNamedWithDescBuilder o, Doc a) {
        String summary = Strings.firstNotEmpty((String[])new String[]{a.summary(), a.value()});
        if (Strings.isEmpty((String)o.getSummary()) && !Strings.isEmpty((String)summary)) {
            o.setSummary(this.docResolver.resolveDesc(summary));
        }
        String desc = a.desc();
        if (Strings.isEmpty((String)o.getDescription()) && !Strings.isEmpty((String)desc)) {
            o.setDescription(this.docResolver.resolveDesc(desc));
        }
    }
}

