/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.config.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import leap.lang.accessor.MapAttributeAccessor;
import leap.lang.exception.ObjectExistsException;
import leap.orm.OrmContext;
import leap.web.api.meta.model.MApiOperationBuilder;
import leap.web.api.restd.RestdOperationDef;

public class RestdConfig {
    protected String dataSourceName;
    protected OrmContext ormContext;
    protected boolean autoConfigureEntities = true;
    protected boolean readonly;
    protected boolean noDataSource;
    protected boolean allowRemoteEntity;
    protected Set<String> includedModels = new LinkedHashSet<String>();
    protected Set<String> excludedModels = new LinkedHashSet<String>();
    protected Set<String> readonlyModels = new HashSet<String>();
    protected List<Operation> operations = new ArrayList<Operation>();
    protected Map<String, Model> models = new LinkedHashMap<String, Model>();

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public OrmContext getOrmContext() {
        return this.ormContext;
    }

    public void setOrmContext(OrmContext ormContext) {
        this.ormContext = ormContext;
    }

    public boolean isAutoConfigureEntities() {
        return this.autoConfigureEntities;
    }

    public void setAutoConfigureEntities(boolean autoConfigureEntities) {
        this.autoConfigureEntities = autoConfigureEntities;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isNoDataSource() {
        return this.noDataSource;
    }

    public void setNoDataSource(boolean noDataSource) {
        this.noDataSource = noDataSource;
    }

    public boolean isAllowRemoteEntity() {
        return this.allowRemoteEntity;
    }

    public void setAllowRemoteEntity(boolean allowRemoteEntity) {
        this.allowRemoteEntity = allowRemoteEntity;
    }

    public Set<String> getIncludedModels() {
        return this.includedModels;
    }

    public void addIncludedModel(String name) {
        this.includedModels.add(name);
    }

    public Set<String> getExcludedModels() {
        return this.excludedModels;
    }

    public void addExcludedModel(String name) {
        this.excludedModels.add(name);
    }

    public Set<String> getReadonlyModels() {
        return this.readonlyModels;
    }

    public void addReadonlyModel(String name) {
        this.readonlyModels.add(name.toLowerCase());
    }

    public boolean isReadonlyModel(String name) {
        return this.readonlyModels.contains(name.toLowerCase());
    }

    public Map<String, Model> getModels() {
        return this.models;
    }

    public Model getModel(String name) {
        return this.models.get(name.toLowerCase());
    }

    public void addModel(Model model) {
        String key = model.getName().toLowerCase();
        if (this.models.containsKey(key)) {
            throw new ObjectExistsException("The configuration of model '" + model.getName() + "' already exists!");
        }
        this.models.put(key, model);
    }

    public List<Operation> getOperations() {
        return this.operations;
    }

    public void addOperation(Operation op) {
        this.operations.add(op);
    }

    public boolean isModelAnonymous(String name) {
        Model model = this.getModel(name);
        if (null != model && null != model.getAnonymous()) {
            return model.getAnonymous();
        }
        return false;
    }

    public boolean allowCreateModel(String name) {
        Model model = this.getModel(name);
        if (null != model && null != model.getCreateOperationEnabled()) {
            return model.getCreateOperationEnabled();
        }
        return !this.readonly;
    }

    public boolean allowUpdateModel(String name) {
        Model model = this.getModel(name);
        if (null != model && null != model.getUpdateOperationEnabled()) {
            return model.getUpdateOperationEnabled();
        }
        return !this.readonly;
    }

    public boolean allowDeleteModel(String name) {
        Model model = this.getModel(name);
        if (null != model && null != model.getDeleteOperationEnabled()) {
            return model.getDeleteOperationEnabled();
        }
        return !this.readonly;
    }

    public boolean allowFindModel(String name) {
        Model model = this.getModel(name);
        if (null != model && null != model.getFindOperationEnabled()) {
            return model.getFindOperationEnabled();
        }
        return true;
    }

    public boolean allowQueryModel(String name) {
        Model model = this.getModel(name);
        if (null != model && null != model.getQueryOperationEnabled()) {
            return model.getQueryOperationEnabled();
        }
        return true;
    }

    public boolean allowCountModel(String name) {
        Model model = this.getModel(name);
        if (null != model && null != model.getCountOperationEnabled()) {
            return model.getCountOperationEnabled();
        }
        return true;
    }

    public boolean allowModelOperation(String name, String operation) {
        Model model = this.getModel(name);
        if (null != model) {
            return model.isEnabled(operation);
        }
        return false;
    }

    public static class Operation
    implements RestdOperationDef {
        private Object source;
        private String name;
        private String type;
        private String path;
        private String script;
        private String scriptPath;
        private Boolean prior;
        private MApiOperationBuilder metaOperation;
        private Map<String, Object> arguments = new LinkedHashMap<String, Object>();

        public Object getSource() {
            return this.source;
        }

        public void setSource(Object source) {
            this.source = source;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        @Override
        public String getScript() {
            return this.script;
        }

        public void setScript(String script) {
            this.script = script;
        }

        @Override
        public Boolean getPrior() {
            return this.prior;
        }

        public void setPrior(Boolean prior) {
            this.prior = prior;
        }

        @Override
        public String getScriptPath() {
            return this.scriptPath;
        }

        public void setScriptPath(String scriptPath) {
            this.scriptPath = scriptPath;
        }

        @Override
        public MApiOperationBuilder getMetaOperation() {
            return this.metaOperation;
        }

        public void setMetaOperation(MApiOperationBuilder metaOperation) {
            this.metaOperation = metaOperation;
        }

        @Override
        public Map<String, Object> getArguments() {
            return this.arguments;
        }

        public void putArguments(Map<String, Object> m) {
            if (null != m) {
                this.arguments.putAll(m);
            }
        }

        public void putArgument(String name, Object value) {
            this.arguments.put(name, value);
        }

        @Override
        public <T> T getArgument(String name) {
            return (T)this.arguments.get(name);
        }
    }

    public static class Model
    extends MapAttributeAccessor {
        protected final String name;
        protected String title;
        protected String path;
        protected Boolean anonymous;
        protected Boolean createOperationEnabled;
        protected Boolean updateOperationEnabled;
        protected Boolean deleteOperationEnabled;
        protected Boolean findOperationEnabled;
        protected Boolean queryOperationEnabled;
        protected Boolean countOperationEnabled;
        protected Map<String, Boolean> enables = new LinkedHashMap<String, Boolean>();
        protected Map<String, Operation> operations = new LinkedHashMap<String, Operation>();

        public Model(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public Boolean getAnonymous() {
            return this.anonymous;
        }

        public void setAnonymous(Boolean anonymous) {
            this.anonymous = anonymous;
        }

        public Boolean getCreateOperationEnabled() {
            return this.createOperationEnabled;
        }

        public void setCreateOperationEnabled(Boolean createOperationEnabled) {
            this.createOperationEnabled = createOperationEnabled;
        }

        public Boolean getUpdateOperationEnabled() {
            return this.updateOperationEnabled;
        }

        public void setUpdateOperationEnabled(Boolean updateOperationEnabled) {
            this.updateOperationEnabled = updateOperationEnabled;
        }

        public Boolean getDeleteOperationEnabled() {
            return this.deleteOperationEnabled;
        }

        public void setDeleteOperationEnabled(Boolean deleteOperationEnabled) {
            this.deleteOperationEnabled = deleteOperationEnabled;
        }

        public Boolean getFindOperationEnabled() {
            return this.findOperationEnabled;
        }

        public void setFindOperationEnabled(Boolean findOperationEnabled) {
            this.findOperationEnabled = findOperationEnabled;
        }

        public Boolean getQueryOperationEnabled() {
            return this.queryOperationEnabled;
        }

        public void setQueryOperationEnabled(Boolean queryOperationEnabled) {
            this.queryOperationEnabled = queryOperationEnabled;
        }

        public Boolean getCountOperationEnabled() {
            return this.countOperationEnabled;
        }

        public void setCountOperationEnabled(Boolean countOperationEnabled) {
            this.countOperationEnabled = countOperationEnabled;
        }

        public Map<String, Boolean> getEnables() {
            return this.enables;
        }

        public boolean isEnabled(String name) {
            Boolean b = this.enables.get(name);
            return null != b && b != false;
        }

        public Boolean getEnable(String name) {
            return this.enables.get(name);
        }

        public void setEnable(String name, Boolean enabled) {
            this.enables.put(name, enabled);
        }

        public Map<String, Operation> getOperations() {
            return this.operations;
        }

        public Operation getOperation(String name) {
            return this.operations.get(name.toLowerCase());
        }

        public void addOperation(Operation op) {
            String key = op.getName().toLowerCase();
            if (this.operations.containsKey(key)) {
                throw new ObjectExistsException("The operation '" + op.getName() + "' of model '" + this.name + "' already exists!");
            }
            this.operations.put(key, op);
        }
    }
}

