/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.config.model;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import leap.web.api.config.ApiConfigException;
import leap.web.api.config.model.ConfigWithDocument;
import leap.web.api.config.model.ModelConfig;

public class ModelConfigImpl
implements ModelConfig {
    protected String name;
    protected String className;
    protected Map<String, ModelConfig.Property> properties = new LinkedHashMap<String, ModelConfig.Property>();

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public Set<ModelConfig.Property> getProperties() {
        return new LinkedHashSet<ModelConfig.Property>(this.properties.values());
    }

    @Override
    public ModelConfig.Property getProperty(String name) {
        return this.properties.get(name.toLowerCase());
    }

    public void addProperty(ModelConfig.Property p) {
        if (this.properties.containsKey(p.getName().toLowerCase())) {
            throw new ApiConfigException("Found duplicated property '" + p.getName() + "' of model " + this);
        }
        this.properties.put(p.getName().toLowerCase(), p);
    }

    public String toString() {
        return "(name=" + this.name + ",class=" + this.className + ")";
    }

    public static class PropertyImpl
    implements ModelConfig.Property,
    ConfigWithDocument {
        protected String name;
        protected String title;
        protected String summary;
        protected String description;

        public PropertyImpl(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public void setTitle(String title) {
            this.title = title;
        }

        @Override
        public String getSummary() {
            return this.summary;
        }

        @Override
        public void setSummary(String summary) {
            this.summary = summary;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public void setDescription(String description) {
            this.description = description;
        }
    }
}

