/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.config;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import leap.core.AppConfigException;
import leap.core.config.AppConfigContext;
import leap.core.config.AppConfigListener;
import leap.core.config.AppConfigPaths;
import leap.core.config.AppConfigProcessor;
import leap.lang.Classes;
import leap.lang.Collections2;
import leap.lang.Keyed;
import leap.lang.Props;
import leap.lang.Strings;
import leap.lang.extension.ExProperties;
import leap.lang.meta.MType;
import leap.lang.meta.MVoidType;
import leap.lang.xml.XmlReader;
import leap.web.api.config.ApiConfig;
import leap.web.api.config.ApiConfigException;
import leap.web.api.config.ApiConfigs;
import leap.web.api.config.ApiConfigurator;
import leap.web.api.config.DefaultApiConfig;
import leap.web.api.config.model.ConfigWithDocument;
import leap.web.api.config.model.ModelConfig;
import leap.web.api.config.model.ModelConfigImpl;
import leap.web.api.config.model.OAuthConfigImpl;
import leap.web.api.config.model.ParamConfig;
import leap.web.api.config.model.ParamConfigImpl;
import leap.web.api.config.model.RestdConfig;
import leap.web.api.meta.model.MApiPermission;
import leap.web.api.meta.model.MApiResponseBuilder;
import leap.web.api.permission.ResourcePermission;
import leap.web.api.permission.ResourcePermissions;
import leap.web.config.DefaultModuleConfig;
import leap.web.config.ModuleConfig;
import leap.web.config.ModuleConfigExtension;

public class XmlApiConfigLoader
implements AppConfigProcessor,
AppConfigListener {
    private static final String NAMESPACE_URI = "http://www.leapframework.org/schema/webapi";
    protected static final String APIS = "apis";
    protected static final String API = "api";
    protected static final String GLOBAL = "global";
    protected static final String PARAMS = "params";
    protected static final String PARAM = "param";
    protected static final String PROPERTIES = "properties";
    protected static final String PROPERTY = "property";
    protected static final String MODELS = "models";
    protected static final String MODEL = "model";
    protected static final String OAUTH = "oauth";
    protected static final String VERSION = "version";
    protected static final String TITLE = "title";
    protected static final String SUMMARY = "summary";
    protected static final String DESC = "desc";
    protected static final String PRODUCES = "produces";
    protected static final String CONSUMES = "consumes";
    protected static final String PROTOCOLS = "protocols";
    protected static final String MAX_PAGE_SIZE = "max-page-size";
    protected static final String DEFAULT_PAGE_SIZE = "default-page-size";
    protected static final String ENABLED = "enabled";
    protected static final String FLOW = "flow";
    protected static final String AUTHZ_URL = "authz-url";
    protected static final String TOKEN_URL = "token-url";
    protected static final String SCOPE = "scope";
    protected static final String NAME = "name";
    protected static final String BASE_PATH = "base-path";
    protected static final String BASE_PACKAGE = "base-package";
    protected static final String RESPONSES = "responses";
    protected static final String RESPONSE = "response";
    protected static final String STATUS = "status";
    protected static final String TYPE = "type";
    protected static final String PERMISSIONS = "permissions";
    protected static final String PERMISSION = "permission";
    protected static final String VALUE = "value";
    protected static final String RESOURCE_PERMISSIONS = "resource-permissions";
    protected static final String RESOURCE = "resource";
    protected static final String RESOURCES = "resources";
    protected static final String CLASS = "class";
    protected static final String PACKAGE = "package";
    protected static final String DEFAULT = "default";
    protected static final String HTTP_METHODS = "http-methods";
    protected static final String PATH_PATTERN = "path-pattern";
    protected static final String UNIQUE_OPERATION_ID = "unique-operation-id";
    protected static final String DEFAULT_ANONYMOUS = "default-anonymous";
    protected static final String RESTD = "restd";
    protected static final String RESTD_ENABLED = "restd-enabled";
    protected static final String RESTD_DATA_SOURCE = "restd-data-source";
    protected static final String DATA_SOURCE = "data-source";
    protected static final String INCLUDED_MODELS = "included-models";
    protected static final String EXCLUDED_MODELS = "excluded-models";
    protected static final String READONLY_MODELS = "readonly-models";
    protected static final String ANONYMOUS = "anonymous";
    protected static final String READONLY = "readonly";
    protected static final String READ = "read";
    protected static final String WRITE = "write";
    protected static final String CREATE = "create";
    protected static final String UPDATE = "update";
    protected static final String DELETE = "delete";
    protected static final String FIND = "find";
    protected static final String QUERY = "query";
    protected static final String COUNT = "count";
    protected static final String OVERRIDE = "override";
    protected static final String SQL_OPERATION = "sql-operation";
    protected static final String SQL_KEY = "sql-key";

    public String getNamespaceURI() {
        return NAMESPACE_URI;
    }

    public void preLoadConfig(AppConfigContext context, AppConfigPaths paths) {
        paths.addConfigName(APIS);
    }

    public void processElement(AppConfigContext context, XmlReader reader) throws AppConfigException {
        this.readApis(context, reader);
    }

    public void postLoadConfig(AppConfigContext context) {
        ApiConfigs configs = (ApiConfigs)context.getExtension(ApiConfigs.class);
        if (configs != null) {
            configs.getApis().forEach((k, v) -> {
                String basePackage = v.config().getBasePackage();
                if (Strings.isNotEmpty((String)basePackage)) {
                    context.getAdditionalPackages().add(basePackage);
                }
            });
        }
    }

    protected void readApis(AppConfigContext context, XmlReader reader) {
        while (reader.nextWhileNotEnd(APIS)) {
            if (reader.isStartElement(GLOBAL)) {
                this.readGlobal(context, reader);
                continue;
            }
            if (!reader.isStartElement(API)) continue;
            this.readApi(context, reader);
        }
    }

    protected void readGlobal(AppConfigContext context, XmlReader reader) {
        ApiConfigs configs = (ApiConfigs)context.getOrCreateExtension(ApiConfigs.class);
        reader.loopInsideElement(() -> {
            if (reader.isStartElement(OAUTH)) {
                configs.setOAuthConfig(this.readOAuth(context, reader));
                return;
            }
            if (reader.isStartElement(RESPONSES)) {
                this.readCommonResponses(reader).forEach(configs::addCommonResponse);
                return;
            }
            if (reader.isStartElement(PARAMS)) {
                this.readParams(context, reader, p -> {
                    if (p.isOverride()) {
                        configs.removeCommonParam((Keyed)p);
                    }
                    configs.addCommonParam((ParamConfig)p);
                });
                return;
            }
            if (reader.isStartElement(MODELS)) {
                this.readModels(context, reader, configs::addCommonModel);
                return;
            }
        });
    }

    protected Map<String, MApiResponseBuilder> readCommonResponses(XmlReader reader) {
        LinkedHashMap<String, MApiResponseBuilder> responses = new LinkedHashMap<String, MApiResponseBuilder>();
        reader.loopInsideElement(() -> {
            if (reader.isStartElement(RESPONSE)) {
                String name = reader.getAttribute(NAME);
                int status = reader.getRequiredIntAttribute(STATUS);
                String type = reader.getAttribute(TYPE);
                if (Strings.isEmpty((String)name)) {
                    name = String.valueOf(status);
                }
                MApiResponseBuilder r = new MApiResponseBuilder();
                r.setName(name);
                r.setStatus(status);
                r.setDescription(reader.getAttribute(DESC));
                if (!Strings.isEmpty((String)type)) {
                    Class c = Classes.tryForName((String)type);
                    if (null == c) {
                        throw new ApiConfigException("Invalid response type '" + type + "', check : " + reader.getCurrentLocation());
                    }
                    r.setTypeClass(c);
                } else {
                    r.setType((MType)MVoidType.TYPE);
                }
                reader.loopInsideElement(() -> {
                    if (reader.isStartElement(DESC)) {
                        r.setDescription(reader.getElementTextAndEnd());
                    }
                });
                responses.put(name, r);
            }
        });
        return responses;
    }

    protected void readParams(AppConfigContext context, XmlReader reader, Consumer<ParamConfigImpl> func) {
        reader.loopInsideElement(() -> {
            if (reader.isStartElement(PARAM)) {
                ParamConfigImpl param = new ParamConfigImpl(reader.getAttribute(NAME));
                param.setClassName(reader.getRequiredAttribute(CLASS));
                param.setOverride(reader.getBooleanAttribute(OVERRIDE, false));
                reader.loopInsideElement(() -> {
                    if (reader.isStartElement(PROPERTIES)) {
                        this.readWrappedParams(context, reader, p -> {
                            if (null != param.getWrappedParam(p.getName())) {
                                throw new ApiConfigException("Found duplicated wrapped param '" + p.getName() + "', at " + reader.getCurrentLocation());
                            }
                            param.addWrappedParam((ParamConfig)p);
                        });
                    }
                });
                func.accept(param);
            }
        });
    }

    protected void readWrappedParams(AppConfigContext context, XmlReader reader, Consumer<ParamConfig> func) {
        while (reader.nextWhileNotEnd(PROPERTIES)) {
            if (!reader.isStartElement(PROPERTY)) continue;
            String name = reader.getRequiredAttribute(NAME);
            ParamConfigImpl p = new ParamConfigImpl(name);
            this.readDocument(reader, p);
            func.accept(p);
        }
    }

    protected void readModels(AppConfigContext context, XmlReader reader, Consumer<ModelConfig> func) {
        reader.loopInsideElement(() -> {
            if (reader.isStartElement(MODEL)) {
                String className = reader.getAttribute(CLASS);
                String modelName = reader.getAttribute(NAME);
                if (Strings.isEmpty((String)className) && Strings.isEmpty((String)modelName)) {
                    throw new ApiConfigException("One of the 'name' or 'class' attribute must not be empty, at " + reader.getCurrentLocation());
                }
                ModelConfigImpl model = new ModelConfigImpl();
                model.setName(modelName);
                model.setClassName(className);
                reader.loopInsideElement(() -> {
                    if (reader.isStartElement(PROPERTIES)) {
                        this.readProperties(context, reader, p -> {
                            if (null != model.getProperty(p.getName())) {
                                throw new ApiConfigException("Found duplicated property '" + p.getName() + "', at " + reader.getCurrentLocation());
                            }
                            model.addProperty((ModelConfig.Property)p);
                        });
                    }
                });
                func.accept(model);
            }
        });
    }

    protected void readProperties(AppConfigContext context, XmlReader reader, Consumer<ModelConfig.Property> func) {
        while (reader.nextWhileNotEnd(PROPERTIES)) {
            if (!reader.isStartElement(PROPERTY)) continue;
            String name = reader.getRequiredAttribute(NAME);
            ModelConfigImpl.PropertyImpl p = new ModelConfigImpl.PropertyImpl(name);
            this.readDocument(reader, p);
            func.accept(p);
        }
    }

    protected void readDocument(XmlReader reader, ConfigWithDocument doc) {
        this.readDocument(reader, doc, null);
    }

    protected void readDocument(XmlReader reader, ConfigWithDocument doc, Runnable subElementsHandler) {
        doc.setTitle(reader.getAttribute(TITLE));
        doc.setSummary(reader.getAttribute(SUMMARY));
        doc.setDescription(reader.getAttribute(DESC));
        reader.loopInsideElement(() -> {
            if (reader.isStartElement(TITLE)) {
                doc.setTitle(reader.getElementTextAndEnd());
                return;
            }
            if (reader.isStartElement(SUMMARY)) {
                doc.setSummary(reader.getElementTextAndEnd());
                return;
            }
            if (reader.isStartElement(DESC)) {
                doc.setDescription(reader.getElementTextAndEnd());
                return;
            }
            if (null != subElementsHandler) {
                subElementsHandler.run();
            }
        });
    }

    protected void readApi(AppConfigContext context, XmlReader reader) {
        String dataSourceName;
        ApiConfigs extensions = (ApiConfigs)context.getOrCreateExtension(ApiConfigs.class);
        String name = reader.resolveRequiredAttribute(NAME);
        String basePath = reader.resolveAttribute(BASE_PATH);
        String basePackage = reader.resolveAttribute(BASE_PACKAGE);
        Boolean uniqueOperationId = reader.resolveBooleanAttribute(UNIQUE_OPERATION_ID);
        Boolean defaultAnonymous = reader.resolveBooleanAttribute(DEFAULT_ANONYMOUS);
        boolean restdEnabled = reader.resolveBooleanAttribute(RESTD_ENABLED, false);
        ApiConfigurator api = extensions.getApi(name);
        if (null == api) {
            reader.getRequiredAttribute(BASE_PATH);
            api = new DefaultApiConfig(name, basePath, reader.getSource());
            api.setBasePackage(basePackage);
            extensions.addApi(api);
        } else if (!Strings.isEmpty((String)basePath)) {
            ((DefaultApiConfig)api).setBasePath(basePath);
        }
        if (null != defaultAnonymous) {
            api.setDefaultAnonymous(defaultAnonymous);
        }
        if (null != uniqueOperationId) {
            api.setUniqueOperationId(uniqueOperationId);
        }
        if (restdEnabled && null == api.getRestdConfig()) {
            api.setRestdConfig(new RestdConfig());
        }
        if (null != api.getRestdConfig() && !Strings.isEmpty((String)(dataSourceName = reader.resolveAttribute(RESTD_DATA_SOURCE)))) {
            api.getRestdConfig().setDataSourceName(dataSourceName);
        }
        this.readApi(context, reader, api);
        this.addOrUpdateWebModule(context, api);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readApi(AppConfigContext context, XmlReader reader, ApiConfigurator api) {
        context.setAttribute(ApiConfigurator.class.getName(), (Object)api);
        try {
            while (reader.nextWhileNotEnd(API)) {
                Integer i;
                String s;
                if (context.getProcessors().handleXmlElement(context, reader, NAMESPACE_URI)) continue;
                if (reader.isStartElement(VERSION)) {
                    String v = reader.getElementTextAndEnd();
                    if (Strings.isEmpty((String)v)) continue;
                    api.setVersion(v);
                    continue;
                }
                if (reader.isStartElement(TITLE)) {
                    String title = reader.getElementTextAndEnd();
                    if (Strings.isEmpty((String)title)) continue;
                    api.setTitle(title);
                    continue;
                }
                if (reader.isStartElement(SUMMARY)) {
                    String summary = reader.getElementTextAndEnd();
                    if (Strings.isEmpty((String)summary)) continue;
                    api.setSummary(summary);
                    continue;
                }
                if (reader.isStartElement(DESC)) {
                    String desc = reader.getElementTextAndEnd();
                    if (Strings.isEmpty((String)desc)) continue;
                    api.setDescription(desc);
                    continue;
                }
                if (reader.isStartElement(PRODUCES)) {
                    s = reader.getElementTextAndEnd();
                    if (Strings.isEmpty((String)s)) continue;
                    api.setProduces(Strings.splitMultiLines((String)s));
                    continue;
                }
                if (reader.isStartElement(CONSUMES)) {
                    s = reader.getElementTextAndEnd();
                    if (Strings.isEmpty((String)s)) continue;
                    api.setConsumes(Strings.splitMultiLines((String)s));
                    continue;
                }
                if (reader.isStartElement(PROTOCOLS)) {
                    s = reader.getElementTextAndEnd();
                    if (Strings.isEmpty((String)s)) continue;
                    api.setProtocols(Strings.splitMultiLines((String)s));
                    continue;
                }
                if (reader.isStartElement(RESPONSES)) {
                    this.readCommonResponses(reader).forEach(api::putCommonResponseBuilder);
                    continue;
                }
                if (reader.isStartElement(MODELS)) {
                    this.readModels(context, reader, api::addModelConfig);
                    continue;
                }
                if (reader.isStartElement(MAX_PAGE_SIZE)) {
                    i = reader.getIntegerElementTextAndEnd();
                    if (null == i) continue;
                    api.setMaxPageSize(i);
                    continue;
                }
                if (reader.isStartElement(DEFAULT_PAGE_SIZE)) {
                    i = reader.getIntegerElementTextAndEnd();
                    if (null == i) continue;
                    api.setDefaultPageSize(i);
                    continue;
                }
                if (reader.isStartElement(PERMISSIONS)) {
                    this.readPermissions(context, reader, api);
                    continue;
                }
                if (reader.isStartElement(RESOURCE_PERMISSIONS)) {
                    this.readResourcePermissions(context, reader, api);
                    continue;
                }
                if (reader.isStartElement(OAUTH)) {
                    api.setOAuthConfig(this.readOAuth(context, reader));
                    continue;
                }
                if (!reader.isStartElement(RESTD)) continue;
                this.readRestd(context, api, reader);
            }
        }
        finally {
            context.removeAttribute(ApiConfigurator.class.getName());
        }
    }

    protected void addOrUpdateWebModule(AppConfigContext context, ApiConfigurator api) {
        ApiConfig ac = api.config();
        String basePackage = ac.getBasePackage();
        if (Strings.isNotEmpty((String)basePackage)) {
            context.getAdditionalPackages().add(basePackage);
            String moduleName = ac.getName() + "_api";
            DefaultModuleConfig module = new DefaultModuleConfig();
            module.setName(moduleName);
            module.setBasePath(ac.getBasePath());
            module.setBasePackage(ac.getBasePackage());
            ModuleConfigExtension extension = (ModuleConfigExtension)context.getOrCreateExtension(ModuleConfigExtension.class);
            extension.setModule((ModuleConfig)module);
        }
    }

    protected void readPermissions(AppConfigContext context, XmlReader reader, ApiConfigurator api) {
        String text;
        StringBuilder chars = new StringBuilder();
        boolean hasElement = false;
        while (reader.nextWhileNotEnd(PERMISSIONS)) {
            if (!hasElement && reader.isCharacters()) {
                chars.append(reader.getCharacters());
                continue;
            }
            if (!reader.isStartElement(PERMISSION)) continue;
            hasElement = true;
            String value = reader.getRequiredAttribute(VALUE);
            String desc = reader.getAttribute(DESC);
            if (Strings.isEmpty((String)desc)) {
                desc = reader.getElementTextAndEnd();
            }
            api.setPermission(new MApiPermission(value, desc));
        }
        if (!hasElement && (text = chars.toString().trim()).length() > 0) {
            ExProperties props = Props.loadKeyValues((String)text);
            props.forEach((k, v) -> {
                String value = (String)k;
                String desc = (String)v;
                api.setPermission(new MApiPermission(value, desc));
            });
        }
    }

    protected void readResourcePermissions(AppConfigContext context, XmlReader reader, ApiConfigurator api) {
        ResourcePermission rp;
        ResourcePermissions rps = new ResourcePermissions();
        reader.loopInsideElement(() -> {
            if (reader.isStartElement(RESOURCE)) {
                String className = reader.getRequiredAttribute(CLASS);
                rps.addResourceClass(className);
                return;
            }
            if (reader.isStartElement(RESOURCES)) {
                String packageName = reader.getRequiredAttribute(PACKAGE);
                rps.addResourcePackage(packageName);
                return;
            }
            if (reader.isStartElement(PERMISSION)) {
                String pathPattern;
                ResourcePermission rp = new ResourcePermission();
                rp.setValue(reader.getRequiredAttribute(VALUE));
                rp.setDescription(reader.getAttribute(DESC));
                rp.setDefault(reader.getBooleanAttribute(DEFAULT, false));
                String httpMethods = reader.getAttribute(HTTP_METHODS);
                if (!Strings.isEmpty((String)httpMethods)) {
                    // empty if block
                }
                if (!Strings.isEmpty((String)(pathPattern = reader.getAttribute(PATH_PATTERN)))) {
                    // empty if block
                }
                rps.addPermission(rp);
                return;
            }
        });
        if (null == rps.getDefaultPermission() && rps.getPermissions().size() == 1 && null == (rp = rps.getPermissions().iterator().next()).getHttpMethods() && null == rp.getPathPattern()) {
            rps.setDefaultPermission(rp);
        }
        api.config().getResourcePermissionsSet().addResourcePermissions(rps);
    }

    protected OAuthConfigImpl readOAuth(AppConfigContext context, XmlReader reader) {
        Boolean enabled = reader.resolveBooleanAttribute(ENABLED);
        String flow = reader.resolveAttribute(FLOW, "implicit");
        OAuthConfigImpl oauth = new OAuthConfigImpl(enabled, flow, null, null);
        reader.loopInsideElement(() -> {
            if (reader.isStartElement(AUTHZ_URL)) {
                String url = reader.resolveElementTextAndEnd();
                if (!Strings.isEmpty((String)url)) {
                    oauth.setAuthorizationUrl(url);
                }
                return;
            }
            if (reader.isStartElement(TOKEN_URL)) {
                String url = reader.resolveElementTextAndEnd();
                if (!Strings.isEmpty((String)url)) {
                    oauth.setTokenUrl(url);
                }
                return;
            }
        });
        return oauth;
    }

    private void readRestd(AppConfigContext context, ApiConfigurator api, XmlReader reader) {
        String dataSourceName;
        boolean enabled = reader.resolveBooleanAttribute(ENABLED, true);
        if (!enabled) {
            api.setRestdConfig(null);
            return;
        }
        RestdConfig c = api.getRestdConfig();
        if (null == c) {
            c = new RestdConfig();
            api.setRestdConfig(c);
        }
        if (!Strings.isEmpty((String)(dataSourceName = reader.resolveAttribute(DATA_SOURCE)))) {
            c.setDataSourceName(dataSourceName);
        }
        c.setReadonly(reader.resolveBooleanAttribute(READONLY, false));
        RestdConfig rc = c;
        reader.loopInsideElement(() -> {
            if (reader.isStartElement(INCLUDED_MODELS)) {
                Collections2.addAll(rc.getIncludedModels(), (Object[])Strings.splitMultiLines((String)reader.getElementTextAndEnd(), (char)','));
                return;
            }
            if (reader.isStartElement(EXCLUDED_MODELS)) {
                Collections2.addAll(rc.getExcludedModels(), (Object[])Strings.splitMultiLines((String)reader.getElementTextAndEnd(), (char)','));
                return;
            }
            if (reader.isStartElement(READONLY_MODELS)) {
                Collections2.addAll(rc.getReadonlyModels(), (Object[])Strings.splitMultiLines((String)reader.getElementTextAndEnd(), (char)','));
                return;
            }
            if (reader.isStartElement(MODEL)) {
                this.readRestdModel(context, api, reader, rc);
                return;
            }
            if (reader.isStartElement(SQL_OPERATION)) {
                rc.addOperation(this.readSqlOperation(rc, reader));
                return;
            }
        });
    }

    private void readRestdModel(AppConfigContext context, ApiConfigurator api, XmlReader reader, RestdConfig config) {
        String name = reader.getRequiredAttribute(NAME);
        Boolean anonymous = reader.getBooleanAttribute(ANONYMOUS);
        Boolean read = reader.getBooleanAttribute(READ);
        Boolean write = reader.getBooleanAttribute(WRITE);
        Boolean create = reader.getBooleanAttribute(CREATE);
        Boolean update = reader.getBooleanAttribute(UPDATE);
        Boolean delete = reader.getBooleanAttribute(DELETE);
        Boolean find = reader.getBooleanAttribute(FIND);
        Boolean query = reader.getBooleanAttribute(QUERY);
        Boolean count = reader.getBooleanAttribute(COUNT);
        RestdConfig.Model model = config.getModel(name);
        if (null == model) {
            model = new RestdConfig.Model(name);
            config.addModel(model);
        }
        model.setAnonymous(api.config().isDefaultAnonymous());
        if (null != anonymous) {
            model.setAnonymous(anonymous);
        }
        if (config.isReadonlyModel(name)) {
            model.setFindOperationEnabled(true);
            model.setQueryOperationEnabled(true);
            model.setCountOperationEnabled(true);
            model.setCreateOperationEnabled(false);
            model.setUpdateOperationEnabled(false);
            model.setDeleteOperationEnabled(false);
        }
        if (null != read) {
            model.setFindOperationEnabled(read);
            model.setQueryOperationEnabled(read);
            model.setCountOperationEnabled(read);
        }
        if (null != write) {
            model.setCreateOperationEnabled(write);
            model.setUpdateOperationEnabled(write);
            model.setDeleteOperationEnabled(write);
        }
        if (null != create) {
            model.setCreateOperationEnabled(create);
        }
        if (null != update) {
            model.setUpdateOperationEnabled(update);
        }
        if (null != delete) {
            model.setDeleteOperationEnabled(delete);
        }
        if (null != find) {
            model.setFindOperationEnabled(find);
        }
        if (null != query) {
            model.setQueryOperationEnabled(query);
        }
        if (null != count) {
            model.setCountOperationEnabled(count);
        }
        RestdConfig.Model m = model;
        reader.loopInsideElement(() -> {
            if (reader.isStartElement(SQL_OPERATION)) {
                m.addOperation(this.readSqlOperation(config, reader));
            }
        });
    }

    private RestdConfig.Operation readSqlOperation(RestdConfig config, XmlReader reader) {
        RestdConfig.Operation op = new RestdConfig.Operation();
        op.setName(reader.getRequiredAttribute(NAME));
        op.setType("sql");
        String sqlKey = reader.getAttribute(SQL_KEY);
        String sqlScript = reader.getElementTextAndEnd();
        if (Strings.isAllEmpty((String[])new String[]{sqlKey, sqlScript})) {
            throw new ApiConfigException("One of the key or script must not be empty of sql operation '" + op.getName() + "', at " + reader.getCurrentLocation());
        }
        if (!Strings.isEmpty((String)sqlKey)) {
            op.putArgument("sqlKey", sqlKey);
        }
        if (!Strings.isEmpty((String)sqlScript)) {
            op.setScript(sqlScript);
            op.setScriptPath(sqlKey);
        }
        return op;
    }
}

