/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import leap.core.annotation.Inject;
import leap.lang.Args;
import leap.lang.Arrays2;
import leap.lang.Collections2;
import leap.lang.ExtensibleBase;
import leap.lang.Strings;
import leap.lang.meta.MComplexType;
import leap.lang.naming.NamingStyle;
import leap.lang.path.Paths;
import leap.web.api.config.ApiConfig;
import leap.web.api.config.ApiConfigs;
import leap.web.api.config.ApiConfigurator;
import leap.web.api.config.model.ModelConfig;
import leap.web.api.config.model.OAuthConfig;
import leap.web.api.config.model.OAuthConfigImpl;
import leap.web.api.config.model.ParamConfig;
import leap.web.api.config.model.RestdConfig;
import leap.web.api.meta.ApiMetadataBuilder;
import leap.web.api.meta.model.MApiModelBuilder;
import leap.web.api.meta.model.MApiPermission;
import leap.web.api.meta.model.MApiResponse;
import leap.web.api.meta.model.MApiResponseBuilder;
import leap.web.api.mvc.ApiFailureHandler;
import leap.web.api.permission.ResourcePermissionsSet;
import leap.web.api.route.ApiRoute;
import leap.web.api.route.SimpleApiRoute;
import leap.web.route.Route;
import leap.web.route.Routes;

public class DefaultApiConfig
extends ExtensibleBase
implements ApiConfig,
ApiConfigurator {
    protected final Object source;
    protected final String name;
    protected String basePath;
    protected String basePackage;
    protected String title;
    protected String summary;
    protected String description;
    protected String version = "1.0";
    protected String[] protocols;
    protected String[] produces;
    protected String[] consumes;
    protected boolean defaultAnonymous = false;
    protected boolean corsEnabled = true;
    protected boolean uniqueOperationId = false;
    protected NamingStyle parameterNamingStyle;
    protected NamingStyle propertyNamingStyle;
    protected int maxPageSize = 1000;
    protected int defaultPageSize = 50;
    protected int maxPageSizeWithExpandMany = 100;
    protected int maxPageSizeWithExpandOne = 1000;
    protected int maxRecordsPerExpand = 1000;
    protected Set<String> removalModelNamePrefixes = new HashSet<String>();
    protected Set<String> removalModelNamePrefixesImv = Collections.unmodifiableSet(this.removalModelNamePrefixes);
    protected Set<ApiRoute> routes = new LinkedHashSet<ApiRoute>();
    protected Set<ApiRoute> routesImv = Collections.unmodifiableSet(this.routes);
    protected Map<String, MApiPermission> permissions = new LinkedHashMap<String, MApiPermission>();
    protected Map<String, MApiPermission> permissionsImv = Collections.unmodifiableMap(this.permissions);
    protected Map<String, MApiResponse> commonResponses = new LinkedHashMap<String, MApiResponse>();
    protected Map<String, MApiResponse> commonResponsesImv = Collections.unmodifiableMap(this.commonResponses);
    protected Set<ModelConfig> modelConfigs = new LinkedHashSet<ModelConfig>();
    protected Set<ModelConfig> modelConfigsImv = Collections.unmodifiableSet(this.modelConfigs);
    protected Set<MApiModelBuilder> models = new LinkedHashSet<MApiModelBuilder>();
    protected Set<MComplexType> complexTypes = new LinkedHashSet<MComplexType>();
    protected Set<ParamConfig> params = new LinkedHashSet<ParamConfig>();
    protected Set<ParamConfig> paramsImv = Collections.unmodifiableSet(this.params);
    protected Map<String, MApiResponseBuilder> commonResponseBuilders = new LinkedHashMap<String, MApiResponseBuilder>();
    protected Map<String, MApiResponseBuilder> commonResponseBuildersImv = Collections.unmodifiableMap(this.commonResponseBuilders);
    protected Map<Route, Class<?>> resourceTypes = new HashMap();
    protected Map<Route, Class<?>> resourceTypesImv = Collections.unmodifiableMap(this.resourceTypes);
    protected ResourcePermissionsSet resourcePermissionsSet = new ResourcePermissionsSet();
    protected OAuthConfigImpl oauthConfig = new OAuthConfigImpl();
    protected RestdConfig restdConfig;
    protected Routes containerRoutes;
    protected ApiMetadataBuilder metadata;
    @Inject
    protected ApiFailureHandler failureHandler;

    public DefaultApiConfig(String name, String basePath, Object source) {
        Args.notEmpty((String)name, (String)"name");
        Args.notEmpty((String)basePath, (String)"basePath");
        Args.assertTrue((boolean)basePath.startsWith("/"), (String)"The base path must be leading with a slash '/'");
        this.source = source;
        this.name = name;
        this.title = name;
        this.setBasePath(basePath);
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public ApiConfig config() {
        return this;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        Args.notEmpty((String)basePath, (String)"basePath");
        Args.assertTrue((boolean)basePath.startsWith("/"), (String)"The base path must be leading with a slash '/'");
        this.basePath = Paths.suffixWithoutSlash((String)basePath);
    }

    public String getName() {
        return this.name;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String[] getProtocols() {
        return this.protocols;
    }

    @Override
    public String[] getProduces() {
        return this.produces;
    }

    @Override
    public String[] getConsumes() {
        return this.consumes;
    }

    @Override
    public boolean isDefaultAnonymous() {
        return this.defaultAnonymous;
    }

    @Override
    public ApiConfigurator setDefaultAnonymous(boolean anonymous) {
        this.defaultAnonymous = anonymous;
        return this;
    }

    @Override
    public boolean isCorsDisabled() {
        return !this.corsEnabled;
    }

    @Override
    public Routes getContainerRoutes() {
        return this.containerRoutes;
    }

    @Override
    public ApiConfigurator setContainerRoutes(Routes routes) {
        this.containerRoutes = routes;
        return this;
    }

    @Override
    public Set<ApiRoute> getApiRoutes() {
        return this.routesImv;
    }

    @Override
    public Map<String, MApiResponse> getCommonResponses() {
        return this.commonResponsesImv;
    }

    @Override
    public Set<ModelConfig> getModelConfigs() {
        return this.modelConfigsImv;
    }

    @Override
    public ModelConfig getModelConfigByClassName(String className) {
        if (Strings.isEmpty((String)className)) {
            return null;
        }
        for (ModelConfig model : this.modelConfigs) {
            if (!className.equals(model.getClassName())) continue;
            return model;
        }
        return null;
    }

    @Override
    public ModelConfig getModelConfig(String name) {
        if (Strings.isEmpty((String)name)) {
            return null;
        }
        for (ModelConfig model : this.modelConfigs) {
            if (!name.equalsIgnoreCase(model.getName())) continue;
            return model;
        }
        return null;
    }

    @Override
    public ApiConfigurator addModelConfig(ModelConfig mc) {
        ApiConfigs.addModel(this.modelConfigs, mc);
        return this;
    }

    @Override
    public Set<MApiModelBuilder> getModels() {
        return this.models;
    }

    @Override
    public ApiConfigurator addModel(MApiModelBuilder model) {
        this.models.add(model);
        return this;
    }

    @Override
    public Set<MComplexType> getComplexTypes() {
        return this.complexTypes;
    }

    @Override
    public ApiConfigurator addComplexType(MComplexType ct) {
        this.complexTypes.add(ct);
        return this;
    }

    @Override
    public Set<ParamConfig> getParams() {
        return this.paramsImv;
    }

    @Override
    public ParamConfig getParam(String className, String name) {
        if (Strings.isEmpty((String)className) && Strings.isEmpty((String)name)) {
            return null;
        }
        String key = ParamConfig.key(className, name);
        for (ParamConfig param : this.params) {
            if (!key.equals(param.getKey())) continue;
            return param;
        }
        return null;
    }

    @Override
    public ApiConfigurator addParam(ParamConfig param) {
        ApiConfigs.addParam(this.params, param);
        return this;
    }

    @Override
    public NamingStyle getParameterNamingStyle() {
        return this.parameterNamingStyle;
    }

    @Override
    public NamingStyle getPropertyNamingStyle() {
        return this.propertyNamingStyle;
    }

    @Override
    public Set<String> getRemovalModelNamePrefixes() {
        return this.removalModelNamePrefixesImv;
    }

    @Override
    public ApiConfigurator setTitle(String title) {
        Args.notEmpty((String)title, (String)"title");
        this.title = title;
        return this;
    }

    @Override
    public ApiConfigurator setSummary(String s) {
        this.summary = s;
        return this;
    }

    @Override
    public ApiConfigurator setDescription(String s) {
        this.description = s;
        return this;
    }

    @Override
    public ApiConfigurator setVersion(String v) {
        Args.notEmpty((String)v, (String)"version");
        this.version = v;
        return this;
    }

    @Override
    public ApiConfigurator setProtocols(String ... protocols) {
        this.protocols = null == protocols ? Arrays2.EMPTY_STRING_ARRAY : protocols;
        return this;
    }

    @Override
    public ApiConfigurator putCommonResponseBuilder(String name, MApiResponseBuilder response) {
        this.commonResponseBuilders.put(name, response);
        return this;
    }

    @Override
    public ApiConfigurator putCommonResponse(String name, MApiResponse response) {
        this.commonResponses.put(name, response);
        return this;
    }

    @Override
    public ApiConfigurator setProduces(String ... produces) {
        this.produces = null == produces ? Arrays2.EMPTY_STRING_ARRAY : produces;
        return this;
    }

    @Override
    public ApiConfigurator setConsumes(String ... consumes) {
        this.consumes = null == consumes ? Arrays2.EMPTY_STRING_ARRAY : consumes;
        return this;
    }

    @Override
    public ApiConfigurator setParameterNamingStyle(NamingStyle ns) {
        this.parameterNamingStyle = ns;
        return this;
    }

    @Override
    public ApiConfigurator setPropertyNamingStyle(NamingStyle namingStyle) {
        this.propertyNamingStyle = namingStyle;
        return this;
    }

    @Override
    public ApiConfigurator removeModelNamePrefixes(String ... prefixes) {
        Collections2.addAll(this.removalModelNamePrefixes, (Object[])prefixes);
        return this;
    }

    @Override
    public ApiConfigurator setCorsEnabled(boolean enabled) {
        this.corsEnabled = enabled;
        return this;
    }

    @Override
    public ApiConfigurator setOAuthConfig(OAuthConfig oauth) {
        this.oauthConfig.tryUpdateFrom(oauth);
        return this;
    }

    @Override
    public ApiConfigurator enableOAuth() {
        this.oauthConfig.setEnabled(true);
        return this;
    }

    @Override
    public OAuthConfigImpl getOAuthConfig() {
        return this.oauthConfig;
    }

    @Override
    public Map<String, MApiPermission> getPermissions() {
        return this.permissionsImv;
    }

    @Override
    public ApiConfigurator setPermission(MApiPermission p) {
        this.permissions.put(p.getValue(), p);
        return this;
    }

    @Override
    public ApiConfigurator tryAddPermission(MApiPermission p) {
        if (!this.permissions.containsKey(p.getValue())) {
            this.setPermission(p);
        }
        return this;
    }

    @Override
    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    @Override
    public int getDefaultPageSize() {
        return this.defaultPageSize;
    }

    @Override
    public ApiConfigurator setMaxPageSize(int size) {
        this.maxPageSize = size;
        return this;
    }

    @Override
    public ApiConfigurator setDefaultPageSize(int size) {
        this.defaultPageSize = size;
        return this;
    }

    @Override
    public int getMaxPageSizeWithExpandMany() {
        return this.maxPageSizeWithExpandMany;
    }

    @Override
    public ApiConfigurator setMaxPageSizeWithExpand(int maxExpand) {
        this.maxPageSizeWithExpandMany = maxExpand;
        return this;
    }

    @Override
    public int getMaxPageSizeWithExpandOne() {
        return this.maxPageSizeWithExpandOne;
    }

    public ApiConfigurator setMaxPageSizeWithExpandOne(int maxPageSizeWithExpandOne) {
        this.maxPageSizeWithExpandOne = maxPageSizeWithExpandOne;
        return this;
    }

    @Override
    public int getMaxRecordsPerExpand() {
        return this.maxRecordsPerExpand;
    }

    @Override
    public ApiConfigurator setMaxRecordsPerExpand(int limit) {
        this.maxRecordsPerExpand = limit;
        return this;
    }

    @Override
    public ApiConfigurator addRoute(Route route) {
        return this.addRoute(route, false, true);
    }

    @Override
    public ApiConfigurator addDynamicRoute(Route route, boolean isOperation) {
        return this.addRoute(route, true, isOperation);
    }

    public ApiConfigurator addRoute(Route route, boolean dynamic, boolean operation) {
        if (null != route.getPermissions()) {
            for (String p : route.getPermissions()) {
                if (this.permissions.containsKey(p)) continue;
                this.permissions.put(p, new MApiPermission(p, ""));
            }
        }
        this.routes.add(new SimpleApiRoute(route, dynamic, operation));
        if (!this.containerRoutes.exists(route)) {
            this.containerRoutes.add(route);
        }
        return this;
    }

    @Override
    public Map<Route, Class<?>> getResourceTypes() {
        return this.resourceTypesImv;
    }

    @Override
    public ApiConfigurator setResourceType(Route route, Class<?> resourceType) {
        this.resourceTypes.put(route, resourceType);
        return this;
    }

    @Override
    public ResourcePermissionsSet getResourcePermissionsSet() {
        return this.resourcePermissionsSet;
    }

    @Override
    public String getBasePackage() {
        return this.basePackage;
    }

    @Override
    public ApiConfigurator setBasePackage(String basePackage) {
        this.basePackage = basePackage;
        return this;
    }

    @Override
    public boolean isUniqueOperationId() {
        return this.uniqueOperationId;
    }

    @Override
    public ApiConfigurator setUniqueOperationId(boolean uniqueOperationId) {
        this.uniqueOperationId = uniqueOperationId;
        return this;
    }

    @Override
    public RestdConfig getRestdConfig() {
        return this.restdConfig;
    }

    @Override
    public ApiConfigurator setRestdConfig(RestdConfig c) {
        this.restdConfig = c;
        return this;
    }

    @Override
    public ApiConfigurator enableRestd() {
        if (null == this.restdConfig) {
            this.restdConfig = new RestdConfig();
        }
        return this;
    }

    @Override
    public ApiMetadataBuilder getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(ApiMetadataBuilder metadata) {
        this.metadata = metadata;
    }

    @Override
    public ApiFailureHandler getFailureHandler() {
        return this.failureHandler;
    }

    @Override
    public void setFailureHandler(ApiFailureHandler failureHandler) {
        this.failureHandler = failureHandler;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[api=" + this.name + "]";
    }
}

