/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.config;

import leap.lang.Extensible;
import leap.lang.meta.MComplexType;
import leap.lang.naming.NamingStyle;
import leap.web.api.config.ApiConfig;
import leap.web.api.config.model.ModelConfig;
import leap.web.api.config.model.OAuthConfig;
import leap.web.api.config.model.ParamConfig;
import leap.web.api.config.model.RestdConfig;
import leap.web.api.meta.ApiMetadataBuilder;
import leap.web.api.meta.model.MApiModelBuilder;
import leap.web.api.meta.model.MApiPermission;
import leap.web.api.meta.model.MApiResponse;
import leap.web.api.meta.model.MApiResponseBuilder;
import leap.web.api.mvc.ApiFailureHandler;
import leap.web.route.Route;
import leap.web.route.Routes;

public interface ApiConfigurator
extends Extensible {
    public static final String[] DEFAULT_PRODUCES = new String[]{"application/json"};
    public static final String[] DEFAULT_CONSUMES = new String[]{"application/json"};
    public static final String DEFAULT_VERSION = "1.0";
    public static final int MAX_PAGE_SIZE = 1000;
    public static final int DEFAULT_PAGE_SIZE = 50;
    public static final int MAX_PAGE_SIZE_WITH_EXPAND_MANY = 100;
    public static final int MAX_PAGE_SIZE_WITH_EXPAND_ONE = 1000;
    public static final int MAX_RECORDS_PER_EXPAND = 1000;

    public ApiConfig config();

    public ApiConfigurator setTitle(String var1);

    public ApiConfigurator setSummary(String var1);

    public ApiConfigurator setDescription(String var1);

    public ApiConfigurator setVersion(String var1);

    public ApiConfigurator setProduces(String ... var1);

    public ApiConfigurator setConsumes(String ... var1);

    public ApiConfigurator setProtocols(String ... var1);

    public ApiConfigurator addModelConfig(ModelConfig var1);

    public ApiConfigurator addModel(MApiModelBuilder var1);

    public ApiConfigurator addComplexType(MComplexType var1);

    public ApiConfigurator addParam(ParamConfig var1);

    public ApiConfigurator putCommonResponse(String var1, MApiResponse var2);

    public ApiConfigurator putCommonResponseBuilder(String var1, MApiResponseBuilder var2);

    public ApiConfigurator setParameterNamingStyle(NamingStyle var1);

    public ApiConfigurator setPropertyNamingStyle(NamingStyle var1);

    public ApiConfigurator removeModelNamePrefixes(String ... var1);

    public ApiConfigurator setMaxPageSize(int var1);

    public ApiConfigurator setDefaultPageSize(int var1);

    public ApiConfigurator setMaxPageSizeWithExpand(int var1);

    public ApiConfigurator setMaxRecordsPerExpand(int var1);

    public ApiConfigurator setDefaultAnonymous(boolean var1);

    default public ApiConfigurator disableCors() {
        return this.setCorsEnabled(false);
    }

    public ApiConfigurator setCorsEnabled(boolean var1);

    public ApiConfigurator enableOAuth();

    public ApiConfigurator setOAuthConfig(OAuthConfig var1);

    public ApiConfigurator setPermission(MApiPermission var1);

    public ApiConfigurator tryAddPermission(MApiPermission var1);

    public ApiConfigurator addRoute(Route var1);

    default public ApiConfigurator addDynamicRoute(Route route) {
        return this.addDynamicRoute(route, true);
    }

    public ApiConfigurator addDynamicRoute(Route var1, boolean var2);

    public ApiConfigurator setBasePackage(String var1);

    public ApiConfigurator setResourceType(Route var1, Class<?> var2);

    public ApiConfigurator setUniqueOperationId(boolean var1);

    public ApiConfigurator setRestdConfig(RestdConfig var1);

    public ApiConfigurator setContainerRoutes(Routes var1);

    public ApiConfigurator enableRestd();

    public RestdConfig getRestdConfig();

    public ApiMetadataBuilder getMetadata();

    public void setMetadata(ApiMetadataBuilder var1);

    public void setFailureHandler(ApiFailureHandler var1);
}

