/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.config;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import leap.lang.Collections2;
import leap.lang.Keyed;
import leap.lang.Strings;
import leap.web.api.config.ApiConfigException;
import leap.web.api.config.ApiConfigurator;
import leap.web.api.config.model.ModelConfig;
import leap.web.api.config.model.OAuthConfig;
import leap.web.api.config.model.ParamConfig;
import leap.web.api.meta.model.MApiResponseBuilder;

public class ApiConfigs {
    private final Map<String, ApiConfigurator> apis = new LinkedHashMap<String, ApiConfigurator>();
    private final Set<ModelConfig> commonModels = new LinkedHashSet<ModelConfig>();
    private final Set<ParamConfig> commonParams = new LinkedHashSet<ParamConfig>();
    private final Map<String, MApiResponseBuilder> commonResponses = new LinkedHashMap<String, MApiResponseBuilder>();
    private OAuthConfig oauthConfig;

    public Map<String, ApiConfigurator> getApis() {
        return this.apis;
    }

    public ApiConfigurator getApi(String name) {
        return this.apis.get(name);
    }

    public void addApi(ApiConfigurator api) {
        String key = api.config().getName().toLowerCase();
        this.apis.put(key, api);
    }

    public OAuthConfig getOAuthConfig() {
        return this.oauthConfig;
    }

    public void setOAuthConfig(OAuthConfig oauthConfig) {
        this.oauthConfig = oauthConfig;
    }

    public Set<ModelConfig> getCommonModels() {
        return this.commonModels;
    }

    public void addCommonModel(ModelConfig model) {
        ApiConfigs.addModel(this.commonModels, model);
    }

    public Set<ParamConfig> getCommonParams() {
        return this.commonParams;
    }

    public void addCommonParam(ParamConfig param) {
        ApiConfigs.addParam(this.commonParams, param);
    }

    public boolean removeCommonParam(Keyed param) {
        return ApiConfigs.removeParam(this.commonParams, param);
    }

    public Map<String, MApiResponseBuilder> getCommonResponses() {
        return this.commonResponses;
    }

    public void addCommonResponse(String name, MApiResponseBuilder resp) {
        if (this.commonResponses.containsKey(name)) {
            throw new ApiConfigException("Found duplicated common response with name : " + name);
        }
        this.commonResponses.put(name, resp);
    }

    static void addModel(Set<ModelConfig> models, ModelConfig model) {
        models.forEach(exists -> {
            if (null != exists.getClassName() && exists.getClassName().equals(model.getClassName())) {
                throw new ApiConfigException("Found duplicated model type '" + model.getClassName() + "'");
            }
            if (!Strings.isEmpty((String)exists.getName()) && exists.getName().equalsIgnoreCase(model.getName())) {
                throw new ApiConfigException("Found duplicated model name '" + model.getName() + "'");
            }
        });
        models.add(model);
    }

    static void addParam(Set<ParamConfig> params, ParamConfig param) {
        ParamConfig found = null;
        for (ParamConfig exists : params) {
            if (!exists.getKey().equals(param.getKey())) continue;
            found = exists;
            break;
        }
        if (null != found) {
            if (param.isOverride()) {
                params.remove(found);
            } else {
                throw new ApiConfigException("Found duplicated param '" + param.getKey() + "'");
            }
        }
        params.add(param);
    }

    static boolean removeParam(Set<ParamConfig> params, Keyed param) {
        return null != Collections2.remove(params, p -> p.getKey().equals(param.getKey()));
    }
}

