/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.config;

import java.util.Map;
import java.util.Set;
import leap.lang.Described;
import leap.lang.Extensible;
import leap.lang.Named;
import leap.lang.Titled;
import leap.lang.meta.MComplexType;
import leap.lang.naming.NamingStyle;
import leap.web.api.config.model.ModelConfig;
import leap.web.api.config.model.OAuthConfig;
import leap.web.api.config.model.ParamConfig;
import leap.web.api.config.model.RestdConfig;
import leap.web.api.meta.model.MApiModelBuilder;
import leap.web.api.meta.model.MApiPermission;
import leap.web.api.meta.model.MApiResponse;
import leap.web.api.mvc.ApiFailureHandler;
import leap.web.api.permission.ResourcePermissionsSet;
import leap.web.api.route.ApiRoute;
import leap.web.route.Route;
import leap.web.route.Routes;

public interface ApiConfig
extends Named,
Titled,
Described,
Extensible {
    public Object getSource();

    public String getBasePath();

    public String getVersion();

    public String[] getProduces();

    public String[] getConsumes();

    public String[] getProtocols();

    default public boolean isCorsEnabled() {
        return !this.isCorsDisabled();
    }

    public boolean isCorsDisabled();

    public Map<String, MApiPermission> getPermissions();

    public Map<String, MApiResponse> getCommonResponses();

    public Set<ModelConfig> getModelConfigs();

    public Set<MApiModelBuilder> getModels();

    public Set<MComplexType> getComplexTypes();

    public ModelConfig getModelConfig(String var1);

    default public ModelConfig getModelConfig(Class<?> type) {
        return this.getModelConfigByClassName(null == type ? null : type.getName());
    }

    public ModelConfig getModelConfigByClassName(String var1);

    public Set<ParamConfig> getParams();

    default public ParamConfig getParam(String className) {
        return this.getParam(className, null);
    }

    public ParamConfig getParam(String var1, String var2);

    default public ParamConfig getParam(Class<?> type) {
        return this.getParam(type, null);
    }

    default public ParamConfig getParam(Class<?> type, String name) {
        return this.getParam(type.getName(), name);
    }

    public NamingStyle getParameterNamingStyle();

    public NamingStyle getPropertyNamingStyle();

    public Set<String> getRemovalModelNamePrefixes();

    public int getMaxPageSize();

    public int getDefaultPageSize();

    public int getMaxPageSizeWithExpandMany();

    public int getMaxPageSizeWithExpandOne();

    public int getMaxRecordsPerExpand();

    public String getBasePackage();

    public boolean isDefaultAnonymous();

    public Routes getContainerRoutes();

    public Set<ApiRoute> getApiRoutes();

    public Map<Route, Class<?>> getResourceTypes();

    public ResourcePermissionsSet getResourcePermissionsSet();

    public boolean isUniqueOperationId();

    default public boolean isOAuthEnabled() {
        return null != this.getOAuthConfig() && this.getOAuthConfig().isEnabled();
    }

    default public boolean isRestdEnabled() {
        return null != this.getRestdConfig();
    }

    public OAuthConfig getOAuthConfig();

    public RestdConfig getRestdConfig();

    public ApiFailureHandler getFailureHandler();
}

