/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api;

import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import leap.core.BeanFactory;
import leap.core.annotation.Inject;
import leap.core.ioc.PostCreateBean;
import leap.core.meta.MTypeManager;
import leap.lang.Args;
import leap.lang.Classes;
import leap.lang.Strings;
import leap.lang.Types;
import leap.lang.exception.ObjectExistsException;
import leap.lang.exception.ObjectNotFoundException;
import leap.lang.http.QueryStringBuilder;
import leap.lang.net.Urls;
import leap.lang.reflect.ReflectClass;
import leap.lang.reflect.ReflectField;
import leap.web.App;
import leap.web.AppInitializable;
import leap.web.api.Api;
import leap.web.api.Apis;
import leap.web.api.DefaultApi;
import leap.web.api.annotation.Resource;
import leap.web.api.annotation.ResourceWrapper;
import leap.web.api.config.ApiConfig;
import leap.web.api.config.ApiConfigException;
import leap.web.api.config.ApiConfigProcessor;
import leap.web.api.config.ApiConfigs;
import leap.web.api.config.ApiConfigurator;
import leap.web.api.config.DefaultApiConfig;
import leap.web.api.config.model.ModelConfig;
import leap.web.api.config.model.OAuthConfigImpl;
import leap.web.api.config.model.ParamConfig;
import leap.web.api.meta.ApiMetadata;
import leap.web.api.meta.ApiMetadataFactory;
import leap.web.api.meta.model.MApiPermission;
import leap.web.api.meta.model.MApiResponse;
import leap.web.api.mvc.ApiFailureHandler;
import leap.web.api.mvc.ApiInitializable;
import leap.web.api.permission.ResourcePermissions;
import leap.web.api.route.ApiRoute;
import leap.web.route.Route;

public class DefaultApis
implements Apis,
AppInitializable,
PostCreateBean {
    @Inject
    protected ApiConfigProcessor[] configProcessors;
    @Inject
    protected ApiMetadataFactory metadataFactory;
    @Inject
    protected MTypeManager typeManager;
    @Inject
    protected App app;
    @Inject
    protected BeanFactory factory;
    protected Map<String, MApiResponse> commonResponses = new LinkedHashMap<String, MApiResponse>();
    protected Map<String, Api> apis = new ConcurrentHashMap<String, Api>();
    private ApiConfigs configs;
    private OAuthConfigImpl oauthConfig = new OAuthConfigImpl();
    private Set<String> created = new CopyOnWriteArraySet<String>();

    @Override
    public Api get(String name) throws ObjectNotFoundException {
        Api api = this.tryGet(name);
        if (null == api) {
            throw new ObjectNotFoundException("Api '" + name + "' not exists!");
        }
        return api;
    }

    @Override
    public Api tryGet(String name) {
        return this.apis.get(name.toLowerCase());
    }

    @Override
    public boolean remove(Api api) {
        AtomicBoolean removed = new AtomicBoolean();
        this.apis.forEach((k, v) -> {
            if (v == api) {
                this.apis.remove(k);
                removed.set(true);
                return;
            }
        });
        return removed.get();
    }

    @Override
    public boolean remove(String name) {
        String key = name.toLowerCase();
        if (null == this.apis.remove(key)) {
            return false;
        }
        this.created.remove(key);
        return true;
    }

    @Override
    public ApiConfigurator add(String name, String basePath) throws ObjectExistsException {
        Args.notEmpty((String)name, (String)"name");
        Args.notEmpty((String)basePath, (String)"basePath");
        DefaultApiConfig c = (DefaultApiConfig)this.factory.inject((Object)new DefaultApiConfig(name, basePath, DefaultApis.class));
        this.doAdd(c);
        return c;
    }

    @Override
    public void add(Api api) throws ObjectExistsException {
        this.checkDuplicate(api.getConfig());
        this.apis.put(api.getName().toLowerCase(), api);
    }

    @Override
    public Api newDynamic(String name, String basePath) {
        DefaultApiConfig c = (DefaultApiConfig)this.factory.inject((Object)new DefaultApiConfig(name, basePath, DefaultApis.class));
        return this.doNewApi(c, true);
    }

    @Override
    public boolean isDefaultOAuthEnabled() {
        return this.oauthConfig.isEnabled();
    }

    @Override
    public String getDefaultOAuthAuthorizationUrl() {
        return this.oauthConfig.getAuthorizationUrl();
    }

    @Override
    public String getDefaultOAuthTokenUrl() {
        return this.oauthConfig.getTokenUrl();
    }

    @Override
    public Apis setDefaultOAuthEnabled(boolean enabled) {
        this.oauthConfig.setEnabled(enabled);
        return this;
    }

    @Override
    public Apis setDefaultOAuthAuthorizationUrl(String url) {
        this.oauthConfig.setAuthorizationUrl(url);
        return this;
    }

    @Override
    public Apis setDefaultOAuthAuthorizationUrl(String endpoint, String clientId, String redirectUri) {
        Args.notEmpty((String)endpoint, (String)"endpoint");
        QueryStringBuilder qs = new QueryStringBuilder();
        qs.add("client_id", clientId).add("redirect_uri", redirectUri).add("response_type", "token");
        this.oauthConfig.setAuthorizationUrl(Urls.appendQueryString((String)endpoint, (String)qs.build()));
        return this;
    }

    @Override
    public Apis setDefaultOAuthTokenUrl(String url) {
        this.oauthConfig.setTokenUrl(url);
        return this;
    }

    public void postCreate(BeanFactory factory) throws Throwable {
        this.configs = (ApiConfigs)factory.getAppConfig().getExtension(ApiConfigs.class);
        if (this.configs == null) {
            return;
        }
        this.oauthConfig.updateFrom(this.configs.getOAuthConfig());
        this.configs.getCommonResponses().forEach((key, builder) -> {
            builder.setTypeManager(this.typeManager);
            this.commonResponses.put((String)key, builder.build());
        });
        this.configs.getCommonModels().forEach(m -> {
            if (!Strings.isEmpty((String)m.getClassName()) && null == Classes.tryForName((String)m.getClassName())) {
                throw new ApiConfigException("The model class '" + m.getClassName() + "' not found");
            }
        });
        this.configs.getCommonParams().forEach(m -> {
            if (!Strings.isEmpty((String)m.getClassName()) && null == Classes.tryForName((String)m.getClassName())) {
                throw new ApiConfigException("The param class '" + m.getClassName() + "' not found");
            }
        });
        this.configs.getApis().values().forEach(this::doAdd);
    }

    protected void checkDuplicate(ApiConfig c) {
        String key = c.getName().toLowerCase();
        if (this.apis.containsKey(key)) {
            throw new ObjectExistsException("The api '" + c.getName() + "' already exists");
        }
        this.apis.values().forEach(api -> {
            if (Strings.equalsIgnoreCase((String)api.getBasePath(), (String)c.getBasePath())) {
                throw new ApiConfigException("Found duplicated api config with base path: " + c.getBasePath() + " in " + api.getConfig().getSource() + " and " + c.getSource());
            }
        });
    }

    protected void doAdd(ApiConfigurator c) {
        this.checkDuplicate(c.config());
        Api api = this.doNewApi(c, false);
        this.apis.put(api.getName().toLowerCase(), api);
    }

    protected Api doNewApi(ApiConfigurator configurator, boolean dynamic) {
        configurator.setContainerRoutes(this.app.routes());
        if (null != this.configs) {
            ApiConfig c = configurator.config();
            if (c.getOAuthConfig() == null) {
                configurator.setOAuthConfig(this.oauthConfig);
            } else {
                configurator.setOAuthConfig(new OAuthConfigImpl().updateFrom(this.oauthConfig));
            }
            this.configs.getCommonModels().forEach(model -> {
                if (null != c.getModelConfigByClassName(model.getClassName())) {
                    return;
                }
                if (null != c.getModelConfig(model.getName())) {
                    return;
                }
                configurator.addModelConfig((ModelConfig)model);
            });
            this.configs.getCommonParams().forEach(param -> {
                if (null != c.getParam(param.getClassName(), param.getName())) {
                    return;
                }
                configurator.addParam((ParamConfig)param);
            });
        }
        return new DefaultApi(this::doCreate, configurator, dynamic);
    }

    public void postAppInit(App app) throws Throwable {
        this.apis.values().forEach(api -> {
            if (!api.isCreated()) {
                api.create();
            }
        });
    }

    protected void doCreate(Api api) {
        ApiConfigurator c = api.getConfigurator();
        this.doConfiguration(this.app, c);
        if (!api.isDynamic()) {
            this.resolveAppRoutes(this.app, c);
        }
        for (ApiConfigProcessor p : this.configProcessors) {
            p.preProcess(api);
        }
        for (ApiConfigProcessor p : this.configProcessors) {
            p.postProcess(api);
        }
        for (ApiConfigProcessor p : this.configProcessors) {
            p.completeProcess(api);
        }
        this.postConfigApi(this.app, c.config());
        ApiMetadata metadata = this.createMetadata(api);
        api.setMetadata(metadata);
        api.markCreated();
        this.injectApiBeans(this.app, api);
    }

    protected void doConfiguration(App app, ApiConfigurator c) {
        if (null == c.config().getFailureHandler()) {
            c.setFailureHandler((ApiFailureHandler)app.factory().getBean(ApiFailureHandler.class));
        }
        this.commonResponses.forEach(c::putCommonResponse);
    }

    protected void resolveAppRoutes(App app, ApiConfigurator c) {
        String basePath = c.config().getBasePath();
        for (Route route : app.routes()) {
            String pathTemplate = route.getPathTemplate().getTemplate();
            if (!pathTemplate.equals(basePath) && !pathTemplate.startsWith(basePath)) continue;
            this.resolveResourceType(app, c, route);
            c.addRoute(route);
        }
    }

    protected void resolveResourceType(App app, ApiConfigurator c, Route route) {
        ResourceWrapper rw;
        Class resourceType = null;
        Resource resource = (Resource)route.getAction().searchAnnotation(Resource.class);
        if (null != resource) {
            resourceType = resource.value();
        }
        if (null != route.getAction().getController() && null != (rw = (ResourceWrapper)route.getAction().getControllerAnnotation(ResourceWrapper.class))) {
            Class<?> cls = route.getAction().getController().getClass();
            if (cls.getTypeParameters().length == 1) {
                resourceType = cls.getTypeParameters()[0].getGenericDeclaration();
            } else {
                Class[] types = Types.getActualTypeArguments((Type)cls.getGenericSuperclass());
                if (types.length == 1) {
                    resourceType = types[0];
                }
            }
        }
        if (null != resourceType) {
            c.setResourceType(route, resourceType);
            this.resolveResourcePermissions(app, c, route, resourceType);
        }
    }

    protected void resolveResourcePermissions(App app, ApiConfigurator c, Route route, Class<?> resourceType) {
        if (null != route.getPermissions()) {
            return;
        }
        ResourcePermissions rps = c.config().getResourcePermissionsSet().tryGetResourcePermissions(resourceType);
        if (null == rps) {
            return;
        }
        MApiPermission[] permissions = rps.resolvePermissions(route, resourceType);
        if (null != permissions && permissions.length > 0) {
            String[] values = new String[permissions.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = permissions[i].getValue();
            }
            route.setPermissions(values);
            for (MApiPermission p : permissions) {
                c.tryAddPermission(p);
            }
        }
    }

    protected void postConfigApi(App app, ApiConfig c) {
        c.getApiRoutes().forEach(ar -> {
            Route route = ar.getRoute();
            if (c.isDefaultAnonymous() && null == route.getAllowAnonymous()) {
                route.setAllowAnonymous(Boolean.valueOf(true));
            }
        });
    }

    protected void injectApiBeans(App app, Api api) {
        HashSet<Object> controllers = new HashSet<Object>();
        for (ApiRoute ar : api.getConfig().getApiRoutes()) {
            Route route = ar.getRoute();
            Object controller = route.getAction().getController();
            if (null == controller || controllers.contains(controller)) continue;
            controllers.add(controller);
            ReflectClass rc = ReflectClass.of(controller.getClass());
            for (ReflectField rf : rc.getFields()) {
                if (rf.getType().equals(ApiConfig.class)) {
                    rf.setValue(controller, (Object)api.getConfig());
                    break;
                }
                if (!rf.getType().equals(ApiMetadata.class)) continue;
                rf.setValue(controller, (Object)api.getMetadata());
            }
            if (!(controller instanceof ApiInitializable)) continue;
            ((ApiInitializable)controller).postApiInitialized(api);
        }
        controllers.clear();
    }

    protected ApiMetadata createMetadata(Api api) {
        return this.metadataFactory.createMetadata(api);
    }
}

