/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api;

import java.util.function.Consumer;
import leap.lang.ExtensibleBase;
import leap.web.api.Api;
import leap.web.api.config.ApiConfig;
import leap.web.api.config.ApiConfigurator;
import leap.web.api.meta.ApiMetadata;

public class DefaultApi
extends ExtensibleBase
implements Api {
    protected final Consumer<Api> creator;
    protected final ApiConfigurator configurator;
    protected final ApiConfig config;
    protected final boolean dynamic;
    protected volatile boolean created;
    protected ApiMetadata metadata;

    public DefaultApi(Consumer<Api> creator, ApiConfigurator configurator, boolean dynamic) {
        this.creator = creator;
        this.configurator = configurator;
        this.config = configurator.config();
        this.dynamic = dynamic;
    }

    public String getName() {
        return this.config.getName();
    }

    @Override
    public String getBasePath() {
        return this.config.getBasePath();
    }

    @Override
    public ApiConfig getConfig() {
        return this.config;
    }

    @Override
    public ApiConfigurator getConfigurator() throws IllegalStateException {
        if (this.created) {
            throw new IllegalStateException("Cannot get api configurator after created!");
        }
        return this.configurator;
    }

    @Override
    public ApiMetadata getMetadata() {
        this.mustCreated();
        return this.metadata;
    }

    @Override
    public void setMetadata(ApiMetadata metadata) {
        if (this.created) {
            throw new IllegalStateException("Cannot set metadata, api already created!");
        }
        this.metadata = metadata;
    }

    @Override
    public boolean isCreated() {
        return this.created;
    }

    @Override
    public void markCreated() throws IllegalStateException {
        if (this.created) {
            throw new IllegalStateException("Can't mark created, already created yet!");
        }
        this.created = true;
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }

    @Override
    public void create() throws IllegalStateException {
        if (this.created) {
            throw new IllegalStateException("Cannot create api again, it already created yet!");
        }
        this.creator.accept(this);
    }

    protected void mustCreated() {
        if (!this.created) {
            throw new IllegalStateException("Api '" + this.config.getName() + "' not created!");
        }
    }

    public String toString() {
        return "Api[" + this.getName() + "," + this.getBasePath() + "]";
    }
}

