/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.AssertionFailureBuilder;
import org.junit.jupiter.api.AssertionUtils;
import org.junit.jupiter.api.function.Executable;
import org.junit.platform.commons.util.UnrecoverableExceptions;

class AssertThrowsExactly {
    private AssertThrowsExactly() {
    }

    static <T extends Throwable> T assertThrowsExactly(Class<T> expectedType, Executable executable) {
        return AssertThrowsExactly.assertThrowsExactly(expectedType, executable, null);
    }

    static <T extends Throwable> T assertThrowsExactly(Class<T> expectedType, Executable executable, @Nullable String message) {
        return AssertThrowsExactly.assertThrowsExactly(expectedType, executable, (Object)message);
    }

    static <T extends Throwable> T assertThrowsExactly(Class<T> expectedType, Executable executable, Supplier<@Nullable String> messageSupplier) {
        return AssertThrowsExactly.assertThrowsExactly(expectedType, executable, messageSupplier);
    }

    private static <T extends Throwable> T assertThrowsExactly(Class<T> expectedType, Executable executable, @Nullable Object messageOrSupplier) {
        try {
            executable.execute();
        }
        catch (Throwable actualException) {
            if (expectedType.equals(actualException.getClass())) {
                return (T)actualException;
            }
            UnrecoverableExceptions.rethrowIfUnrecoverable((Throwable)actualException);
            throw AssertionFailureBuilder.assertionFailure().message(messageOrSupplier).expected(expectedType).actual(actualException.getClass()).reason("Unexpected exception type thrown").cause(actualException).build();
        }
        throw AssertionFailureBuilder.assertionFailure().message(messageOrSupplier).reason("Expected %s to be thrown, but nothing was thrown.".formatted(AssertionUtils.getCanonicalName(expectedType))).build();
    }
}

