/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.jruby;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProcess;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.jruby.CoreExt;
import org.jruby.javasupport.Java;
import org.jruby.platform.Platform;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.BasicLibraryService;
import org.jruby.runtime.load.Library;
import org.jruby.util.ClasspathLauncher;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.URLUtil;

public class JRubyUtilLibrary
implements Library {
    @Override
    public void load(Ruby runtime2, boolean wrap2) {
        RubyModule JRuby = runtime2.getOrCreateModule("JRuby");
        RubyModule JRubyUtil = JRuby.defineModuleUnder("Util");
        JRubyUtil.defineAnnotatedMethods(JRubyUtilLibrary.class);
        JRubyUtil.setConstant("SEPARATOR", runtime2.newString("(?<!jar:file|jar|file|classpath|uri:classloader|uri|http|https):"));
        JRubyUtil.setConstant("ON_WINDOWS", runtime2.newBoolean(Platform.IS_WINDOWS));
        JRubyUtil.setConstant("ON_SOLARIS", runtime2.newBoolean(Platform.IS_SOLARIS));
    }

    @JRubyMethod(module=true)
    public static IRubyObject gc(ThreadContext context, IRubyObject recv2) {
        System.gc();
        return context.nil;
    }

    @JRubyMethod(name={"objectspace", "object_space?"}, alias={"objectspace?"}, module=true)
    public static IRubyObject getObjectSpaceEnabled(IRubyObject recv2) {
        Ruby runtime2 = recv2.getRuntime();
        return RubyBoolean.newBoolean(runtime2, runtime2.isObjectSpaceEnabled());
    }

    @JRubyMethod(name={"objectspace=", "object_space="}, module=true)
    public static IRubyObject setObjectSpaceEnabled(IRubyObject recv2, IRubyObject arg2) {
        Ruby runtime2 = recv2.getRuntime();
        boolean enabled = arg2.isTrue();
        if (enabled) {
            runtime2.getWarnings().warn("ObjectSpace impacts performance. See http://wiki.jruby.org/PerformanceTuning#dont-enable-objectspace");
        }
        runtime2.setObjectSpaceEnabled(enabled);
        return runtime2.newBoolean(enabled);
    }

    @JRubyMethod(meta=true, name={"native_posix?"})
    public static IRubyObject native_posix_p(ThreadContext context, IRubyObject self2) {
        return RubyBoolean.newBoolean(context, context.runtime.getPosix().isNative());
    }

    @Deprecated
    public static IRubyObject getClassLoaderResources(IRubyObject recv2, IRubyObject name2) {
        return JRubyUtilLibrary.class_loader_resources(recv2.getRuntime().getCurrentContext(), recv2, name2);
    }

    @JRubyMethod(module=true, name={"class_loader_resources"}, alias={"classloader_resources"}, required=1, optional=1)
    public static IRubyObject class_loader_resources(ThreadContext context, IRubyObject recv2, IRubyObject ... args2) {
        Ruby runtime2 = context.runtime;
        JRubyClassLoader loader = runtime2.getJRubyClassLoader();
        String name2 = args2[0].convertToString().asJavaString();
        RubyArray resources = RubyArray.newArray(runtime2);
        boolean raw = false;
        boolean path2 = false;
        if (args2.length > 1 && args2[1] instanceof RubyHash) {
            IRubyObject[] values2 = ArgsUtil.extractKeywordArgs(context, (RubyHash)args2[1], "raw", "path");
            raw = values2[0] != null && values2[0].isTrue();
            path2 = values2[1] != null && values2[1].isTrue();
        }
        try {
            Enumeration<URL> e = loader.getResources(name2);
            while (e.hasMoreElements()) {
                URL entry = e.nextElement();
                if (path2) {
                    resources.append(RubyString.newString(runtime2, URLUtil.getPath(entry)));
                    continue;
                }
                if (raw) {
                    resources.append(Java.getInstance(runtime2, entry));
                    continue;
                }
                resources.append(RubyString.newString(runtime2, entry.toString()));
            }
        }
        catch (IOException ex) {
            throw context.runtime.newIOErrorFromException(ex);
        }
        return resources;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject classpath_launcher(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.runtime;
        String launcher = runtime2.getInstanceConfig().getEnvironment().get("RUBY");
        if (launcher == null) {
            launcher = ClasspathLauncher.jrubyCommand(runtime2);
        }
        return runtime2.newString(launcher);
    }

    @JRubyMethod(name={"extra_gem_paths"}, meta=true)
    public static IRubyObject extra_gem_paths(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.runtime;
        List<String> extraGemPaths = runtime2.getInstanceConfig().getExtraGemPaths();
        IRubyObject[] extra_gem_paths2 = new IRubyObject[extraGemPaths.size()];
        int i2 = 0;
        for (String gemPath : extraGemPaths) {
            extra_gem_paths2[i2++] = runtime2.newString(gemPath);
        }
        return RubyArray.newArrayNoCopy(runtime2, extra_gem_paths2);
    }

    @JRubyMethod(name={"current_directory"}, meta=true)
    public static IRubyObject current_directory(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.runtime;
        return runtime2.newString(runtime2.getCurrentDirectory());
    }

    @JRubyMethod(name={"set_last_exit_status"}, meta=true)
    public static IRubyObject set_last_exit_status(ThreadContext context, IRubyObject recv2, IRubyObject status2, IRubyObject pid2) {
        RubyProcess.RubyStatus processStatus = RubyProcess.RubyStatus.newProcessStatus(context.runtime, status2.convertToInteger().getLongValue(), pid2.convertToInteger().getLongValue());
        context.setLastExitStatus(processStatus);
        return processStatus;
    }

    @JRubyMethod(meta=true, name={"set_meta_class"})
    public static IRubyObject set_meta_class(ThreadContext context, IRubyObject recv2, IRubyObject obj, IRubyObject klass) {
        if (!(klass instanceof RubyClass)) {
            klass = klass.getMetaClass();
        }
        ((RubyObject)obj).setMetaClass((RubyClass)klass);
        return context.nil;
    }

    @JRubyMethod(module=true, name={"load_ext"})
    public static IRubyObject load_ext(ThreadContext context, IRubyObject recv2, IRubyObject klass) {
        if (klass instanceof RubySymbol) {
            switch (((RubySymbol)klass).asJavaString()) {
                case "string": {
                    CoreExt.loadStringExtensions(context.runtime);
                    return context.tru;
                }
            }
            throw context.runtime.newArgumentError(':' + ((RubySymbol)klass).asJavaString());
        }
        return JRubyUtilLibrary.loadExtension(context.runtime, klass.convertToString().toString()) ? context.tru : context.fals;
    }

    private static boolean loadExtension(Ruby runtime2, String className) {
        Class clazz = runtime2.getJavaSupport().loadJavaClassQuiet(className);
        if (BasicLibraryService.class.isAssignableFrom(clazz)) {
            try {
                return ((BasicLibraryService)clazz.newInstance()).basicLoad(runtime2);
            }
            catch (org.jruby.exceptions.Exception e) {
                throw e;
            }
            catch (ReflectiveOperationException e) {
                RaiseException ex = runtime2.newNameError("cannot instantiate (ext) Java class " + className, className, e, true);
                ex.initCause(e);
                throw ex;
            }
            catch (Exception e) {
                RaiseException ex = runtime2.newNameError("cannot load (ext) (" + className + ")", null, e, true);
                ex.initCause(e);
                throw ex;
            }
        }
        if (Library.class.isAssignableFrom(clazz)) {
            try {
                ((Library)clazz.newInstance()).load(runtime2, false);
                return true;
            }
            catch (org.jruby.exceptions.Exception e) {
                throw e;
            }
            catch (ReflectiveOperationException e) {
                RaiseException ex = runtime2.newNameError("cannot instantiate (ext) Java class " + className, className, e, true);
                ex.initCause(e);
                throw ex;
            }
            catch (Exception e) {
                RaiseException ex = runtime2.newNameError("cannot load (ext) (" + className + ")", null, e, true);
                ex.initCause(e);
                throw ex;
            }
        }
        try {
            Object result2 = clazz.getMethod("load", Ruby.class).invoke(null, runtime2);
            return !(result2 instanceof Boolean) || (Boolean)result2 != false;
        }
        catch (org.jruby.exceptions.Exception e) {
            throw e;
        }
        catch (Exception e) {
            RaiseException ex = runtime2.newNameError("cannot load (ext) (" + className + ")", null, e, true);
            ex.initCause(e);
            throw ex;
        }
    }

    @JRubyMethod(name={"cache_stats"}, module=true)
    public static IRubyObject cache_stats(ThreadContext context, IRubyObject self2) {
        Ruby runtime2 = context.runtime;
        RubyHash stat2 = RubyHash.newHash(runtime2);
        stat2.op_aset(context, runtime2.newSymbol("method_invalidation_count"), runtime2.newFixnum(runtime2.getCaches().getMethodInvalidationCount()));
        stat2.op_aset(context, runtime2.newSymbol("constant_invalidation_count"), runtime2.newFixnum(runtime2.getCaches().getConstantInvalidationCount()));
        return stat2;
    }

    @JRubyMethod(module=true)
    @Deprecated
    public static RubyArray internal_libraries(ThreadContext context, IRubyObject self2) {
        Ruby runtime2 = context.runtime;
        runtime2.getWarnings().warn("JRuby::Util.internal_libraries is deprecated");
        return runtime2.newEmptyArray();
    }

    @Deprecated
    public static class StringUtils {
        public static IRubyObject unseeded_hash(ThreadContext context, IRubyObject recv2) {
            return CoreExt.String.unseeded_hash(context, recv2);
        }
    }
}

