/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.visitors;

import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.jpmml.evaluator.ExtensionUtil;
import org.jpmml.evaluator.RichSimplePredicate;
import org.jpmml.evaluator.RichSimpleSetPredicate;
import org.jpmml.model.visitors.PredicateFilterer;

public class PredicateOptimizer
extends PredicateFilterer {
    public Predicate filter(Predicate predicate) {
        if (predicate == null || ExtensionUtil.hasExtensions((PMMLObject)predicate)) {
            return predicate;
        }
        return this.optimize(predicate);
    }

    public Predicate optimize(Predicate predicate) {
        if (predicate instanceof SimplePredicate) {
            SimplePredicate simplePredicate = (SimplePredicate)predicate;
            SimplePredicate.Operator operator = simplePredicate.getOperator();
            switch (operator) {
                case IS_MISSING: 
                case IS_NOT_MISSING: {
                    return predicate;
                }
            }
            return new RichSimplePredicate(simplePredicate);
        }
        if (predicate instanceof SimpleSetPredicate) {
            SimpleSetPredicate simpleSetPredicate = (SimpleSetPredicate)predicate;
            return new RichSimpleSetPredicate(simpleSetPredicate);
        }
        return predicate;
    }
}

