/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.java;

import java.util.Map;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.jpmml.evaluator.JavaModel;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.java.JavaModelEvaluationContext;
import org.jpmml.evaluator.java.JavaModelEvaluator;
import org.jpmml.model.annotations.Property;

public abstract class JavaRegressorModel
extends JavaModel {
    public JavaRegressorModel() {
    }

    public JavaRegressorModel(@Property(value="miningFunction") MiningFunction miningFunction, @Property(value="miningSchema") MiningSchema miningSchema) {
        super(miningFunction, miningSchema);
    }

    public JavaRegressorModel(Model model) {
        super(model);
    }

    public abstract <V extends Number> Value<V> evaluateRegression(ValueFactory<V> var1, JavaModelEvaluationContext var2);

    public MiningFunction getMiningFunction() {
        MiningFunction miningFunction = super.getMiningFunction();
        if (miningFunction == null) {
            return MiningFunction.REGRESSION;
        }
        return miningFunction;
    }

    public JavaModel setMiningFunction(@Property(value="miningFunction") MiningFunction miningFunction) {
        if (miningFunction != null && !MiningFunction.REGRESSION.equals((Object)miningFunction)) {
            throw new IllegalArgumentException();
        }
        return super.setMiningFunction(miningFunction);
    }

    public Map<FieldName, ?> evaluate(ModelEvaluationContext context) {
        Map<FieldName, ?> predictions = this.evaluateRegression((JavaModelEvaluationContext)context);
        return OutputUtil.evaluate(predictions, (ModelEvaluationContext)context);
    }

    protected Map<FieldName, ?> evaluateRegression(JavaModelEvaluationContext context) {
        JavaModelEvaluator modelEvaluator = context.getModelEvaluator();
        ValueFactory valueFactory = modelEvaluator.ensureValueFactory();
        TargetField targetField = modelEvaluator.getTargetField();
        Value result = this.evaluateRegression(valueFactory, context);
        if (result == null) {
            return TargetUtil.evaluateRegressionDefault((ValueFactory)valueFactory, (TargetField)targetField);
        }
        return TargetUtil.evaluateRegression((TargetField)targetField, result);
    }
}

