/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.general_regression;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.general_regression.BaseCumHazardTables;
import org.dmg.pmml.general_regression.BaselineStratum;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.HasParsedValueMapping;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.PMMLAttributes;
import org.jpmml.model.ReflectionUtil;

@XmlRootElement(name="BaseCumHazardTables")
public class RichBaseCumHazardTables
extends BaseCumHazardTables
implements HasParsedValueMapping<BaselineStratum> {
    @XmlTransient
    private Map<FieldValue, BaselineStratum> parsedValueMappings = null;

    public RichBaseCumHazardTables() {
    }

    public RichBaseCumHazardTables(BaseCumHazardTables baseCumHazardTables) {
        ReflectionUtil.copyState((PMMLObject)baseCumHazardTables, (PMMLObject)this);
    }

    public Map<FieldValue, BaselineStratum> getValueMapping(DataType dataType, OpType opType) {
        if (this.parsedValueMappings == null) {
            this.parsedValueMappings = ImmutableMap.copyOf(this.parseBaselineStrata(dataType, opType));
        }
        return this.parsedValueMappings;
    }

    private Map<FieldValue, BaselineStratum> parseBaselineStrata(DataType dataType, OpType opType) {
        LinkedHashMap<FieldValue, BaselineStratum> result = new LinkedHashMap<FieldValue, BaselineStratum>();
        List baselineStrata = this.getBaselineStrata();
        for (BaselineStratum baselineStratum : baselineStrata) {
            String category = baselineStratum.getValue();
            if (category == null) {
                throw new MissingAttributeException((PMMLObject)baselineStratum, PMMLAttributes.BASELINESTRATUM_VALUE);
            }
            FieldValue value = this.parse(dataType, opType, category);
            result.put(value, baselineStratum);
        }
        return result;
    }
}

