/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.filter.text;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.XComponent;
import com.sun.star.style.XStyle;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.core.office.OfficeContext;
import org.jodconverter.local.filter.Filter;
import org.jodconverter.local.filter.FilterChain;
import org.jodconverter.local.office.utils.Lo;
import org.jodconverter.local.office.utils.Write;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageMarginsFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageMarginsFilter.class);
    private final Integer topMargin;
    private final Integer rightMargin;
    private final Integer bottomMargin;
    private final Integer leftMargin;

    public PageMarginsFilter(@Nullable Integer leftMargin, @Nullable Integer topMargin, @Nullable Integer rightMargin, @Nullable Integer bottomMargin) {
        this.leftMargin = leftMargin;
        this.topMargin = topMargin;
        this.rightMargin = rightMargin;
        this.bottomMargin = bottomMargin;
    }

    @Override
    public void doFilter(@NonNull OfficeContext context, @NonNull XComponent document, @NonNull FilterChain chain) throws Exception {
        LOGGER.debug("Applying the PageMarginsFilter");
        if (Write.isText(document)) {
            this.setMargins(document);
        }
        chain.doFilter(context, document);
    }

    private void setMargins(XComponent document) throws Exception {
        XTextDocument docText = Write.getTextDoc(document);
        Objects.requireNonNull(docText);
        XTextCursor xTextCursor = docText.getText().createTextCursor();
        XPropertySet xTextCursorProps = Lo.qi(XPropertySet.class, xTextCursor);
        String pageStyleName = xTextCursorProps.getPropertyValue("PageStyleName").toString();
        XStyleFamiliesSupplier xSupplier = Lo.qi(XStyleFamiliesSupplier.class, docText);
        XNameAccess xFamilies = Lo.qi(XNameAccess.class, xSupplier.getStyleFamilies());
        XNameContainer xFamily = Lo.qi(XNameContainer.class, xFamilies.getByName("PageStyles"));
        XStyle xStyle = Lo.qi(XStyle.class, xFamily.getByName(pageStyleName));
        LOGGER.debug("Changing margins using: [left={}, top={}, right={}, bottom={}]", new Object[]{this.leftMargin, this.topMargin, this.rightMargin, this.bottomMargin});
        XPropertySet xStyleProps = Lo.qi(XPropertySet.class, xStyle);
        if (this.leftMargin != null) {
            xStyleProps.setPropertyValue("LeftMargin", (Object)(this.leftMargin * 100));
        }
        if (this.topMargin != null) {
            xStyleProps.setPropertyValue("TopMargin", (Object)(this.topMargin * 100));
        }
        if (this.rightMargin != null) {
            xStyleProps.setPropertyValue("RightMargin", (Object)(this.rightMargin * 100));
        }
        if (this.bottomMargin != null) {
            xStyleProps.setPropertyValue("BottomMargin", (Object)(this.bottomMargin * 100));
        }
    }
}

