/*
 * Decompiled with CFR 0.152.
 */
package impl.jfxtras.styles.jmetro;

import impl.jfxtras.styles.jmetro.SliderPopup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.FadeTransition;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.chart.NumberAxis;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Slider;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

public class SliderSkin
extends javafx.scene.control.skin.SliderSkin {
    private StackPane fill = new StackPane();
    private StackPane thumb;
    private StackPane track;
    private double trackToTickGap = 2.0;
    private SliderPopup popup = new SliderPopup();
    private static final int POPUP_DISTANCE_FROM_THUMB = 50;
    private static final Duration POPUP_FADE_DURATION = Duration.millis((double)200.0);
    private static final CssMetaData<Slider, Boolean> SHOW_VALUE_ON_INTERACTION_META_DATA = new CssMetaData<Slider, Boolean>("-show-value-on-interaction", BooleanConverter.getInstance(), Boolean.valueOf(true)){

        public boolean isSettable(Slider slider) {
            SliderSkin skin = (SliderSkin)slider.getSkin();
            return !skin.showValueOnInteraction.isBound();
        }

        public StyleableProperty<Boolean> getStyleableProperty(Slider slider) {
            SliderSkin skin = (SliderSkin)slider.getSkin();
            return (StyleableProperty)skin.showValueOnInteractionProperty();
        }
    };
    private BooleanProperty showValueOnInteraction = new SimpleStyleableBooleanProperty(SHOW_VALUE_ON_INTERACTION_META_DATA, true);
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public SliderSkin(Slider control) {
        super(control);
        this.track = (StackPane)((Slider)this.getSkinnable()).lookup(".track");
        this.thumb = (StackPane)((Slider)this.getSkinnable()).lookup(".thumb");
        this.fill.getStyleClass().add((Object)"fill");
        this.getChildren().add(this.getChildren().indexOf((Object)this.track) + 1, (Object)this.fill);
        this.track.addEventHandler(MouseEvent.MOUSE_PRESSED, this::mousePressedOnTrack);
        this.track.addEventHandler(MouseEvent.MOUSE_DRAGGED, this::mouseDraggedOnTrack);
        this.track.addEventHandler(MouseEvent.MOUSE_RELEASED, this::mouseReleasedFromTrack);
        this.fill.addEventHandler(MouseEvent.MOUSE_PRESSED, this::mousePressedOnTrack);
        this.fill.addEventHandler(MouseEvent.MOUSE_DRAGGED, this::mouseDraggedOnTrack);
        this.fill.addEventHandler(MouseEvent.MOUSE_RELEASED, this::mouseReleasedFromTrack);
        this.thumb.addEventHandler(MouseEvent.MOUSE_PRESSED, this::mousePressedOnThumb);
        this.thumb.addEventHandler(MouseEvent.MOUSE_DRAGGED, this::mouseDraggedOnThumb);
        this.thumb.addEventHandler(MouseEvent.MOUSE_RELEASED, this::mouseReleasedFromThumb);
        this.registerChangeListener((ObservableValue)control.showTickMarksProperty(), this::thickMarksChanged);
        this.registerChangeListener((ObservableValue)control.showTickLabelsProperty(), this::thickMarksChanged);
    }

    private void thickMarksChanged(ObservableValue<?> observableValue) {
        this.getChildren().add(this.getChildren().indexOf((Object)this.track) + 1, (Object)this.fill);
    }

    private void mousePressedOnTrack(MouseEvent mouseEvent) {
        this.showValuePopup();
    }

    private void mouseDraggedOnTrack(MouseEvent mouseEvent) {
        this.displaceValuePopup();
    }

    private void mouseReleasedFromTrack(MouseEvent mouseEvent) {
        this.hideValuePopup();
    }

    private void mousePressedOnThumb(MouseEvent mouseEvent) {
        this.showValuePopup();
    }

    private void mouseDraggedOnThumb(MouseEvent mouseEvent) {
        this.displaceValuePopup();
    }

    private void mouseReleasedFromThumb(MouseEvent mouseEvent) {
        this.hideValuePopup();
    }

    private void showValuePopup() {
        if (!this.isShowValueOnInteraction()) {
            return;
        }
        this.popup.setValue(((Slider)this.getSkinnable()).getValue());
        Point2D thumbScreenPos = this.thumb.localToScreen(this.thumb.getBoundsInLocal().getMinX(), this.thumb.getBoundsInLocal().getMinY());
        Orientation orientation = ((Slider)this.getSkinnable()).getOrientation();
        if (orientation.equals((Object)Orientation.HORIZONTAL)) {
            this.popup.show((Node)this.thumb, thumbScreenPos.getX() + this.thumb.getWidth() / 2.0, thumbScreenPos.getY() - 50.0);
            this.popup.setX(this.popup.getX() - this.popup.getWidth() / 2.0);
        } else if (orientation.equals((Object)Orientation.VERTICAL)) {
            this.popup.show((Node)this.thumb, thumbScreenPos.getX() - 50.0, thumbScreenPos.getY() + this.thumb.getHeight() / 2.0);
            this.popup.setY(this.popup.getY() - this.popup.getHeight() / 2.0);
        }
        FadeTransition fadeInTransition = new FadeTransition(POPUP_FADE_DURATION, (Node)this.popup.getScene().getRoot());
        fadeInTransition.setFromValue(0.0);
        fadeInTransition.setToValue(1.0);
        fadeInTransition.play();
    }

    private void displaceValuePopup() {
        if (!this.isShowValueOnInteraction()) {
            return;
        }
        if (this.popup.isShowing()) {
            this.popup.setValue(((Slider)this.getSkinnable()).getValue());
            Point2D thumbScreenPos = this.thumb.localToScreen(this.thumb.getBoundsInLocal().getMinX(), this.thumb.getBoundsInLocal().getMinY());
            Orientation orientation = ((Slider)this.getSkinnable()).getOrientation();
            if (orientation.equals((Object)Orientation.HORIZONTAL)) {
                this.popup.setX(thumbScreenPos.getX() + this.thumb.getWidth() / 2.0 - this.popup.getWidth() / 2.0);
            } else if (orientation.equals((Object)Orientation.VERTICAL)) {
                this.popup.setY(thumbScreenPos.getY() + this.thumb.getHeight() / 2.0 - this.popup.getHeight() / 2.0);
            }
        }
    }

    private void hideValuePopup() {
        if (!this.isShowValueOnInteraction()) {
            return;
        }
        FadeTransition fadeOutTransition = new FadeTransition(POPUP_FADE_DURATION, (Node)this.popup.getScene().getRoot());
        fadeOutTransition.setFromValue(1.0);
        fadeOutTransition.setToValue(0.0);
        fadeOutTransition.setOnFinished(actionEvent -> this.popup.hide());
        fadeOutTransition.play();
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        Slider control = (Slider)this.getSkinnable();
        boolean showTickMarks = control.isShowTickMarks() || control.isShowTickLabels();
        double thumbWidth = this.snapSizeX(this.thumb.prefWidth(-1.0));
        double thumbHeight = this.snapSizeY(this.thumb.prefHeight(-1.0));
        double trackRadius = this.track.getBackground() == null ? 0.0 : (this.track.getBackground().getFills().size() > 0 ? ((BackgroundFill)this.track.getBackground().getFills().get(0)).getRadii().getTopLeftHorizontalRadius() : 0.0);
        NumberAxis tickLine = (NumberAxis)control.lookup("NumberAxis");
        if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
            double tickLineHeight = showTickMarks ? tickLine.prefHeight(-1.0) : 0.0;
            double trackHeight = this.snapSizeY(this.track.prefHeight(-1.0));
            double trackAreaHeight = Math.max(trackHeight, thumbHeight);
            double totalHeightNeeded = trackAreaHeight + (showTickMarks ? this.trackToTickGap + tickLineHeight : 0.0);
            double startY = y + (h - totalHeightNeeded) / 2.0;
            double trackStart = this.snapPositionX(x + thumbWidth / 2.0);
            double trackTop = (int)(startY + (trackAreaHeight - trackHeight) / 2.0);
            this.fill.resizeRelocate((double)((int)(trackStart - trackRadius)), trackTop, (double)((int)trackStart) - trackRadius + this.thumb.getLayoutX(), trackHeight);
        } else {
            double tickLineWidth = showTickMarks ? tickLine.prefWidth(-1.0) : 0.0;
            double trackWidth = this.snapSizeX(this.track.prefWidth(-1.0));
            double trackAreaWidth = Math.max(trackWidth, thumbWidth);
            double totalWidthNeeded = trackAreaWidth + (showTickMarks ? this.trackToTickGap + tickLineWidth : 0.0);
            double startX = x + (w - totalWidthNeeded) / 2.0;
            double trackLength = this.snapSizeY(h - thumbHeight);
            double trackStart = this.snapPositionY(y + thumbHeight / 2.0);
            double trackLeft = (int)(startX + (trackAreaWidth - trackWidth) / 2.0);
            this.fill.resizeRelocate(trackLeft, (double)((int)trackStart) - trackRadius + this.thumb.getLayoutY(), trackWidth, trackLength - this.thumb.getLayoutY());
        }
    }

    private BooleanProperty showValueOnInteractionProperty() {
        return this.showValueOnInteraction;
    }

    private boolean isShowValueOnInteraction() {
        return this.showValueOnInteraction.get();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return SliderSkin.getClassCssMetaData();
    }

    static {
        ArrayList<CssMetaData<Slider, Boolean>> styleables = new ArrayList<CssMetaData<Slider, Boolean>>(SkinBase.getClassCssMetaData());
        styleables.add(SHOW_VALUE_ON_INTERACTION_META_DATA);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }
}

