/*
 * Decompiled with CFR 0.152.
 */
package impl.jfxtras.styles.jmetro;

import java.util.ArrayList;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.Transition;
import javafx.animation.TranslateTransition;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class ProgressBarSkin
extends SkinBase<ProgressBar> {
    private static final int NUMBER_DOTS = 5;
    private static final String DOT_STYLE_CLASS = "dot";
    private static final String SINGLE_DOT_STYLE_CLASS_PREFIX = "dot_";
    private static final int SCREEN_OFFSET = 50;
    private static final int MS_BETWEEN_DOTS = 200;
    private double barWidth;
    private StackPane bar;
    private StackPane track;
    protected List<Region> dots = new ArrayList<Region>(5);
    private Animation indeterminateAnimation;
    private Rectangle clip;
    private double previousWidth = -1.0;
    private double previousHeight = -1.0;

    public ProgressBarSkin(ProgressBar control) {
        super((Control)control);
        this.barWidth = (double)((int)(control.getWidth() - this.snappedLeftInset() - this.snappedRightInset()) * 2) * Math.min(1.0, Math.max(0.0, control.getProgress())) / 2.0;
        control.progressProperty().addListener(observable -> this.updateProgress());
        control.widthProperty().addListener(observable -> this.updateProgress());
        this.initialize();
    }

    protected void initialize() {
        this.createDots();
        this.clip = new Rectangle();
        this.track = new StackPane();
        this.track.getStyleClass().setAll((Object[])new String[]{"track"});
        this.bar = new StackPane();
        this.bar.getStyleClass().setAll((Object[])new String[]{"bar"});
        this.getChildren().setAll((Object[])new Node[]{this.track, this.bar});
        this.getChildren().addAll(this.dots);
    }

    protected void updateProgress() {
        ProgressIndicator control = (ProgressIndicator)this.getSkinnable();
        boolean isIndeterminate = control.isIndeterminate();
        if (!isIndeterminate) {
            this.barWidth = (double)((int)(control.getWidth() - this.snappedLeftInset() - this.snappedRightInset()) * 2) * Math.min(1.0, Math.max(0.0, control.getProgress())) / 2.0;
            ((ProgressBar)this.getSkinnable()).requestLayout();
        }
    }

    private void createDots() {
        for (int i = 0; i < 5; ++i) {
            Region dot = new Region();
            dot.getStyleClass().setAll((Object[])new String[]{DOT_STYLE_CLASS, SINGLE_DOT_STYLE_CLASS_PREFIX + (i + 1)});
            dot.setLayoutX(-50.0);
            this.dots.add(dot);
        }
    }

    private Transition createAnimation() {
        ParallelTransition parallelTransition = new ParallelTransition();
        for (int i = 0; i < 5; ++i) {
            Region dot = this.dots.get(i);
            Transition transition = this.createAnimationForDot(dot, i);
            transition.setDelay(Duration.millis((double)(i * 200)));
            parallelTransition.getChildren().add((Object)transition);
        }
        parallelTransition.setCycleCount(-1);
        return parallelTransition;
    }

    private Transition createAnimationForDot(Region dot, int dotNumber) {
        double controlWidth = ((ProgressBar)this.getSkinnable()).getBoundsInLocal().getWidth();
        double firstStop = 0.6 * controlWidth;
        SequentialTransition sequentialTransition = new SequentialTransition();
        TranslateTransition firstTranslation = new TranslateTransition(Duration.millis((double)1800.0), (Node)dot);
        firstTranslation.setFromX(0.0);
        firstTranslation.setToX(firstStop - (double)(dotNumber * 8));
        firstTranslation.setInterpolator(Interpolator.SPLINE((double)0.2135, (double)0.9351, (double)0.7851, (double)0.964));
        TranslateTransition secondTranslation = new TranslateTransition(Duration.millis((double)600.0), (Node)dot);
        secondTranslation.setToX(controlWidth + 50.0);
        secondTranslation.setInterpolator(Interpolator.SPLINE((double)0.9351, (double)0.2135, (double)0.964, (double)0.7851));
        sequentialTransition.getChildren().addAll((Object[])new Animation[]{firstTranslation, secondTranslation});
        return sequentialTransition;
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        ProgressBar control = (ProgressBar)this.getSkinnable();
        boolean isIndeterminate = control.isIndeterminate();
        this.track.resizeRelocate(contentX, contentY, contentWidth, contentHeight);
        this.track.setVisible(true);
        if (isIndeterminate) {
            if (this.indeterminateAnimation != null) {
                this.indeterminateAnimation.stop();
            }
            for (int i = 0; i < 5; ++i) {
                Region dot = this.dots.get(i);
                dot.resize(dot.prefWidth(-1.0), dot.prefHeight(-1.0));
                dot.setLayoutY(0.0);
            }
            this.indeterminateAnimation = this.createAnimation();
            if (this.previousWidth == -1.0 || this.previousHeight == -1.0 || this.previousWidth != contentWidth || this.previousHeight != contentHeight) {
                this.indeterminateAnimation.play();
            }
            this.clip.setLayoutY(contentX);
            this.clip.setLayoutY(contentY);
            this.clip.setWidth(contentWidth);
            this.clip.setHeight(contentHeight);
            control.setClip((Node)this.clip);
        } else {
            if (this.indeterminateAnimation != null) {
                this.indeterminateAnimation.stop();
                this.indeterminateAnimation = null;
            }
            control.setClip(null);
            this.bar.resizeRelocate(contentX, contentY, this.barWidth, contentHeight);
        }
        this.previousWidth = contentWidth;
        this.previousHeight = contentHeight;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (((ProgressBar)this.getSkinnable()).isIndeterminate()) {
            double maxDotsHeight = 0.0;
            for (Region dot : this.dots) {
                maxDotsHeight = Math.max(dot.prefHeight(-1.0), maxDotsHeight);
            }
            return topInset + maxDotsHeight + bottomInset;
        }
        return topInset + this.track.prefHeight(-1.0) + bottomInset;
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (((ProgressBar)this.getSkinnable()).isIndeterminate()) {
            double maxDotsHeight = 0.0;
            for (Region dot : this.dots) {
                maxDotsHeight = Math.max(dot.maxHeight(-1.0), maxDotsHeight);
            }
            return topInset + maxDotsHeight + bottomInset;
        }
        return topInset + this.track.maxHeight(-1.0) + bottomInset;
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (((ProgressBar)this.getSkinnable()).isIndeterminate()) {
            double maxDotsHeight = 0.0;
            for (Region dot : this.dots) {
                maxDotsHeight = Math.max(dot.minHeight(-1.0), maxDotsHeight);
            }
            return topInset + maxDotsHeight + bottomInset;
        }
        return topInset + this.track.minHeight(-1.0) + bottomInset;
    }
}

