/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat.math3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u0015\b\u0016\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J1\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J#\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u0003H\u0002J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003J\b\u0010 \u001a\u00020\u0003H\u0002J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0000J\u001f\u0010#\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010$J\u0006\u0010%\u001a\u00020\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Ljetbrains/datalore/plot/base/stat/math3/BlockRealMatrix;", "", "rows", "", "columns", "(II)V", "rawData", "", "", "([[D)V", "BLOCK_SIZE", "blockColumns", "blockRows", "blocks", "[[D", "blockHeight", "blockRow", "blockWidth", "blockColumn", "create", "", "blockData", "copyArray", "", "(II[[DZ)V", "createBlocksLayout", "(II)[[D", "getColumnDimension", "getEntry", "", "row", "column", "getRowDimension", "multiply", "m", "toBlocksLayout", "([[D)[[D", "transpose", "plot-base-portable"})
public final class BlockRealMatrix {
    private final int BLOCK_SIZE;
    private int rows;
    private int columns;
    private int blockRows;
    private int blockColumns;
    private double[][] blocks;

    public BlockRealMatrix(int rows, int columns) {
        this.BLOCK_SIZE = 52;
        this.rows = rows;
        this.columns = columns;
        this.blockRows = (rows + this.BLOCK_SIZE - 1) / this.BLOCK_SIZE;
        this.blockColumns = (columns + this.BLOCK_SIZE - 1) / this.BLOCK_SIZE;
        this.blocks = this.createBlocksLayout(rows, columns);
    }

    public BlockRealMatrix(@NotNull double[][] rawData) {
        Intrinsics.checkNotNullParameter((Object)rawData, (String)"rawData");
        this.BLOCK_SIZE = 52;
        this.create(((Object[])rawData).length, rawData[0].length, this.toBlocksLayout(rawData), false);
    }

    public final void create(int rows, int columns, @NotNull double[][] blockData, boolean copyArray) {
        Intrinsics.checkNotNullParameter((Object)blockData, (String)"blockData");
        this.rows = rows;
        this.columns = columns;
        this.blockRows = (rows + this.BLOCK_SIZE - 1) / this.BLOCK_SIZE;
        this.blockColumns = (columns + this.BLOCK_SIZE - 1) / this.BLOCK_SIZE;
        ArrayList<double[]> blocksCopyList = new ArrayList<double[]>();
        if (!copyArray) {
            this.blocks = blockData;
        }
        int index = 0;
        int n = 0;
        int n2 = this.blockRows;
        if (n < n2) {
            do {
                int iBlock = n++;
                int iHeight = this.blockHeight(iBlock);
                int jBlock = 0;
                while (jBlock < this.blockColumns) {
                    boolean bl;
                    Object object;
                    if (blockData[index].length != iHeight * this.blockWidth(jBlock)) {
                        object = "";
                        bl = false;
                        throw (Throwable)new IllegalStateException(object.toString());
                    }
                    if (copyArray) {
                        object = blockData[index];
                        bl = false;
                        double[] dArray = Arrays.copyOf((double[])object, ((Object)object).length);
                        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"java.util.Arrays.copyOf(this, size)");
                        blocksCopyList.add(dArray);
                    }
                    ++jBlock;
                    ++index;
                }
            } while (n < n2);
        }
        if (copyArray) {
            Collection $this$toTypedArray$iv = blocksCopyList;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            T[] TArray = thisCollection$iv.toArray((T[])new double[0][]);
            if (TArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            this.blocks = (double[][])TArray;
        }
    }

    private final double[][] createBlocksLayout(int rows, int columns) {
        int blockRows = (rows + this.BLOCK_SIZE - 1) / this.BLOCK_SIZE;
        int blockColumns = (columns + this.BLOCK_SIZE - 1) / this.BLOCK_SIZE;
        ArrayList<double[]> blocksList = new ArrayList<double[]>();
        int blockIndex = 0;
        int n = 0;
        if (n < blockRows) {
            do {
                int iBlock = n++;
                int pStart = iBlock * this.BLOCK_SIZE;
                int n2 = pStart + this.BLOCK_SIZE;
                int n3 = 0;
                int pEnd = Math.min(n2, rows);
                int iHeight = pEnd - pStart;
                n3 = 0;
                if (n3 >= blockColumns) continue;
                do {
                    int jBlock = n3++;
                    int qStart = jBlock * this.BLOCK_SIZE;
                    int n4 = qStart + this.BLOCK_SIZE;
                    boolean bl = false;
                    int qEnd = Math.min(n4, columns);
                    int jWidth = qEnd - qStart;
                    blocksList.add(new double[iHeight * jWidth]);
                    ++blockIndex;
                } while (n3 < blockColumns);
            } while (n < blockRows);
        }
        Collection $this$toTypedArray$iv = blocksList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        T[] TArray = thisCollection$iv.toArray((T[])new double[0][]);
        if (TArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (double[][])TArray;
    }

    @NotNull
    public final BlockRealMatrix transpose() {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        BlockRealMatrix out = new BlockRealMatrix(nCols, nRows);
        int blockIndex = 0;
        int n = 0;
        int n2 = this.blockColumns;
        if (n < n2) {
            do {
                int iBlock = n++;
                int n3 = 0;
                int n4 = this.blockRows;
                if (n3 >= n4) continue;
                do {
                    double[][] dArray;
                    double[][] dArray2;
                    int jBlock = n3++;
                    double[][] dArray3 = out.blocks;
                    if (dArray3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"blocks");
                        dArray2 = null;
                    } else {
                        dArray2 = dArray3;
                    }
                    double[] outBlock = dArray2[blockIndex];
                    double[][] dArray4 = this.blocks;
                    if (dArray4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"blocks");
                        dArray = null;
                    } else {
                        dArray = dArray4;
                    }
                    double[] tBlock = dArray[jBlock * this.blockColumns + iBlock];
                    int pStart = iBlock * this.BLOCK_SIZE;
                    int n5 = pStart + this.BLOCK_SIZE;
                    int n6 = this.columns;
                    int n7 = 0;
                    int pEnd = Math.min(n5, n6);
                    int qStart = jBlock * this.BLOCK_SIZE;
                    n7 = qStart + this.BLOCK_SIZE;
                    int n8 = this.rows;
                    boolean bl = false;
                    int qEnd = Math.min(n7, n8);
                    int k = 0;
                    n8 = pStart;
                    if (n8 < pEnd) {
                        do {
                            int p = n8++;
                            int lInc = pEnd - pStart;
                            int l = p - pStart;
                            int n9 = qStart;
                            if (n9 >= qEnd) continue;
                            do {
                                int q = n9++;
                                outBlock[k] = tBlock[l];
                                ++k;
                                l += lInc;
                            } while (n9 < qEnd);
                        } while (n8 < pEnd);
                    }
                    ++blockIndex;
                } while (n3 < n4);
            } while (n < n2);
        }
        return out;
    }

    @NotNull
    public final BlockRealMatrix multiply(@NotNull BlockRealMatrix m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        if (this.getColumnDimension() != m.getRowDimension()) {
            String string = "Matrix multiply dimension mismatch: " + this.getColumnDimension() + " x " + m.getRowDimension();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        BlockRealMatrix out = new BlockRealMatrix(this.rows, m.columns);
        int blockIndex = 0;
        int n = 0;
        int n2 = out.blockRows;
        if (n < n2) {
            do {
                int iBlock = n++;
                int pStart = iBlock * this.BLOCK_SIZE;
                int n3 = pStart + this.BLOCK_SIZE;
                int n4 = this.rows;
                boolean bl = false;
                int pEnd = Math.min(n3, n4);
                n3 = 0;
                n4 = out.blockColumns;
                if (n3 >= n4) continue;
                do {
                    double[][] dArray;
                    int jBlock = n3++;
                    int jWidth = out.blockWidth(jBlock);
                    int jWidth2 = jWidth + jWidth;
                    int jWidth3 = jWidth2 + jWidth;
                    int jWidth4 = jWidth3 + jWidth;
                    double[][] dArray2 = out.blocks;
                    if (dArray2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"blocks");
                        dArray = null;
                    } else {
                        dArray = dArray2;
                    }
                    double[] outBlock = dArray[blockIndex];
                    int n5 = 0;
                    int n6 = this.blockColumns;
                    if (n5 < n6) {
                        do {
                            double[][] dArray3;
                            double[][] dArray4;
                            int kBlock = n5++;
                            int kWidth = this.blockWidth(kBlock);
                            double[][] dArray5 = this.blocks;
                            if (dArray5 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"blocks");
                                dArray4 = null;
                            } else {
                                dArray4 = dArray5;
                            }
                            double[] tBlock = dArray4[iBlock * this.blockColumns + kBlock];
                            double[][] dArray6 = m.blocks;
                            if (dArray6 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"blocks");
                                dArray3 = null;
                            } else {
                                dArray3 = dArray6;
                            }
                            double[] mBlock = dArray3[kBlock * m.blockColumns + jBlock];
                            int k = 0;
                            int n7 = pStart;
                            if (n7 >= pEnd) continue;
                            do {
                                int p = n7++;
                                int lStart = (p - pStart) * kWidth;
                                int lEnd = lStart + kWidth;
                                int n8 = 0;
                                if (n8 >= jWidth) continue;
                                do {
                                    int nStart = n8++;
                                    double sum = 0.0;
                                    int l = lStart;
                                    int n9 = nStart;
                                    while (l < lEnd - 3) {
                                        sum += tBlock[l] * mBlock[n9] + tBlock[l + 1] * mBlock[n9 + jWidth] + tBlock[l + 2] * mBlock[n9 + jWidth2] + tBlock[l + 3] * mBlock[n9 + jWidth3];
                                        l += 4;
                                        n9 += jWidth4;
                                    }
                                    while (l < lEnd) {
                                        int n10 = l;
                                        l = n10 + 1;
                                        sum += tBlock[n10] * mBlock[n9];
                                        n9 += jWidth;
                                    }
                                    double[] dArray7 = outBlock;
                                    int n11 = k++;
                                    dArray7[n11] = dArray7[n11] + sum;
                                } while (n8 < jWidth);
                            } while (n7 < pEnd);
                        } while (n5 < n6);
                    }
                    ++blockIndex;
                } while (n3 < n4);
            } while (n < n2);
        }
        return out;
    }

    public final double getEntry(int row, int column) {
        double[][] dArray;
        if (row < 0 || row > this.getRowDimension()) {
            String string = Intrinsics.stringPlus((String)"row out of range: ", (Object)row);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (column < 0 || column > this.getColumnDimension()) {
            String string = Intrinsics.stringPlus((String)"column out of range: ", (Object)column);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        int iBlock = row / this.BLOCK_SIZE;
        int jBlock = column / this.BLOCK_SIZE;
        int k = (row - iBlock * this.BLOCK_SIZE) * this.blockWidth(jBlock) + (column - jBlock * this.BLOCK_SIZE);
        double[][] dArray2 = this.blocks;
        if (dArray2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"blocks");
            dArray = null;
        } else {
            dArray = dArray2;
        }
        return dArray[iBlock * this.blockColumns + jBlock][k];
    }

    private final int getRowDimension() {
        return this.rows;
    }

    private final int getColumnDimension() {
        return this.columns;
    }

    private final int blockWidth(int blockColumn) {
        return blockColumn == this.blockColumns - 1 ? this.columns - blockColumn * this.BLOCK_SIZE : this.BLOCK_SIZE;
    }

    private final int blockHeight(int blockRow) {
        return blockRow == this.blockRows - 1 ? this.rows - blockRow * this.BLOCK_SIZE : this.BLOCK_SIZE;
    }

    @NotNull
    public final double[][] toBlocksLayout(@NotNull double[][] rawData) {
        int i;
        Intrinsics.checkNotNullParameter((Object)rawData, (String)"rawData");
        int rows = ((Object[])rawData).length;
        int columns = rawData[0].length;
        int blockRows = (rows + this.BLOCK_SIZE - 1) / this.BLOCK_SIZE;
        int blockColumns = (columns + this.BLOCK_SIZE - 1) / this.BLOCK_SIZE;
        int n = 0;
        int n2 = ((Object[])rawData).length + -1;
        if (n <= n2) {
            do {
                int length;
                if ((length = rawData[i = n++].length) == columns) continue;
                String string = "Wrong dimension: " + columns + ", " + length;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            } while (n <= n2);
        }
        ArrayList<double[]> blocksList = new ArrayList<double[]>();
        int blockIndex = 0;
        i = 0;
        if (i < blockRows) {
            do {
                int iBlock = i++;
                int pStart = iBlock * this.BLOCK_SIZE;
                int n3 = pStart + this.BLOCK_SIZE;
                int n4 = 0;
                int pEnd = Math.min(n3, rows);
                int iHeight = pEnd - pStart;
                n4 = 0;
                if (n4 >= blockColumns) continue;
                do {
                    int jBlock = n4++;
                    int qStart = jBlock * this.BLOCK_SIZE;
                    int n5 = qStart + this.BLOCK_SIZE;
                    boolean bl = false;
                    int qEnd = Math.min(n5, columns);
                    int jWidth = qEnd - qStart;
                    double[] block = new double[iHeight * jWidth];
                    blocksList.add(block);
                    int index = 0;
                    int n6 = pStart;
                    if (n6 < pEnd) {
                        do {
                            int p = n6++;
                            ArraysKt.copyInto((double[])rawData[p], (double[])block, (int)index, (int)qStart, (int)qEnd);
                            index += jWidth;
                        } while (n6 < pEnd);
                    }
                    ++blockIndex;
                } while (n4 < blockColumns);
            } while (i < blockRows);
        }
        Collection $this$toTypedArray$iv = blocksList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        T[] TArray = thisCollection$iv.toArray((T[])new double[0][]);
        if (TArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (double[][])TArray;
    }
}

