/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom;

import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.geom.GeomBase;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.plot.base.render.point.PointShape;
import jetbrains.datalore.plot.base.render.point.PointShapeSvg;
import jetbrains.datalore.vis.svg.SvgGElement;
import jetbrains.datalore.vis.svg.slim.SvgSlimObject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ljetbrains/datalore/plot/base/geom/PointLegendKeyElementFactory;", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "fatten", "", "(D)V", "createKeyElement", "Ljetbrains/datalore/vis/svg/SvgGElement;", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "size", "Ljetbrains/datalore/base/geometry/DoubleVector;", "minimumKeySize", "plot-base-portable"})
public final class PointLegendKeyElementFactory
implements LegendKeyElementFactory {
    private final double fatten;

    public PointLegendKeyElementFactory(double fatten) {
        this.fatten = fatten;
    }

    public /* synthetic */ PointLegendKeyElementFactory(double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 1.0;
        }
        this(d);
    }

    @Override
    @NotNull
    public SvgGElement createKeyElement(@NotNull DataPointAesthetics p, @NotNull DoubleVector size) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        DoubleVector location = new DoubleVector(size.getX() / (double)2, size.getY() / (double)2);
        PointShape pointShape = p.shape();
        Intrinsics.checkNotNull((Object)pointShape);
        PointShape shape = pointShape;
        SvgSlimObject slimObject = PointShapeSvg.INSTANCE.create(shape, location, p, this.fatten);
        return GeomBase.Companion.wrap(slimObject);
    }

    @Override
    @NotNull
    public DoubleVector minimumKeySize(@NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        PointShape pointShape = p.shape();
        Intrinsics.checkNotNull((Object)pointShape);
        PointShape shape = pointShape;
        double shapeSize = shape.size(p) * this.fatten;
        double strokeWidth = shape.strokeWidth(p);
        double size = shapeSize + strokeWidth + 2.0;
        return new DoubleVector(size, size);
    }

    public PointLegendKeyElementFactory() {
        this(0.0, 1, null);
    }
}

