/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.core;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.core.ByteReadPacketBase;
import kotlinx.io.core.Input;
import kotlinx.io.core.IoBuffer;
import kotlinx.io.core.internal.DangerousInternalIoApi;
import kotlinx.io.core.internal.UnsafeKt;
import kotlinx.io.pool.ObjectPool;
import org.jetbrains.annotations.NotNull;

@DangerousInternalIoApi
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u00012\u00020\u0002B%\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016\u00a8\u0006\u0011"}, d2={"Lkotlinx/io/core/ByteReadPacketPlatformBase;", "Lkotlinx/io/core/ByteReadPacketBase;", "Lkotlinx/io/core/Input;", "head", "Lkotlinx/io/core/IoBuffer;", "remaining", "", "pool", "Lkotlinx/io/pool/ObjectPool;", "(Lkotlinx/io/core/IoBuffer;JLkotlinx/io/pool/ObjectPool;)V", "readAvailable", "", "dst", "Ljava/nio/ByteBuffer;", "length", "readFully", "", "kotlinx-io"})
public abstract class ByteReadPacketPlatformBase
extends ByteReadPacketBase
implements Input {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFully(@NotNull ByteBuffer dst, int length) {
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        boolean bl = (long)length <= this.getRemaining();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Not enough bytes available (" + this.getRemaining() + ") to read " + length + " bytes";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = length <= dst.remaining();
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Not enough free space in destination buffer to write " + length + " bytes";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int copied = 0;
        ByteReadPacketPlatformBase $this$takeWhile$iv = this;
        boolean $i$f$takeWhile = false;
        boolean release$iv = true;
        IoBuffer ioBuffer = UnsafeKt.prepareReadFirstHead($this$takeWhile$iv, 1);
        if (ioBuffer == null) {
        } else {
            IoBuffer current$iv = ioBuffer;
            try {
                while (true) {
                    IoBuffer next$iv;
                    IoBuffer buffer = current$iv;
                    boolean bl6 = false;
                    int rc = buffer.readAvailable(dst, length - copied);
                    if (rc > 0) {
                        copied += rc;
                    }
                    if (!(copied < length)) {
                        break;
                    }
                    release$iv = false;
                    if (UnsafeKt.prepareReadNextHead($this$takeWhile$iv, current$iv) == null) {
                        break;
                    }
                    current$iv = next$iv;
                    release$iv = true;
                }
            }
            finally {
                if (release$iv) {
                    UnsafeKt.completeReadHead($this$takeWhile$iv, current$iv);
                }
            }
        }
    }

    @Override
    public int readAvailable(@NotNull ByteBuffer dst, int length) {
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        long remaining = this.getRemaining();
        if (remaining == 0L) {
            return -1;
        }
        long l = dst.remaining();
        long l2 = length;
        boolean bl = false;
        boolean bl2 = false;
        long l3 = Math.min(l2, remaining);
        boolean bl3 = false;
        int size = (int)Math.min(l, l3);
        this.readFully(dst, size);
        return size;
    }

    protected ByteReadPacketPlatformBase(@NotNull IoBuffer head, long remaining, @NotNull ObjectPool<IoBuffer> pool) {
        Intrinsics.checkParameterIsNotNull((Object)head, (String)"head");
        Intrinsics.checkParameterIsNotNull(pool, (String)"pool");
        super(head, remaining, pool);
    }
}

