/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.AssignmentCheckUtilsKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.StubTypeForBuilderInference;
import org.jetbrains.kotlin.types.expressions.BasicExpressionTypingVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/BuilderInferenceAssignmentChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
@SourceDebugExtension(value={"SMAP\nBuilderInferenceAssignmentChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuilderInferenceAssignmentChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/BuilderInferenceAssignmentChecker\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n232#2:54\n1#3:55\n*S KotlinDebug\n*F\n+ 1 BuilderInferenceAssignmentChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/BuilderInferenceAssignmentChecker\n*L\n31#1:54\n*E\n"})
public final class BuilderInferenceAssignmentChecker
implements CallChecker {
    @NotNull
    public static final BuilderInferenceAssignmentChecker INSTANCE = new BuilderInferenceAssignmentChecker();

    private BuilderInferenceAssignmentChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        block18: {
            KtExpression right;
            block15: {
                KotlinType kotlinType;
                block17: {
                    block16: {
                        KotlinType kotlinType2;
                        void $this$getParentOfType$iv;
                        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
                        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
                        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                        Object obj = resolvedCall2.getResultingDescriptor();
                        Intrinsics.checkNotNullExpressionValue(obj, (String)"getResultingDescriptor(...)");
                        Object resultingDescriptor = obj;
                        if (!(resultingDescriptor instanceof PropertyDescriptor)) {
                            return;
                        }
                        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.NoBuilderInferenceWithoutAnnotationRestriction)) {
                            return;
                        }
                        KtElement ktElement = resolvedCall2.getCall().getCallElement();
                        Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"getCallElement(...)");
                        KtElement callElement = ktElement;
                        if (!(callElement instanceof KtNameReferenceExpression)) {
                            return;
                        }
                        PsiElement psiElement = callElement;
                        boolean strict$iv = true;
                        boolean $i$f$getParentOfType = false;
                        KtBinaryExpression ktBinaryExpression = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtBinaryExpression.class, strict$iv);
                        if (ktBinaryExpression == null) {
                            return;
                        }
                        KtBinaryExpression binaryExpression = ktBinaryExpression;
                        if (!Intrinsics.areEqual((Object)binaryExpression.getOperationToken(), (Object)KtTokens.EQ)) {
                            return;
                        }
                        if (!BasicExpressionTypingVisitor.isLValue((KtSimpleNameExpression)callElement, binaryExpression)) {
                            return;
                        }
                        KtExpression ktExpression = binaryExpression.getRight();
                        if (ktExpression == null) {
                            return;
                        }
                        right = ktExpression;
                        if (!(resolvedCall2.getCandidateDescriptor().getReturnType() instanceof StubTypeForBuilderInference)) break block15;
                        kotlinType = ((PropertyDescriptor)resultingDescriptor).getReturnType();
                        if (kotlinType == null) break block16;
                        KotlinType it = kotlinType2 = kotlinType;
                        boolean bl = false;
                        kotlinType = !KotlinTypeKt.isError(it) ? kotlinType2 : null;
                        if (kotlinType != null) break block17;
                    }
                    return;
                }
                KotlinType leftType = kotlinType;
                BindingContext bindingContext = context2.getTrace().getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
                KotlinType kotlinType3 = CallUtilKt.getType(right, bindingContext);
                if (kotlinType3 == null) {
                    return;
                }
                KotlinType rightType = kotlinType3;
                if (AssignmentCheckUtilsKt.isAssignmentCorrectWithDataFlowInfo(leftType, right, rightType, context2)) {
                    return;
                }
                context2.getTrace().report(Errors.TYPE_MISMATCH.on((KtExpression)((PsiElement)right), leftType, rightType));
                break block18;
            }
            if (right instanceof KtLambdaExpression) {
                KtFunctionLiteral ktFunctionLiteral = ((KtLambdaExpression)right).getFunctionLiteral();
                Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"getFunctionLiteral(...)");
                KtFunctionLiteral functionLiteral = ktFunctionLiteral;
                SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)context2.getTrace().get(BindingContext.FUNCTION, ((KtLambdaExpression)right).getFunctionLiteral());
                if (simpleFunctionDescriptor == null) {
                    return;
                }
                SimpleFunctionDescriptor functionDescriptor = simpleFunctionDescriptor;
                Iterator iterator2 = ((Iterable)functionDescriptor.getValueParameters()).iterator();
                int n2 = 0;
                while (iterator2.hasNext()) {
                    int index = n2++;
                    ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)iterator2.next();
                    if (!(valueParameterDescriptor.getType() instanceof StubTypeForBuilderInference)) continue;
                    List<KtParameter> list = functionLiteral.getValueParameters();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
                    KtParameter ktParameter = (KtParameter)CollectionsKt.getOrNull(list, (int)index);
                    NavigatablePsiElement target = ktParameter != null ? (NavigatablePsiElement)ktParameter : (NavigatablePsiElement)functionLiteral;
                    context2.getTrace().report(Errors.BUILDER_INFERENCE_STUB_PARAMETER_TYPE.on((KtDeclaration)target, valueParameterDescriptor.getName()));
                }
            }
        }
    }
}

