/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.jvm;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.JvmBackendClassResolver;
import org.jetbrains.kotlin.codegen.JvmBackendClassResolverKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/FirJvmBackendClassResolver;", "Lorg/jetbrains/kotlin/codegen/JvmBackendClassResolver;", "components", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;)V", "getComponents", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "resolveToClassDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "jvm-backend"})
public final class FirJvmBackendClassResolver
implements JvmBackendClassResolver {
    @NotNull
    private final Fir2IrComponents components;

    public FirJvmBackendClassResolver(@NotNull Fir2IrComponents components2) {
        Intrinsics.checkNotNullParameter((Object)components2, (String)"components");
        this.components = components2;
    }

    @NotNull
    public final Fir2IrComponents getComponents() {
        return this.components;
    }

    @Override
    @NotNull
    public List<ClassDescriptor> resolveToClassDescriptors(@NotNull Type type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (type2.getSort() != 10) {
            return CollectionsKt.emptyList();
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(this.components.getSession()).getClassLikeSymbolByClassId(JvmBackendClassResolverKt.getClassId(type2));
        if (firClassLikeSymbol == null) {
            return CollectionsKt.emptyList();
        }
        FirClassLikeSymbol<?> symbol2 = firClassLikeSymbol;
        if (!(symbol2 instanceof FirClassSymbol)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return CollectionsKt.listOf(this.components.getClassifierStorage().getIrClassSymbol((FirClassSymbol)symbol2).getDescriptor());
    }
}

