/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import hudson.util.VersionNumber;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.jar.JarFile;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.eclipse.jetty.maven.plugin.JettyWebAppContext;
import org.eclipse.jetty.maven.plugin.MavenServerConnector;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jenkinsci.maven.plugins.hpi.AbstractJettyMojo;
import org.jenkinsci.maven.plugins.hpi.Artifacts;
import org.jenkinsci.maven.plugins.hpi.ConsoleScanner;
import org.jenkinsci.maven.plugins.hpi.HplMojo;
import org.jenkinsci.maven.plugins.hpi.JettyAndServletApiOnlyClassLoader;
import org.jenkinsci.maven.plugins.hpi.MavenArtifact;
import org.jenkinsci.maven.plugins.hpi.PluginWorkspaceMap;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.COMPILE)
public class RunMojo
extends AbstractJettyMojo {
    @Parameter(property="webAppFile")
    private File webAppFile;
    @Parameter(property="hudsonHome", defaultValue="${HUDSON_HOME}")
    private File hudsonHome;
    @Parameter(property="jenkinsHome", defaultValue="${JENKINS_HOME}")
    private File jenkinsHome;
    @Parameter(defaultValue="test")
    protected String dependencyResolution;
    @Parameter(defaultValue="${basedir}/src/main/webapp")
    protected File warSourceDirectory;
    @Component
    protected ArtifactResolver artifactResolver;
    @Component
    protected ArtifactFactory artifactFactory;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    protected List<ArtifactRepository> remoteRepos;
    @Parameter(defaultValue="${localRepository}")
    protected ArtifactRepository localRepository;
    @Component
    protected ArtifactMetadataSource artifactMetadataSource;
    @Parameter(property="port")
    protected int defaultPort;
    @Parameter(property="jetty.consoleForceReload", defaultValue="true")
    protected boolean consoleForceReload;
    @Component
    protected MavenProjectBuilder projectBuilder;
    @Parameter
    protected String jenkinsCoreId;
    @Parameter
    protected String jenkinsWarId;
    @Parameter
    protected String maskClasses;
    @Parameter
    protected boolean pluginFirstClassLoader = false;
    @Parameter
    private Map<String, String> systemProperties;
    @Parameter
    private Map<String, String> loggers;
    private Collection<Logger> loggerReferences;
    @Parameter(required=true)
    private String minimumJavaVersion;
    @Parameter(readonly=true, required=true, defaultValue="/${project.artifactId}")
    protected String contextPath;
    @Component
    protected PluginWorkspaceMap pluginWorkspaceMap;
    private static final String VERSION_PATH = "META-INF/maven/org.jenkins-ci.main/jenkins-war/pom.properties";
    private static final String VERSION_PROP = "version";

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getProject().setArtifacts(this.resolveDependencies(this.dependencyResolution));
        File basedir = this.getProject().getBasedir();
        if ((this.webApp == null || this.webApp.getContextPath() == null) && this.contextPath != null) {
            this.getLog().warn((CharSequence)"Please use `webApp/contextPath` configuration parameter in place of the deprecated `contextPath` parameter");
            if (this.webApp == null) {
                try {
                    this.webApp = new JettyWebAppContext();
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Failed to initialize webApp configuration", e);
                }
            }
            this.webApp.setContextPath(this.contextPath);
        }
        if (this.jenkinsHome == null) {
            Object h;
            if (this.hudsonHome != null) {
                this.getLog().warn((CharSequence)"Please use the `jenkinsHome` configuration parameter in place of the deprecated `hudsonHome` parameter");
                this.jenkinsHome = this.hudsonHome;
            }
            if ((h = System.getenv("JENKINS_HOME")) == null) {
                h = System.getenv("HUDSON_HOME");
            }
            this.jenkinsHome = h != null && !((String)h).isEmpty() && !((String)h).equals("null") ? new File((String)h) : new File(basedir, "work");
        }
        this.setSystemPropertyIfEmpty("stapler.trace", "true");
        this.setSystemPropertyIfEmpty("org.eclipse.jetty.Request.maxFormContentSize", "-1");
        this.setSystemPropertyIfEmpty("hudson.hpi.run", "true");
        this.setSystemPropertyIfEmpty("hudson.DNSMultiCast.disabled", "true");
        this.setSystemPropertyIfEmpty("jenkins.moduleRoot", basedir.getAbsolutePath());
        if (this.systemProperties != null && !this.systemProperties.isEmpty()) {
            for (Map.Entry entry : this.systemProperties.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                System.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        Artifacts jenkinsArtifacts = Artifacts.of(this.getProject()).groupIdIs("org.jenkins-ci.main", "org.jvnet.hudson.main").artifactIdIsNot("remoting");
        if (this.webAppFile == null) {
            Artifact artifact = this.getJenkinsWarArtifact();
            try {
                this.artifactResolver.resolve(artifact, this.remoteRepos, this.localRepository);
            }
            catch (AbstractArtifactResolutionException x) {
                throw new MojoExecutionException("Could not resolve " + artifact + ": " + (Object)((Object)x), (Exception)((Object)x));
            }
            this.webAppFile = artifact.getFile();
            if (this.webAppFile == null || !this.webAppFile.isFile()) {
                throw new MojoExecutionException("Could not find " + this.webAppFile + " from " + artifact);
            }
        }
        for (Artifact a : jenkinsArtifacts) {
            Artifact ba = (Artifact)jenkinsArtifacts.get(0);
            if (a.getVersion().equals(ba.getVersion())) continue;
            throw new MojoExecutionException("Version of " + a.getId() + " is inconsistent with " + ba.getId());
        }
        this.setSystemPropertyIfEmpty("JENKINS_HOME", this.jenkinsHome.getAbsolutePath());
        File file = new File(this.jenkinsHome, "plugins");
        file.mkdirs();
        this.setSystemPropertyIfEmpty("stapler.jelly.noCache", "true");
        List res = this.getProject().getBuild().getResources();
        if (!res.isEmpty()) {
            Resource r = (Resource)res.get(0);
            this.setSystemPropertyIfEmpty("stapler.resourcePath", r.getDirectory());
        }
        this.generateHpl();
        try {
            for (MavenArtifact mavenArtifact : this.getProjectArtifacts()) {
                if (!mavenArtifact.isPlugin()) continue;
                Artifact hpi = this.artifactFactory.createArtifact(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getVersion(), null, "hpi");
                this.artifactResolver.resolve(hpi, this.getProject().getRemoteArtifactRepositories(), this.localRepository);
                if (this.hasSameGavAsProject(hpi)) continue;
                if (hpi.getFile().isDirectory()) {
                    throw new UnsupportedOperationException(hpi.getFile() + " is a directory and not packaged yet. this isn't supported");
                }
                File upstreamHpl = this.pluginWorkspaceMap.read(hpi.getId());
                String actualArtifactId = mavenArtifact.getActualArtifactId();
                if (actualArtifactId == null) {
                    throw new MojoExecutionException("Failed to load actual artifactId from " + mavenArtifact + " ~ " + mavenArtifact.getFile());
                }
                if (upstreamHpl != null) {
                    this.copyHpl(upstreamHpl, file, actualArtifactId);
                    continue;
                }
                this.copyPlugin(hpi.getFile(), file, actualArtifactId);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy dependency plugin", (Exception)e);
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to copy dependency plugin", (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to copy dependency plugin", (Exception)((Object)e));
        }
        if (this.loggers != null) {
            for (Handler h : LogManager.getLogManager().getLogger("").getHandlers()) {
                if (!(h instanceof ConsoleHandler)) continue;
                h.setLevel(Level.ALL);
            }
            this.loggerReferences = new LinkedList<Logger>();
            for (Map.Entry entry : this.loggers.entrySet()) {
                Logger l = Logger.getLogger((String)entry.getKey());
                this.loggerReferences.add(l);
                l.setLevel(Level.parse((String)entry.getValue()));
            }
        }
        super.execute();
    }

    private boolean hasSameGavAsProject(Artifact a) {
        return this.getProject().getGroupId().equals(a.getGroupId()) && this.getProject().getArtifactId().equals(a.getArtifactId()) && this.getProject().getVersion().equals(a.getVersion());
    }

    private void setSystemPropertyIfEmpty(String name, String value) {
        if (System.getProperty(name) == null) {
            System.setProperty(name, value);
        }
    }

    private void copyPlugin(File src, File pluginsDir, String shortName) throws IOException {
        File dst = new File(pluginsDir, shortName + ".jpi");
        File hpi = new File(pluginsDir, shortName + ".hpi");
        if (hpi.isFile()) {
            this.getLog().warn((CharSequence)("Moving historical " + hpi + " to *.jpi"));
            hpi.renameTo(dst);
        }
        VersionNumber dstV = this.versionOfPlugin(dst);
        if (this.versionOfPlugin(src).compareTo(dstV) < 0) {
            this.getLog().info((CharSequence)("will not overwrite " + dst + " with " + src + " because " + dstV + " is newer"));
            return;
        }
        this.getLog().info((CharSequence)("Copying dependency Jenkins plugin " + src));
        FileUtils.copyFile((File)src, (File)dst);
        FileUtils.writeStringToFile((File)new File(dst + ".pinned"), (String)"pinned");
        new File(pluginsDir, shortName + ".jpl").delete();
    }

    private VersionNumber versionOfPlugin(File p) throws IOException {
        JarFile j;
        if (!p.isFile()) {
            return new VersionNumber("0.0");
        }
        try {
            j = new JarFile(p);
        }
        catch (IOException x) {
            throw new IOException("not a valid JarFile: " + p, x);
        }
        try {
            String v = j.getManifest().getMainAttributes().getValue("Plugin-Version");
            if (v == null) {
                throw new IOException("no Plugin-Version in " + p);
            }
            try {
                VersionNumber versionNumber = new VersionNumber(v);
                return versionNumber;
            }
            catch (IllegalArgumentException x) {
                throw new IOException("malformed Plugin-Version in " + p + ": " + x, x);
            }
        }
        finally {
            j.close();
        }
    }

    private void copyHpl(File src, File pluginsDir, String shortName) throws IOException {
        File dst = new File(pluginsDir, shortName + ".jpl");
        this.getLog().info((CharSequence)("Copying snapshot dependency Jenkins plugin " + src));
        FileUtils.copyFile((File)src, (File)dst);
        FileUtils.writeStringToFile((File)new File(pluginsDir, shortName + ".jpi.pinned"), (String)"pinned");
    }

    private void generateHpl() throws MojoExecutionException, MojoFailureException {
        HplMojo hpl = new HplMojo();
        hpl.project = this.getProject();
        hpl.setJenkinsHome(this.jenkinsHome);
        hpl.setLog(this.getLog());
        hpl.pluginName = this.getProject().getName();
        hpl.warSourceDirectory = this.warSourceDirectory;
        hpl.scopeFilter = new ScopeArtifactFilter("runtime");
        hpl.projectBuilder = this.projectBuilder;
        hpl.localRepository = this.localRepository;
        hpl.jenkinsCoreId = this.jenkinsCoreId;
        hpl.pluginFirstClassLoader = this.pluginFirstClassLoader;
        hpl.maskClasses = this.maskClasses;
        hpl.remoteRepos = this.remoteRepos;
        hpl.minimumJavaVersion = this.minimumJavaVersion;
        hpl.execute();
    }

    @Override
    public void configureWebApplication() throws Exception {
        File extractedWebAppDir;
        File t = this.webApp.getTempDirectory();
        if (t == null) {
            t = new File(this.getProject().getBuild().getDirectory(), "tmp");
        }
        if (this.isExtractedWebAppDirStale(extractedWebAppDir = new File(t, "webapp"), this.webAppFile)) {
            FileUtils.deleteDirectory((File)extractedWebAppDir);
        }
        super.configureWebApplication();
        this.getWebAppConfig().setWar(this.webAppFile.getCanonicalPath());
        for (Artifact a : this.project.getArtifacts()) {
            File coreBasedir;
            if (!a.getGroupId().equals("org.jenkins-ci.main") || !a.getArtifactId().equals("jenkins-core") || (coreBasedir = this.pluginWorkspaceMap.read(a.getId())) == null) continue;
            String extraCP = new File(coreBasedir, "src/main/resources").toURI() + "," + new File(coreBasedir, "target/classes").toURI();
            this.getLog().info((CharSequence)("Will load directly from " + extraCP));
            this.getWebAppConfig().setExtraClasspath(extraCP);
        }
        HashLoginService hashLoginService = new HashLoginService("Jenkins Realm");
        hashLoginService.setConfig(System.getProperty("jetty.home", "work") + "/etc/realm.properties");
        this.getWebAppConfig().getSecurityHandler().setLoginService((LoginService)hashLoginService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isExtractedWebAppDirStale(File extractedWebAppDir, File webApp) throws IOException {
        String originalVersion;
        String extractedVersion;
        if (!extractedWebAppDir.isDirectory()) {
            this.getLog().info((CharSequence)(extractedWebAppDir + " does not yet exist, will receive " + webApp));
            return false;
        }
        if (extractedWebAppDir.lastModified() < webApp.lastModified()) {
            this.getLog().info((CharSequence)(extractedWebAppDir + " is older than " + webApp + ", will recreate"));
            return true;
        }
        File extractedPath = new File(extractedWebAppDir, VERSION_PATH);
        if (!extractedPath.isFile()) {
            this.getLog().warn((CharSequence)("no such file " + extractedPath));
            return false;
        }
        try (InputStream is = new FileInputStream(extractedPath);){
            extractedVersion = this.loadVersion(is);
        }
        if (extractedVersion == null) {
            this.getLog().warn((CharSequence)("no version in " + extractedPath));
            return false;
        }
        try (ZipFile zip = new ZipFile(webApp);){
            ZipEntry entry = zip.getEntry(VERSION_PATH);
            if (entry == null) {
                this.getLog().warn((CharSequence)("no META-INF/maven/org.jenkins-ci.main/jenkins-war/pom.properties in " + webApp));
                boolean bl = false;
                return bl;
            }
            is = zip.getInputStream(entry);
            try {
                originalVersion = this.loadVersion(is);
            }
            finally {
                is.close();
            }
        }
        if (originalVersion == null) {
            this.getLog().warn((CharSequence)("no version in jar:" + webApp.toURI() + "!/" + VERSION_PATH));
            return false;
        }
        if (!extractedVersion.equals(originalVersion)) {
            this.getLog().info((CharSequence)("Version " + extractedVersion + " in " + extractedWebAppDir + " does not match " + originalVersion + " in " + webApp + ", will recreate"));
            return true;
        }
        this.getLog().info((CharSequence)(extractedWebAppDir + " already up to date with respect to " + webApp));
        return false;
    }

    private String loadVersion(InputStream is) throws IOException {
        Properties props = new Properties();
        props.load(is);
        return props.getProperty(VERSION_PROP);
    }

    @Override
    public void configureScanner() throws MojoExecutionException {
        for (Connector con : this.server.getConnectors()) {
            for (ConnectionFactory cf : con.getConnectionFactories()) {
                if (!(cf instanceof HttpConnectionFactory)) continue;
                HttpConnectionFactory hcf = (HttpConnectionFactory)cf;
                hcf.getHttpConfiguration().setResponseHeaderSize(12288);
            }
        }
        this.setUpScanList();
        this.scannerListeners = new ArrayList();
        this.scannerListeners.add(new Scanner.BulkListener(){

            public void filesChanged(List<String> changes) {
                try {
                    RunMojo.this.restartWebApp(changes.contains(RunMojo.this.getProject().getFile().getCanonicalPath()));
                }
                catch (Exception e) {
                    RunMojo.this.getLog().error((CharSequence)"Error reconfiguring/restarting webapp after change in watched files", (Throwable)e);
                }
            }
        });
    }

    @Override
    public void restartWebApp(boolean reconfigureScanner) throws Exception {
        this.getLog().info((CharSequence)("restarting " + this.webApp));
        this.getLog().debug((CharSequence)"Stopping webapp ...");
        this.webApp.stop();
        this.getLog().debug((CharSequence)"Reconfiguring webapp ...");
        this.checkPomConfiguration();
        this.configureWebApplication();
        if (reconfigureScanner) {
            this.getLog().info((CharSequence)"Reconfiguring scanner after change to pom.xml ...");
            this.generateHpl();
            this.scanList.clear();
            if (this.webApp.getDescriptor() != null) {
                this.scanList.add(new File(this.webApp.getDescriptor()));
            }
            if (this.webApp.getJettyEnvXml() != null) {
                this.scanList.add(new File(this.webApp.getJettyEnvXml()));
            }
            this.scanList.add(this.project.getFile());
            if (this.webApp.getTestClasses() != null) {
                this.scanList.add(this.webApp.getTestClasses());
            }
            if (this.webApp.getClasses() != null) {
                this.scanList.add(this.webApp.getClasses());
            }
            this.scanList.addAll(this.webApp.getWebInfLib());
            this.scanner.setScanDirs((List)this.scanList);
        }
        this.getLog().debug((CharSequence)"Restarting webapp ...");
        this.webApp.start();
        this.getLog().info((CharSequence)("Restart completed at " + new Date().toString()));
    }

    private void setUpScanList() {
        this.scanList = new ArrayList();
        this.scanList.add(this.getProject().getFile());
        this.scanList.add(this.webAppFile);
        this.scanList.add(new File(this.getProject().getBuild().getOutputDirectory()));
    }

    @Override
    protected void startConsoleScanner() throws Exception {
        if (this.consoleForceReload) {
            this.getLog().info((CharSequence)"Console reloading is ENABLED. Hit ENTER on the console to restart the context.");
            this.consoleScanner = new ConsoleScanner(this);
            this.consoleScanner.start();
        }
    }

    @Override
    public void checkPomConfiguration() throws MojoExecutionException {
    }

    @Override
    public void finishConfigurationBeforeStart() throws Exception {
        super.finishConfigurationBeforeStart();
        WebAppContext wac = this.getWebAppConfig();
        wac.setAttribute("org.eclipse.jetty.server.webapp.WebInfIncludeJarPattern", (Object)".*/classes/.*");
        wac.getSessionHandler().getSessionCookieConfig().setName("JSESSIONID." + UUID.randomUUID().toString().replace("-", "").substring(0, 8));
        try {
            WebAppClassLoader wacl = new WebAppClassLoader(new JettyAndServletApiOnlyClassLoader(this.getPlatformClassLoader(), ((Object)((Object)this)).getClass().getClassLoader()), (WebAppClassLoader.Context)wac){
                private final Pattern exclusionPattern;
                {
                    if (RunMojo.this.getProject().getPackaging().equals("jenkins-module")) {
                        for (Resource r : RunMojo.this.getProject().getResources()) {
                            super.addURL(new File(r.getDirectory()).toURL());
                        }
                        super.addURL(new File(RunMojo.this.getProject().getBuild().getOutputDirectory()).toURL());
                        for (Artifact a : Artifacts.of(RunMojo.this.getProject()).scopeIsNot("provided", "test").typeIsNot("pom")) {
                            super.addURL(a.getFile().toURI().toURL());
                        }
                        this.exclusionPattern = Pattern.compile("[/\\\\]\\Q" + RunMojo.this.getProject().getArtifactId() + "\\E-[0-9]([^/\\\\]+)\\.jar$");
                    } else {
                        this.exclusionPattern = Pattern.compile("this should never match");
                    }
                }

                public void addClassPath(String classPath) throws IOException {
                    if (this.exclusionPattern != null && this.exclusionPattern.matcher(classPath).find()) {
                        return;
                    }
                    super.addClassPath(classPath);
                }

                public void addJars(org.eclipse.jetty.util.resource.Resource lib) {
                    super.addJars(lib);
                }
            };
            wac.setClassLoader((ClassLoader)wacl);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private ClassLoader getPlatformClassLoader() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (this.isPostJava8()) {
            return (ClassLoader)ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
        }
        return null;
    }

    private boolean isPostJava8() {
        return !System.getProperty("java.version").startsWith("1.");
    }

    @Override
    public void startJetty() throws MojoExecutionException {
        if (this.httpConnector == null && this.defaultPort != 0) {
            this.httpConnector = new MavenServerConnector();
            this.httpConnector.setPort(this.defaultPort);
        }
        super.startJetty();
    }

    protected Set<Artifact> resolveDependencies(String scope) throws MojoExecutionException {
        try {
            ArtifactResolutionResult result = this.artifactResolver.resolveTransitively(this.getProject().getDependencyArtifacts(), this.getProject().getArtifact(), this.getProject().getManagedVersionMap(), this.localRepository, this.getProject().getRemoteArtifactRepositories(), this.artifactMetadataSource, (ArtifactFilter)new ScopeArtifactFilter(scope));
            return result.getArtifacts();
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to copy dependency plugin", (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to copy dependency plugin", (Exception)((Object)e));
        }
    }

    public Set<MavenArtifact> getProjectArtifacts() {
        HashSet<MavenArtifact> r = new HashSet<MavenArtifact>();
        for (Artifact a : this.getProject().getArtifacts()) {
            r.add(this.wrap(a));
        }
        return r;
    }

    protected MavenArtifact wrap(Artifact a) {
        return new MavenArtifact(a, this.artifactResolver, this.artifactFactory, this.projectBuilder, this.getProject().getRemoteArtifactRepositories(), this.localRepository);
    }

    protected Artifact getJenkinsWarArtifact() throws MojoExecutionException {
        for (Artifact a : this.resolveDependencies("test")) {
            boolean match;
            if (this.jenkinsWarId != null) {
                match = (a.getGroupId() + ':' + a.getArtifactId()).equals(this.jenkinsWarId);
            } else {
                boolean bl = match = !(!a.getArtifactId().equals("jenkins-war") && !a.getArtifactId().equals("hudson-war") || !a.getType().equals("executable-war") && !a.getType().equals("war"));
            }
            if (!match) continue;
            return a;
        }
        if (this.jenkinsWarId != null) {
            this.getLog().error((CharSequence)("Unable to locate jenkins.war in '" + this.jenkinsWarId + "'"));
        } else {
            this.getLog().error((CharSequence)"Unable to locate jenkins.war. Add the following dependency in your POM:\n\n<dependency>\n  <groupId>org.jenkins-ci.main</groupId>\n  <artifactId>jenkins-war</artifactId>\n  <type>war</type>\n  <version>1.396<!-- replace this with the version you want--></version>\n  <scope>test</scope>\n</dependency>");
        }
        throw new MojoExecutionException("Unable to find jenkins.war");
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public WebAppContext getWebAppConfig() {
        return this.webApp;
    }
}

