/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.codehaus.plexus.util.FileUtils;
import org.jenkinsci.maven.plugins.hpi.AbstractDependencyGraphTraversingMojo;
import org.jenkinsci.maven.plugins.hpi.MavenArtifact;

@Mojo(name="assemble-dependencies", requiresProject=true, threadSafe=true)
public class AssembleDependenciesMojo
extends AbstractDependencyGraphTraversingMojo {
    @Parameter(defaultValue="${project.build.directory}/plugins/")
    private File outputDirectory;
    @Parameter
    private boolean includesOptional;
    @Parameter
    private boolean useJpiExtension;
    @Parameter
    private String scopes = "compile,runtime";
    private List<String> parsedScopes;
    private final Map<String, MavenArtifact> hpis = new HashMap<String, MavenArtifact>();

    @Override
    protected boolean accept(DependencyNode g) {
        MavenArtifact a = this.wrap(g.getArtifact());
        if (!this.parsedScopes.contains(a.getScope())) {
            return false;
        }
        if (!this.includesOptional && a.isOptional()) {
            return false;
        }
        try {
            if (!a.isPlugin()) {
                return g.getParent() == null;
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Failed to process " + a), (Throwable)e);
        }
        MavenArtifact v = this.hpis.get(a.getArtifactId());
        if (v == null || a.isNewerThan(v)) {
            this.hpis.put(a.getArtifactId(), a);
        }
        return true;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.hpis.clear();
            this.parsedScopes = new ArrayList<String>();
            this.parsedScopes.add(null);
            for (String s : this.scopes.split(",")) {
                this.parsedScopes.add(s.trim());
            }
            this.traverseProject();
        }
        catch (DependencyGraphBuilderException e) {
            throw new MojoExecutionException("Failed to list up dependencies", (Exception)((Object)e));
        }
        for (MavenArtifact a : this.hpis.values()) {
            try {
                MavenArtifact hpi = a.getHpi();
                this.getLog().debug((CharSequence)("Copying " + hpi.getFile()));
                FileUtils.copyFile((File)hpi.getFile(), (File)new File(this.outputDirectory, hpi.getArtifactId() + "." + this.getExtension()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy dependency: " + a, (Exception)e);
            }
        }
    }

    private String getExtension() {
        return this.useJpiExtension ? "jpi" : "hpi";
    }
}

