/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Developer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.IOUtil;
import org.jenkinsci.maven.plugins.hpi.AbstractHpiMojo;
import org.jenkinsci.maven.plugins.hpi.MavenArtifact;

public abstract class AbstractJenkinsManifestMojo
extends AbstractHpiMojo {
    private static final Logger LOGGER = Logger.getLogger(AbstractJenkinsManifestMojo.class.getName());
    @Parameter(property="hpi.compatibleSinceVersion")
    private String compatibleSinceVersion;
    @Parameter
    private String sandboxStatus;
    @Parameter(required=true)
    protected String minimumJavaVersion;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void generateManifest(MavenArchiveConfiguration archive, File manifestFile) throws MojoExecutionException {
        if (!manifestFile.getParentFile().exists()) {
            manifestFile.getParentFile().mkdirs();
        }
        this.getLog().info((CharSequence)("Generating " + manifestFile));
        MavenArchiver ma = new MavenArchiver();
        ma.setOutputFile(manifestFile);
        PrintWriter printWriter = null;
        try {
            Manifest mf = ma.getManifest(this.project, archive.getManifest());
            Manifest.Section mainSection = mf.getMainSection();
            this.setAttributes(mainSection);
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(manifestFile), "UTF-8"));
            mf.write(printWriter);
        }
        catch (ManifestException e) {
            try {
                throw new MojoExecutionException("Error preparing the manifest: " + e.getMessage(), (Exception)((Object)e));
                catch (DependencyResolutionRequiredException e2) {
                    throw new MojoExecutionException("Error preparing the manifest: " + e2.getMessage(), (Exception)((Object)e2));
                }
                catch (IOException e3) {
                    throw new MojoExecutionException("Error preparing the manifest: " + e3.getMessage(), (Exception)e3);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(printWriter);
                throw throwable;
            }
        }
        IOUtil.close((Writer)printWriter);
    }

    protected void setAttributes(Manifest.Section mainSection) throws MojoExecutionException, ManifestException, IOException {
        Boolean b;
        String dep;
        String v;
        block20: {
            File pluginImpl = new File(this.project.getBuild().getOutputDirectory(), "META-INF/services/hudson.Plugin");
            if (pluginImpl.exists()) {
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(pluginImpl), "UTF-8"));
                String pluginClassName = in.readLine();
                in.close();
                mainSection.addAttributeAndCheck(new Manifest.Attribute("Plugin-Class", pluginClassName));
            }
            mainSection.addAttributeAndCheck(new Manifest.Attribute("Group-Id", this.project.getGroupId()));
            mainSection.addAttributeAndCheck(new Manifest.Attribute("Short-Name", this.project.getArtifactId()));
            mainSection.addAttributeAndCheck(new Manifest.Attribute("Long-Name", this.pluginName));
            String url = this.project.getUrl();
            if (url != null) {
                mainSection.addAttributeAndCheck(new Manifest.Attribute("Url", url));
            }
            if (this.compatibleSinceVersion != null) {
                mainSection.addAttributeAndCheck(new Manifest.Attribute("Compatible-Since-Version", this.compatibleSinceVersion));
            }
            if (this.minimumJavaVersion == null) {
                throw new MojoExecutionException("minimumJavaVersion attribute must be set starting from version 2.8");
            }
            try {
                int res = Integer.parseInt(this.minimumJavaVersion);
                LOGGER.log(Level.INFO, "Minimum Java version for the plugin: {0}", this.minimumJavaVersion);
            }
            catch (NumberFormatException ex) {
                if (this.minimumJavaVersion.equals("1.6") || this.minimumJavaVersion.equals("1.7") || this.minimumJavaVersion.equals("1.8")) break block20;
                throw new MojoExecutionException("Unsupported Java version string: `" + this.minimumJavaVersion + "`. If you use Java 9 or above, see https://openjdk.java.net/jeps/223");
            }
        }
        mainSection.addAttributeAndCheck(new Manifest.Attribute("Minimum-Java-Version", this.minimumJavaVersion));
        if (this.sandboxStatus != null) {
            mainSection.addAttributeAndCheck(new Manifest.Attribute("Sandbox-Status", this.sandboxStatus));
        }
        if ((v = this.project.getVersion()).endsWith("-SNAPSHOT") && this.snapshotPluginVersionOverride != null) {
            String nonSnapshotVersion = v.substring(0, v.length() - "-SNAPSHOT".length());
            if (!this.snapshotPluginVersionOverride.startsWith(nonSnapshotVersion)) {
                String message = "The snapshotPluginVersionOverride of " + this.snapshotPluginVersionOverride + " does not start with the current target release version " + v;
                if (this.failOnVersionOverrideToDifferentRelease) {
                    throw new MojoExecutionException(message);
                }
                this.getLog().warn((CharSequence)message);
            }
            this.getLog().info((CharSequence)("Snapshot Plugin Version Override enabled. Using " + this.snapshotPluginVersionOverride + " in place of " + v));
            v = this.snapshotPluginVersionOverride;
        }
        if (v.endsWith("-SNAPSHOT") && this.pluginVersionDescription == null) {
            String dt = this.getGitHeadSha1();
            if (dt == null) {
                dt = new SimpleDateFormat("MM/dd/yyyy HH:mm").format(new Date());
            }
            this.pluginVersionDescription = "private-" + dt + "-" + System.getProperty("user.name");
        }
        if (this.pluginVersionDescription != null) {
            v = v + " (" + this.pluginVersionDescription + ")";
        }
        if (!this.project.getPackaging().equals("jenkins-module")) {
            mainSection.addAttributeAndCheck(new Manifest.Attribute("Plugin-Version", v));
        }
        String jv = this.findJenkinsVersion();
        mainSection.addAttributeAndCheck(new Manifest.Attribute("Hudson-Version", jv));
        mainSection.addAttributeAndCheck(new Manifest.Attribute("Jenkins-Version", jv));
        if (this.maskClasses != null) {
            mainSection.addAttributeAndCheck(new Manifest.Attribute("Mask-Classes", this.maskClasses));
        }
        if (this.globalMaskClasses != null) {
            mainSection.addAttributeAndCheck(new Manifest.Attribute("Global-Mask-Classes", this.globalMaskClasses));
        }
        if (this.pluginFirstClassLoader) {
            mainSection.addAttributeAndCheck(new Manifest.Attribute("PluginFirstClassLoader", "true"));
        }
        if ((dep = this.findDependencyPlugins()).length() > 0) {
            mainSection.addAttributeAndCheck(new Manifest.Attribute("Plugin-Dependencies", dep));
        }
        if (this.project.getDevelopers() != null) {
            mainSection.addAttributeAndCheck(new Manifest.Attribute("Plugin-Developers", this.getDevelopersForManifest()));
        }
        if ((b = this.isSupportDynamicLoading()) != null) {
            mainSection.addAttributeAndCheck(new Manifest.Attribute("Support-Dynamic-Loading", b.toString()));
        }
    }

    private String findDependencyPlugins() throws IOException, MojoExecutionException {
        StringBuilder buf = new StringBuilder();
        for (MavenArtifact a : this.getDirectDependencyArtfacts()) {
            if (!a.isPlugin() || !this.scopeFilter.include(a.artifact) || a.hasSameGAAs(this.project)) continue;
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(a.getActualArtifactId());
            buf.append(':');
            buf.append(a.getActualVersion());
            if (!a.isOptional()) continue;
            buf.append(";resolution:=optional");
        }
        for (MavenArtifact a : this.project.getDependencyArtifacts()) {
            if (!"provided".equals(a.getScope()) || !this.wrap((Artifact)a).isPlugin()) continue;
            throw new MojoExecutionException(a.getId() + " is marked as 'provided' scope dependency, but it should be the 'compile' scope.");
        }
        return buf.toString();
    }

    private String getDevelopersForManifest() throws IOException {
        StringBuilder buf = new StringBuilder();
        for (Object o : this.project.getDevelopers()) {
            Developer d = (Developer)o;
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(d.getName() != null ? d.getName() : "");
            buf.append(':');
            buf.append(d.getId() != null ? d.getId() : "");
            buf.append(':');
            buf.append(d.getEmail() != null ? d.getEmail() : "");
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Manifest loadManifest(File f) throws IOException, ManifestException {
        InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8");
        try {
            Manifest manifest = new Manifest((Reader)r);
            return manifest;
        }
        finally {
            IOUtil.close((Reader)r);
        }
    }
}

