/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.terraform;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolProperty;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.terraform.Messages;
import org.jenkinsci.plugins.terraform.TerraformBuildWrapper;
import org.jenkinsci.plugins.terraform.TerraformInstaller;
import org.kohsuke.stapler.DataBoundConstructor;

public class TerraformInstallation
extends ToolInstallation
implements EnvironmentSpecific<TerraformInstallation>,
NodeSpecific<TerraformInstallation>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String UNIX_EXECUTABLE = "terraform";
    private static final String WINDOWS_EXECUTABLE = "terraform.exe";

    @DataBoundConstructor
    public TerraformInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    public TerraformInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new TerraformInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList());
    }

    public TerraformInstallation forEnvironment(EnvVars environment) {
        return new TerraformInstallation(this.getName(), environment.expand(this.getHome()), this.getProperties().toList());
    }

    public void buildEnvVars(EnvVars env) {
        String home = this.getHome();
        if (home == null) {
            return;
        }
        env.put("PATH+TERRAFORM", home);
    }

    public String getExecutablePath(Launcher launcher) throws IOException, InterruptedException {
        return (String)launcher.getChannel().call((Callable)new Callable<String, IOException>(){

            public String call() throws IOException {
                FilePath homeDirectory = new FilePath(new File(TerraformInstallation.this.getHome()));
                try {
                    if (!homeDirectory.exists() || !homeDirectory.isDirectory()) {
                        throw new FileNotFoundException(Messages.HomeDirectoryNotFound(homeDirectory));
                    }
                }
                catch (InterruptedException ex) {
                    throw new IOException(ex);
                }
                FilePath executable = new FilePath(homeDirectory, TerraformInstallation.this.getExecutableFilename());
                try {
                    if (!executable.exists()) {
                        throw new FileNotFoundException(Messages.ExecutableNotFound(homeDirectory));
                    }
                }
                catch (InterruptedException ex) {
                    throw new IOException(ex);
                }
                return executable.getRemote();
            }
        });
    }

    protected String getExecutableFilename() {
        return Functions.isWindows() ? WINDOWS_EXECUTABLE : UNIX_EXECUTABLE;
    }

    @Symbol(value={"terraform"})
    @Extension
    public static class DescriptorImpl
    extends ToolDescriptor<TerraformInstallation> {
        public String getDisplayName() {
            return "Terraform";
        }

        public List<? extends ToolInstaller> getDefaultInstallers() {
            return Collections.singletonList(new TerraformInstaller(null));
        }

        public TerraformInstallation[] getInstallations() {
            return ((TerraformBuildWrapper.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(TerraformBuildWrapper.DescriptorImpl.class)).getInstallations();
        }

        public void setInstallations(TerraformInstallation ... installations) {
            ((TerraformBuildWrapper.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(TerraformBuildWrapper.DescriptorImpl.class)).setInstallations(installations);
        }
    }
}

