/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.terraform;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.ArgumentListBuilder;
import hudson.util.ListBoxModel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jenkinsci.plugins.terraform.Configuration;
import org.jenkinsci.plugins.terraform.Messages;
import org.jenkinsci.plugins.terraform.TerraformInstallation;
import org.jenkinsci.plugins.terraform.VariableInjectionAction;
import org.kohsuke.stapler.DataBoundConstructor;

public class TerraformBuildWrapper
extends BuildWrapper {
    private final String variables;
    private final boolean doDestroy;
    private final boolean doGetUpdate;
    private final boolean doNotApply;
    private final Configuration config;
    private final String terraformInstallation;
    private FilePath stateFile;
    private FilePath configFile;
    private FilePath variablesFile;
    private FilePath workspacePath;
    private FilePath workingDirectory;
    private static final String WORK_DIR_NAME = "terraform-plugin";
    private static final String STATE_FILE_NAME = "terraform-plugin.tfstate";
    private static final Logger LOGGER = Logger.getLogger(TerraformBuildWrapper.class.getName());

    @DataBoundConstructor
    public TerraformBuildWrapper(String variables, String terraformInstallation, boolean doGetUpdate, boolean doNotApply, boolean doDestroy, Configuration config) {
        this.config = config;
        this.doDestroy = doDestroy;
        this.doGetUpdate = doGetUpdate;
        this.doNotApply = doNotApply;
        this.variables = variables;
        this.terraformInstallation = terraformInstallation;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public Configuration.Mode getMode() {
        return this.config.getMode();
    }

    public String getInlineConfig() {
        return this.config.getInlineConfig();
    }

    public String getFileConfig() {
        return this.config.getFileConfig();
    }

    public String getConfigMode() {
        return this.config.getValue();
    }

    public boolean doGetUpdate() {
        return this.doGetUpdate;
    }

    public boolean getDoGetUpdate() {
        return this.doGetUpdate;
    }

    public boolean doNotApply() {
        return this.doNotApply;
    }

    public boolean getdoNotApply() {
        return this.doNotApply;
    }

    public boolean doDestroy() {
        return this.doDestroy;
    }

    public boolean getDoDestroy() {
        return this.doDestroy;
    }

    public String getTerraformInstallation() {
        return this.terraformInstallation;
    }

    public String getVariables() {
        return this.variables;
    }

    public TerraformInstallation getInstallation() {
        for (TerraformInstallation installation : this.getDescriptor().getInstallations()) {
            if (this.terraformInstallation == null || !installation.getName().equals(this.terraformInstallation)) continue;
            return installation;
        }
        return null;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getExecutable(EnvVars env, BuildListener listener, Launcher launcher) throws IOException, InterruptedException {
        String executablePath = null;
        try {
            TerraformInstallation terraform = this.getInstallation().forNode(Computer.currentComputer().getNode(), (TaskListener)listener).forEnvironment(env);
            executablePath = terraform.getExecutablePath(launcher);
        }
        catch (NullPointerException ex) {
            throw new IOException(Messages.InstallationNotFound());
        }
        return executablePath;
    }

    public void executeGet(AbstractBuild build, Launcher launcher, BuildListener listener) throws Exception {
        ArgumentListBuilder args = new ArgumentListBuilder();
        EnvVars env = build.getEnvironment((TaskListener)listener);
        this.setupWorkspace(build, env);
        String executable = this.getExecutable(env, listener, launcher);
        args.add(executable);
        args.add("get");
        if (this.doGetUpdate) {
            args.add("-update");
        }
        LOGGER.info("Launching Terraform Get: " + args.toString());
        int result = launcher.launch().pwd(this.workspacePath.getRemote()).cmds(args).stdout((TaskListener)listener).join();
        if (result != 0) {
            throw new Exception("Terraform Get failed: " + result);
        }
    }

    public void executeApply(AbstractBuild build, Launcher launcher, BuildListener listener) throws Exception {
        ArgumentListBuilder args = new ArgumentListBuilder();
        EnvVars env = build.getEnvironment((TaskListener)listener);
        String executable = this.getExecutable(env, listener, launcher);
        args.add(executable);
        args.add("apply");
        args.add("-input=false");
        args.add("-state=" + this.stateFile.getRemote());
        if (!this.isNullOrEmpty(this.getVariables())) {
            this.variablesFile = this.workingDirectory.createTextTempFile("variables", ".tfvars", this.evalEnvVars(this.getVariables(), env));
            args.add("-var-file=" + this.variablesFile.getRemote());
        }
        LOGGER.info("Launching Terraform Apply: " + args.toString());
        int result = launcher.launch().pwd(this.workspacePath.getRemote()).cmds(args).stdout((TaskListener)listener).join();
        if (result != 0) {
            throw new Exception("Terraform Apply failed: " + result);
        }
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, final Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        try {
            this.executeGet(build, launcher, listener);
            EnvVars env = build.getEnvironment((TaskListener)listener);
            String executable = this.getExecutable(env, listener, launcher);
            this.variablesFile = this.workingDirectory.createTextTempFile("variables", ".tfvars", this.evalEnvVars(this.getVariables(), env));
            VariableInjectionAction tfbinAction = new VariableInjectionAction("TF_BIN", executable);
            VariableInjectionAction tfvarAction = new VariableInjectionAction("TF_VAR", this.variablesFile.getRemote());
            build.addAction((Action)tfbinAction);
            build.addAction((Action)tfvarAction);
            if (!this.doNotApply) {
                this.executeApply(build, launcher, listener);
            }
        }
        catch (Exception ex) {
            LOGGER.severe(this.exceptionToString(ex));
            listener.fatalError(this.exceptionToString(ex));
            this.deleteTemporaryFiles();
            return null;
        }
        return new BuildWrapper.Environment(){

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                if (TerraformBuildWrapper.this.doDestroy()) {
                    ArgumentListBuilder args = new ArgumentListBuilder();
                    try {
                        EnvVars env = build.getEnvironment((TaskListener)listener);
                        args.add(TerraformBuildWrapper.this.getExecutable(env, listener, launcher));
                        args.add("destroy");
                        args.add("-input=false");
                        args.add("-state=" + TerraformBuildWrapper.this.stateFile.getRemote());
                        args.add("--force");
                        if (!TerraformBuildWrapper.this.isNullOrEmpty(TerraformBuildWrapper.this.getVariables())) {
                            args.add("-var-file=" + TerraformBuildWrapper.this.variablesFile.getRemote());
                        }
                        LOGGER.info("Launching Terraform: " + args.toString());
                        int result = launcher.launch().pwd(TerraformBuildWrapper.this.workspacePath.getRemote()).cmds(args).stdout((TaskListener)listener).join();
                        if (result != 0) {
                            TerraformBuildWrapper.this.deleteTemporaryFiles();
                            return false;
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.severe(TerraformBuildWrapper.this.exceptionToString(ex));
                        listener.fatalError(TerraformBuildWrapper.this.exceptionToString(ex));
                        TerraformBuildWrapper.this.deleteTemporaryFiles();
                        return false;
                    }
                }
                TerraformBuildWrapper.this.deleteTemporaryFiles();
                return true;
            }
        };
    }

    private String evalEnvVars(String input, EnvVars env) throws Exception {
        String envPattern = "\\$([A-Z-a-z_0-9]+)";
        Pattern expr = Pattern.compile(envPattern);
        Matcher matcher = expr.matcher(input);
        String output = input;
        while (matcher.find()) {
            String envFound = (String)env.get((Object)matcher.group(1));
            if (envFound == null) continue;
            output = output.replace("$" + matcher.group(1), envFound);
        }
        return output;
    }

    private void setupWorkspace(AbstractBuild build, EnvVars env) throws FileNotFoundException, Exception {
        this.workingDirectory = new FilePath(build.getWorkspace(), WORK_DIR_NAME);
        this.stateFile = new FilePath(this.workingDirectory, STATE_FILE_NAME);
        switch (this.getMode()) {
            case INLINE: {
                this.configFile = this.workingDirectory.createTextTempFile("terraform", ".tf", this.evalEnvVars(this.getInlineConfig(), env));
                this.workspacePath = this.workingDirectory;
                if (this.configFile != null && this.configFile.exists()) break;
                throw new FileNotFoundException(Messages.ConfigurationNotCreated());
            }
            case FILE: {
                if (!this.isNullOrEmpty(this.getFileConfig())) {
                    this.workspacePath = new FilePath(build.getWorkspace(), this.getFileConfig());
                    if (this.workspacePath.isDirectory()) break;
                    throw new FileNotFoundException(Messages.ConfigurationPathNotFound(this.workspacePath));
                }
                this.workspacePath = build.getWorkspace();
                break;
            }
            default: {
                throw new Exception(Messages.InvalidConfigMode());
            }
        }
    }

    private void deleteTemporaryFiles() throws IOException, InterruptedException {
        if (this.variablesFile != null && this.variablesFile.exists()) {
            this.variablesFile.delete();
        }
        if (this.configFile != null && this.configFile.exists()) {
            this.configFile.delete();
        }
    }

    private boolean isNullOrEmpty(String value) {
        return value == null || value.trim().isEmpty();
    }

    private String exceptionToString(Exception ex) {
        StringWriter writer = new StringWriter();
        ex.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        private volatile TerraformInstallation[] installations = new TerraformInstallation[0];

        public DescriptorImpl() {
            super(TerraformBuildWrapper.class);
            this.load();
        }

        public TerraformInstallation[] getInstallations() {
            return this.installations;
        }

        public void setInstallations(TerraformInstallation[] installations) {
            this.installations = installations;
            this.save();
        }

        public ListBoxModel doFillTerraformInstallationItems() {
            ListBoxModel m = new ListBoxModel();
            for (TerraformInstallation inst : this.installations) {
                m.add(inst.getName());
            }
            return m;
        }

        public boolean isInlineConfigChecked(TerraformBuildWrapper instance) {
            boolean result = true;
            if (instance != null) {
                return instance.getInlineConfig() != null;
            }
            return result;
        }

        public boolean isFileConfigChecked(TerraformBuildWrapper instance) {
            boolean result = false;
            if (instance != null) {
                return instance.getFileConfig() != null;
            }
            return result;
        }

        public boolean isApplicable(AbstractProject<?, ?> project) {
            return true;
        }

        public String getDisplayName() {
            return Messages.BuildWrapperName();
        }
    }
}

