/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.groovy;

import com.google.common.primitives.Primitives;
import groovy.lang.GString;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GroovyCallSiteSelector {
    private static boolean matches(@Nonnull Class<?>[] parameterTypes, @Nonnull Object[] parameters) {
        if (parameters.length != parameterTypes.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameters[i] == null) {
                if (!parameterTypes[i].isPrimitive()) continue;
                return false;
            }
            if (parameterTypes[i].isInstance(parameters[i]) || parameterTypes[i].isPrimitive() && parameters[i] != null && ClassUtils.primitiveToWrapper(parameterTypes[i]).isInstance(parameters[i]) || parameterTypes[i] == String.class && parameters[i] instanceof GString) continue;
            return false;
        }
        return true;
    }

    @CheckForNull
    public static Method method(@Nonnull Object receiver, @Nonnull String method, @Nonnull Object[] args) {
        Method candidate;
        for (Class<?> c : GroovyCallSiteSelector.types(receiver)) {
            Method candidate2 = GroovyCallSiteSelector.findMatchingMethod(c, method, args);
            if (candidate2 == null) continue;
            return candidate2;
        }
        if (receiver instanceof GString && (candidate = GroovyCallSiteSelector.findMatchingMethod(String.class, method, args)) != null) {
            return candidate;
        }
        return null;
    }

    @CheckForNull
    public static Constructor<?> constructor(@Nonnull Class<?> receiver, @Nonnull Object[] args) {
        for (Constructor<?> c : receiver.getDeclaredConstructors()) {
            if (!GroovyCallSiteSelector.matches(c.getParameterTypes(), args)) continue;
            return c;
        }
        return null;
    }

    @CheckForNull
    public static Method staticMethod(@Nonnull Class<?> receiver, @Nonnull String method, @Nonnull Object[] args) {
        return GroovyCallSiteSelector.findMatchingMethod(receiver, method, args);
    }

    private static Method findMatchingMethod(Class<?> receiver, String method, Object[] args) {
        Method candidate = null;
        for (Method m : receiver.getDeclaredMethods()) {
            if (!m.getName().equals(method) || !GroovyCallSiteSelector.matches(m.getParameterTypes(), args) || candidate != null && !GroovyCallSiteSelector.isMoreSpecific(m, candidate)) continue;
            candidate = m;
        }
        return candidate;
    }

    @CheckForNull
    public static Field field(@Nonnull Object receiver, @Nonnull String field) {
        for (Class<?> c : GroovyCallSiteSelector.types(receiver)) {
            for (Field f : c.getDeclaredFields()) {
                if (!f.getName().equals(field)) continue;
                return f;
            }
        }
        return null;
    }

    @CheckForNull
    public static Field staticField(@Nonnull Class<?> receiver, @Nonnull String field) {
        for (Field f : receiver.getDeclaredFields()) {
            if (!f.getName().equals(field)) continue;
            return f;
        }
        return null;
    }

    private static Iterable<Class<?>> types(@Nonnull Object o) {
        LinkedHashSet types = new LinkedHashSet();
        GroovyCallSiteSelector.visitTypes(types, o.getClass());
        return types;
    }

    private static void visitTypes(@Nonnull Set<Class<?>> types, @Nonnull Class<?> c) {
        Class<?> s = c.getSuperclass();
        if (s != null) {
            GroovyCallSiteSelector.visitTypes(types, s);
        }
        for (Class<?> i : c.getInterfaces()) {
            GroovyCallSiteSelector.visitTypes(types, i);
        }
        types.add(c);
    }

    private static boolean isMoreSpecific(Method more, Method less) {
        Class<?>[] moreParams = more.getParameterTypes();
        Class<?>[] lessParams = less.getParameterTypes();
        assert (moreParams.length == lessParams.length);
        for (int i = 0; i < moreParams.length; ++i) {
            Class lessParam;
            Class moreParam = Primitives.wrap(moreParams[i]);
            if (moreParam.isAssignableFrom(lessParam = Primitives.wrap(lessParams[i]))) {
                return false;
            }
            if (!lessParam.isAssignableFrom(moreParam)) continue;
            return true;
        }
        return more.toString().compareTo(less.toString()) > 0;
    }

    private GroovyCallSiteSelector() {
    }
}

