/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.security.ACL;
import hudson.security.AuthorizationMatrixProperty;
import hudson.security.AuthorizationStrategy;
import hudson.security.GlobalMatrixAuthorizationStrategy;
import hudson.security.SidACL;
import hudson.util.RobustReflectionConverter;
import java.util.HashSet;
import java.util.Set;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.matrixauth.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectMatrixAuthorizationStrategy
extends GlobalMatrixAuthorizationStrategy {
    @Extension
    public static final Descriptor<AuthorizationStrategy> DESCRIPTOR = new GlobalMatrixAuthorizationStrategy.DescriptorImpl(){

        protected GlobalMatrixAuthorizationStrategy create() {
            return new ProjectMatrixAuthorizationStrategy();
        }

        public String getDisplayName() {
            return Messages.ProjectMatrixAuthorizationStrategy_DisplayName();
        }
    };

    public ACL getACL(Job<?, ?> project) {
        AuthorizationMatrixProperty amp = (AuthorizationMatrixProperty)project.getProperty(AuthorizationMatrixProperty.class);
        if (amp != null) {
            return amp.getACL().newInheritingACL(this.getACL(project.getParent()));
        }
        return this.getACL(project.getParent());
    }

    public SidACL getACL(ItemGroup g) {
        if (g instanceof Item) {
            Item item = (Item)g;
            return (SidACL)item.getACL();
        }
        return this.getRootACL();
    }

    public SidACL getACL(AbstractItem item) {
        return this.getACL(item.getParent());
    }

    @Override
    public Set<String> getGroups() {
        HashSet<String> r = new HashSet<String>();
        r.addAll(super.getGroups());
        for (Job j : Jenkins.getInstance().getItems(Job.class)) {
            AuthorizationMatrixProperty amp = (AuthorizationMatrixProperty)j.getProperty(AuthorizationMatrixProperty.class);
            if (amp == null) continue;
            r.addAll(amp.getGroups());
        }
        return r;
    }

    public static class ConverterImpl
    extends GlobalMatrixAuthorizationStrategy.ConverterImpl {
        private RobustReflectionConverter ref;

        public ConverterImpl(Mapper m) {
            this.ref = new RobustReflectionConverter(m, new JVM().bestReflectionProvider());
        }

        protected GlobalMatrixAuthorizationStrategy create() {
            return new ProjectMatrixAuthorizationStrategy();
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            String name = reader.peekNextChild();
            if (name != null && (name.equals("permission") || name.equals("useProjectSecurity"))) {
                return super.unmarshal(reader, context);
            }
            return this.ref.unmarshal(reader, context);
        }

        public boolean canConvert(Class type) {
            return type == ProjectMatrixAuthorizationStrategy.class;
        }
    }
}

