/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import hudson.EnvVars;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Random;
import jenkins.plugins.git.GitHooksConfiguration;
import org.eclipse.jgit.lib.StoredConfig;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class GitHooksConfigurationTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();
    private GitHooksConfiguration configuration;
    private GitClient client;
    private final Random random = new Random();
    private static final String NULL_HOOKS_PATH = GitHooksConfigurationTest.isWindows() ? "NUL:" : "/dev/null";
    private final String ALTERNATE_HOOKS_PATH = "not-a-valid-hooks-path";

    @Before
    public void setUp() throws IOException, InterruptedException {
        this.configuration = GitHooksConfiguration.get();
        Git git = Git.with((TaskListener)TaskListener.NULL, (EnvVars)new EnvVars());
        this.client = git.getClient();
    }

    @After
    public void resetHooksPath() throws IOException, InterruptedException {
        this.client.withRepository((RepositoryCallback & Serializable)(repo, channel) -> {
            StoredConfig repoConfig = repo.getConfig();
            repoConfig.unset("core", null, "hooksPath");
            repoConfig.save();
            return null;
        });
    }

    @Test
    public void testGet() {
        MatcherAssert.assertThat((Object)GitHooksConfiguration.get(), (Matcher)Matchers.is((Object)this.configuration));
    }

    @Test
    public void testIsAllowedOnController() {
        Assert.assertFalse((boolean)this.configuration.isAllowedOnController());
    }

    @Test
    public void testSetAllowedOnController() {
        this.configuration.setAllowedOnController(true);
        Assert.assertTrue((boolean)this.configuration.isAllowedOnController());
    }

    @Test
    public void testSetAllowedOnControllerFalse() {
        this.configuration.setAllowedOnController(false);
        Assert.assertFalse((boolean)this.configuration.isAllowedOnController());
    }

    @Test
    public void testIsAllowedOnAgents() {
        Assert.assertFalse((boolean)this.configuration.isAllowedOnAgents());
    }

    @Test
    public void testSetAllowedOnAgents() {
        this.configuration.setAllowedOnAgents(true);
        Assert.assertTrue((boolean)this.configuration.isAllowedOnAgents());
    }

    @Test
    public void testSetAllowedOnAgentsFalse() {
        this.configuration.setAllowedOnAgents(false);
        Assert.assertFalse((boolean)this.configuration.isAllowedOnAgents());
    }

    @Test
    public void testGetCategory() {
        MatcherAssert.assertThat((Object)GitHooksConfiguration.get().getCategory(), (Matcher)Matchers.is((Object)this.configuration.getCategory()));
    }

    private void setCoreHooksPath(String hooksPath) throws IOException, InterruptedException {
        this.client.withRepository((RepositoryCallback & Serializable)(repo, channel) -> {
            StoredConfig repoConfig = repo.getConfig();
            repoConfig.setString("core", null, "hooksPath", hooksPath);
            repoConfig.save();
            return null;
        });
    }

    private String getCoreHooksPath() throws IOException, InterruptedException {
        String hooksPath = (String)this.client.withRepository((RepositoryCallback & Serializable)(repo, channel) -> {
            StoredConfig repoConfig = repo.getConfig();
            return repoConfig.getString("core", null, "hooksPath");
        });
        return hooksPath;
    }

    @Test
    public void testConfigure_GitClient() throws Exception {
        GitHooksConfiguration.configure((GitClient)this.client);
        String hooksPath = this.getCoreHooksPath();
        MatcherAssert.assertThat((Object)hooksPath, (Matcher)Matchers.is((Object)NULL_HOOKS_PATH));
    }

    @Test
    public void testConfigure_GitClient_boolean() throws Exception {
        boolean allowed = true;
        GitHooksConfiguration.configure((GitClient)this.client, (boolean)allowed);
        String hooksPath = this.getCoreHooksPath();
        MatcherAssert.assertThat((Object)hooksPath, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testConfigure_GitClient_booleanFalse() throws Exception {
        boolean allowed = false;
        GitHooksConfiguration.configure((GitClient)this.client, (boolean)allowed);
        String hooksPath = this.getCoreHooksPath();
        MatcherAssert.assertThat((Object)hooksPath, (Matcher)Matchers.is((Object)NULL_HOOKS_PATH));
    }

    private void configure_3args(boolean allowedOnController) throws Exception {
        this.setCoreHooksPath("not-a-valid-hooks-path");
        String hooksPathBefore = this.getCoreHooksPath();
        MatcherAssert.assertThat((Object)hooksPathBefore, (Matcher)Matchers.is((Object)"not-a-valid-hooks-path"));
        GitHooksConfiguration.configure((GitClient)this.client, (boolean)allowedOnController, (boolean)this.random.nextBoolean());
    }

    @Test
    public void testConfigure_3args() throws Exception {
        boolean allowedOnController = true;
        this.configure_3args(allowedOnController);
        String hooksPath = this.getCoreHooksPath();
        MatcherAssert.assertThat((Object)hooksPath, (Matcher)Matchers.is((Object)"not-a-valid-hooks-path"));
    }

    @Test
    public void testConfigure_3argsFalse() throws Exception {
        boolean allowedOnController = false;
        this.configure_3args(allowedOnController);
        String hooksPath = this.getCoreHooksPath();
        MatcherAssert.assertThat((Object)hooksPath, (Matcher)Matchers.is((Object)NULL_HOOKS_PATH));
    }

    private static boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }
}

