/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import hudson.logging.LogRecorder;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.util.StreamTaskListener;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitSCMSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.RealJenkinsRule;

public class FIPSModeSCMSourceTest {
    @Rule
    public RealJenkinsRule rule = new RealJenkinsRule().omitPlugins(new String[]{"eddsa-api", "trilead-api", "git-tag-message"}).javaOptions(new String[]{"-Djenkins.security.FIPS140.COMPLIANCE=true"}).withLogger(AbstractGitSCMSource.class, Level.SEVERE);

    @Test
    public void remotesAreNotFetchedTest() throws Throwable {
        this.rule.then(new RealJenkinsRule.Step[]{(RealJenkinsRule.Step & Serializable)r -> {
            GitSCMSource source = new GitSCMSource("http://insecure-repo");
            StreamTaskListener listener = StreamTaskListener.fromStderr();
            Assert.assertThrows((String)"expected exception as repo doesn't exist", GitException.class, () -> FIPSModeSCMSourceTest.lambda$remotesAreNotFetchedTest$0(source, (TaskListener)listener));
            LogRecorder logRecorder = new LogRecorder(AbstractGitSCMSource.class.getName());
            LogRecorder.Target target = new LogRecorder.Target(AbstractGitSCMSource.class.getName(), Level.SEVERE);
            logRecorder.setLoggers(List.of(target));
            r.jenkins.getLog().getRecorders().add(logRecorder);
            MatcherAssert.assertThat((String)"We should no see the error in the logs", (Object)logRecorder.getLogRecords().size(), (Matcher)CoreMatchers.is((Object)0));
            Throwable exception = Assert.assertThrows((String)"We're not saving creds", IllegalArgumentException.class, () -> source.setCredentialsId("cred-id"));
            MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)"FIPS requires a secure channel"));
            MatcherAssert.assertThat((String)"credentials are not saved", (Object)source.getCredentialsId(), (Matcher)CoreMatchers.nullValue());
            GitSCMSource anotherSource = new GitSCMSource("fake", "http://insecure", "credentialsId", "", "", true);
            exception = Assert.assertThrows((String)"fetch was interrupted so no credential was leaked", IllegalArgumentException.class, () -> FIPSModeSCMSourceTest.lambda$remotesAreNotFetchedTest$2(anotherSource, (TaskListener)listener));
            MatcherAssert.assertThat((String)"We should have a severe log indicating the error", (Object)logRecorder.getLogRecords().size(), (Matcher)CoreMatchers.is((Object)1));
            MatcherAssert.assertThat((String)"Exception indicates problem", (Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)"FIPS requires a secure channel"));
        }});
    }

    private static /* synthetic */ void lambda$remotesAreNotFetchedTest$2(GitSCMSource anotherSource, TaskListener listener) throws Throwable {
        anotherSource.fetch(listener);
    }

    private static /* synthetic */ void lambda$remotesAreNotFetchedTest$0(GitSCMSource source, TaskListener listener) throws Throwable {
        source.fetch(listener);
    }
}

