/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.plugins.git.UserRemoteConfig;
import hudson.util.FormValidation;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class UserRemoteConfigRefSpecTest {
    @Test
    public void testdoCheckRefspecSuccessWithoutWildcards() {
        String url = "git://git.example.com/repository-that-does-not-exist";
        String name = "origin";
        ArrayList<String> refSpec = new ArrayList<String>();
        refSpec.add("+refs/heads/master:refs/remotes/origin/master");
        refSpec.add("+refs/heads/JENKINS-57660:refs/remotes/origin/JENKINS-57660");
        refSpec.add("master:refs/remotes/origin/mymaster");
        refSpec.add("master:refs/remotes/origin/mymaster topic:refs/remotes/origin/topic");
        UserRemoteConfig.DescriptorImpl descriptor = new UserRemoteConfig.DescriptorImpl();
        for (String ref : refSpec) {
            Assert.assertEquals((Object)FormValidation.ok(), (Object)descriptor.doCheckRefspec(url, name, ref));
        }
    }

    @Test
    public void testdoCheckRefspecSuccessWithMatchedWildCards() {
        String url = "git://git.example.com/repository-that-does-not-exist";
        String name = "origin";
        ArrayList<String> refSpec = new ArrayList<String>();
        refSpec.add("+refs/heads/qa/*:refs/remotes/origin/qa/*");
        refSpec.add("+refs/pull/*/head:refs/remotes/origin/pr/*");
        UserRemoteConfig.DescriptorImpl descriptor = new UserRemoteConfig.DescriptorImpl();
        for (String ref : refSpec) {
            Assert.assertEquals((Object)FormValidation.ok(), (Object)descriptor.doCheckRefspec(url, name, ref));
        }
    }

    @Test
    public void testdoCheckRefspecFailureWithUnMatchedWildCards() {
        String url = "git://git.example.com/repository-that-does-not-exist";
        String name = "origin";
        ArrayList<String> refSpec = new ArrayList<String>();
        refSpec.add("+refs/heads/qa:refs/remotes/origin/qa/*");
        refSpec.add("+refs/heads/qa/*:refs/remotes/origin/qa");
        UserRemoteConfig.DescriptorImpl descriptor = new UserRemoteConfig.DescriptorImpl();
        for (String ref : refSpec) {
            Assert.assertEquals((Object)"Specification is invalid.", (Object)descriptor.doCheckRefspec(url, name, ref).getLocalizedMessage());
        }
    }

    @Test
    public void testdoCheckRefspecSuccessWithEmptyString() {
        String url = "git://git.example.com/repository-that-does-not-exist";
        String name = "origin";
        ArrayList<String> refSpec = new ArrayList<String>();
        refSpec.add("");
        UserRemoteConfig.DescriptorImpl descriptor = new UserRemoteConfig.DescriptorImpl();
        for (String ref : refSpec) {
            Assert.assertEquals((Object)FormValidation.ok(), (Object)descriptor.doCheckRefspec(url, name, ref));
        }
    }

    @Test
    public void testdoCheckRefspecSuccessWithPartialGlobs() {
        String url = "git://git.example.com/repository-that-does-not-exist";
        String name = "origin";
        ArrayList<String> refSpec = new ArrayList<String>();
        refSpec.add("+refs/heads/qa*:refs/remotes/origin/qa*");
        UserRemoteConfig.DescriptorImpl descriptor = new UserRemoteConfig.DescriptorImpl();
        for (String ref : refSpec) {
            Assert.assertEquals((Object)FormValidation.ok(), (Object)descriptor.doCheckRefspec(url, name, ref));
        }
    }

    @Test
    public void testdoCheckRefspecSuccessWithEnvironmentVariable() {
        String url = "git://git.example.com/repository-that-does-not-exist";
        String name = "origin";
        ArrayList<String> refSpec = new ArrayList<String>();
        refSpec.add("$REFSPEC");
        UserRemoteConfig.DescriptorImpl descriptor = new UserRemoteConfig.DescriptorImpl();
        for (String ref : refSpec) {
            Assert.assertEquals((Object)FormValidation.ok(), (Object)descriptor.doCheckRefspec(url, name, ref));
        }
    }
}

