/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitChangeSetUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GitChangeSetEuroTest {
    private final String id = "1567861636cd854f4dd6fa40bf94c0c657681dd5";
    private final String parent = "e74a24e995305bd67a180f0ebc57927e2b8783ce";
    private final String authorName = "Mr. \u00c5h\u0142a\u00f1der";
    private final String committerName = "Mister \u00c5hl\u00e4nd\u00e8r";
    private final String msg = "[task] Updated version.";
    private final String comment1 = "Including earlier updates.";
    private final String commentStartText = "[task] Updated version.\n\nIncluding earlier updates.\n";
    private GitChangeSet changeSet = null;
    private final boolean useAuthorName;

    public GitChangeSetEuroTest(String useAuthorName) {
        this.useAuthorName = Boolean.valueOf(useAuthorName);
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection permuteAuthorNameAndLegacyLayout() {
        String[] allowed;
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (String authorName : allowed = new String[]{"true", "false"}) {
            Object[] combination = new Object[]{authorName};
            values.add(combination);
        }
        return values;
    }

    @Before
    public void createEuroChangeSet() {
        ArrayList<String> gitChangeLog = new ArrayList<String>();
        gitChangeLog.add("commit 1567861636cd854f4dd6fa40bf94c0c657681dd5");
        gitChangeLog.add("tree 66236cf9a1ac0c589172b450ed01f019a5697c49");
        gitChangeLog.add("parent e74a24e995305bd67a180f0ebc57927e2b8783ce");
        gitChangeLog.add("author Mr. \u00c5h\u0142a\u00f1der <mister.ahlander@ericsson.com> 1363879004 +0100");
        gitChangeLog.add("committer Mister \u00c5hl\u00e4nd\u00e8r <mister.ahlander@ericsson.com> 1364199539 -0400");
        gitChangeLog.add("");
        gitChangeLog.add("    [task] Updated version.");
        gitChangeLog.add("    ");
        gitChangeLog.add("    Including earlier updates.");
        gitChangeLog.add("    ");
        gitChangeLog.add("    Changes in this version:");
        gitChangeLog.add("    - Changed to take the gerrit url from gerrit query command.");
        gitChangeLog.add("    - Aligned reason information with our new commit hooks");
        gitChangeLog.add("    ");
        gitChangeLog.add("    Change-Id: Ife96d2abed5b066d9620034bec5f04cf74b8c66d");
        gitChangeLog.add("    Reviewed-on: https://gerrit.e.se/12345");
        gitChangeLog.add("    Tested-by: Jenkins <jenkins@no-mail.com>");
        gitChangeLog.add("    Reviewed-by: Mister Another <mister.another@ericsson.com>");
        gitChangeLog.add("");
        this.changeSet = new GitChangeSet(gitChangeLog, this.useAuthorName, false);
    }

    @Test
    public void testGetCommitId() {
        Assert.assertEquals((Object)"1567861636cd854f4dd6fa40bf94c0c657681dd5", (Object)this.changeSet.getCommitId());
    }

    @Test
    public void testSetParent() {
        this.changeSet.setParent(null);
        Assert.assertNull((Object)this.changeSet.getParent());
    }

    @Test
    public void testGetParentCommit() {
        Assert.assertEquals((Object)"e74a24e995305bd67a180f0ebc57927e2b8783ce", (Object)this.changeSet.getParentCommit());
    }

    @Test
    public void testGetAffectedPaths() {
        Assert.assertTrue((boolean)this.changeSet.getAffectedPaths().isEmpty());
    }

    @Test
    public void testGetPaths() {
        Assert.assertTrue((boolean)this.changeSet.getPaths().isEmpty());
    }

    @Test
    public void testGetAffectedFiles() {
        Assert.assertTrue((boolean)this.changeSet.getAffectedFiles().isEmpty());
    }

    @Test
    public void testGetAuthorName() {
        Assert.assertEquals((Object)(this.useAuthorName ? "Mr. \u00c5h\u0142a\u00f1der" : "Mister \u00c5hl\u00e4nd\u00e8r"), (Object)this.changeSet.getAuthorName());
    }

    @Test
    public void testGetMsg() {
        Assert.assertEquals((Object)"[task] Updated version.", (Object)this.changeSet.getMsg());
    }

    @Test
    public void testGetId() {
        Assert.assertEquals((Object)"1567861636cd854f4dd6fa40bf94c0c657681dd5", (Object)this.changeSet.getId());
    }

    @Test
    public void testGetRevision() {
        Assert.assertEquals((Object)"1567861636cd854f4dd6fa40bf94c0c657681dd5", (Object)this.changeSet.getRevision());
    }

    @Test
    public void testGetComment() {
        Assert.assertTrue((boolean)this.changeSet.getComment().startsWith("[task] Updated version.\n\nIncluding earlier updates.\n"));
    }

    @Test
    public void testGetBranch() {
        Assert.assertNull((Object)this.changeSet.getBranch());
    }

    @Test
    public void testGetDate() {
        Assert.assertEquals((Object)(this.useAuthorName ? "2013-03-21T15:16:44+0100" : "2013-03-25T08:18:59-0400"), (Object)this.changeSet.getDate());
    }

    @Test
    public void testGetTimestamp() {
        Assert.assertEquals((long)(this.useAuthorName ? 1363875404000L : 1364213939000L), (long)this.changeSet.getTimestamp());
    }

    @Test
    public void testHashCode() {
        Assert.assertTrue((this.changeSet.hashCode() != 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEquals() {
        Assert.assertEquals((Object)this.changeSet, (Object)this.changeSet);
        Assert.assertEquals((Object)GitChangeSetUtil.genChangeSet(false, false), (Object)GitChangeSetUtil.genChangeSet(false, false));
        Assert.assertEquals((Object)GitChangeSetUtil.genChangeSet(true, false), (Object)GitChangeSetUtil.genChangeSet(true, false));
        Assert.assertEquals((Object)GitChangeSetUtil.genChangeSet(false, true), (Object)GitChangeSetUtil.genChangeSet(false, true));
        Assert.assertEquals((Object)GitChangeSetUtil.genChangeSet(true, true), (Object)GitChangeSetUtil.genChangeSet(true, true));
        Assert.assertNotEquals((Object)this.changeSet, (Object)GitChangeSetUtil.genChangeSet(false, false));
        Assert.assertNotEquals((Object)GitChangeSetUtil.genChangeSet(true, false), (Object)this.changeSet);
        Assert.assertNotEquals((Object)this.changeSet, (Object)GitChangeSetUtil.genChangeSet(false, true));
        Assert.assertNotEquals((Object)GitChangeSetUtil.genChangeSet(true, true), (Object)this.changeSet);
    }
}

