/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

public class WorkspaceCopyFileBuilder
extends Builder {
    private final String fileName;
    private final String jobName;
    private final int buildNumber;

    public WorkspaceCopyFileBuilder(String fileName, String jobName, int buildNumber) {
        this.fileName = fileName;
        this.jobName = jobName;
        this.buildNumber = buildNumber;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        listener.getLogger().println("Copying a " + this.fileName + " from " + this.jobName + "#" + this.buildNumber);
        Jenkins inst = Jenkins.get();
        AbstractProject item = (AbstractProject)inst.getItemByFullName(this.jobName, AbstractProject.class);
        if (item == null) {
            throw new AbortException("Cannot find a source job: " + this.jobName);
        }
        AbstractBuild sourceBuild = item.getBuildByNumber(this.buildNumber);
        if (sourceBuild == null) {
            throw new AbortException("Cannot find a source build: " + this.jobName + "#" + this.buildNumber);
        }
        FilePath sourceWorkspace = sourceBuild.getWorkspace();
        if (sourceWorkspace == null) {
            throw new AbortException("Cannot get the source workspace from " + sourceBuild.getDisplayName());
        }
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            throw new IOException("Cannot get the workspace of the build");
        }
        workspace.child(this.fileName).copyFrom(sourceWorkspace.child(this.fileName));
        return true;
    }

    public Descriptor<Builder> getDescriptor() {
        return new DescriptorImpl();
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<Builder> {
        public Builder newInstance(StaplerRequest req, @NonNull JSONObject data) {
            throw new UnsupportedOperationException();
        }

        @NonNull
        public String getDisplayName() {
            return "Copy a file from the workspace of another build";
        }
    }
}

