/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.FilePath;
import hudson.remoting.Which;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;

public final class WarExploder {
    private static final Logger LOGGER = Logger.getLogger(WarExploder.class.getName());
    public static final String JENKINS_WAR_PATH_PROPERTY_NAME = "jth.jenkins-war.path";
    @CheckForNull
    private static final String JENKINS_WAR_PATH = System.getProperty("jth.jenkins-war.path");
    private static final Pattern HEX_DIGITS = Pattern.compile("^[a-f0-9]+$");
    private static File EXPLODE_DIR;

    public static synchronized File getExplodedDir() throws Exception {
        if (EXPLODE_DIR == null) {
            EXPLODE_DIR = WarExploder.explode();
        }
        return EXPLODE_DIR;
    }

    static File findJenkinsWar() throws Exception {
        File war;
        if (JENKINS_WAR_PATH != null) {
            war = new File(JENKINS_WAR_PATH).getAbsoluteFile();
            LOGGER.log(Level.INFO, "Using WAR file path {0} specified by the {1} system property", new Object[]{war, JENKINS_WAR_PATH_PROPERTY_NAME});
            if (!war.exists()) {
                throw new IOException("The WAR file path " + war + " specified by the jth.jenkins-war.path system property does not exist");
            }
            if (!war.isFile()) {
                throw new IOException("The WAR file path " + war + " specified by the jth.jenkins-war.path system property is not a file");
            }
        } else {
            URL winstone = WarExploder.class.getResource("/executable/winstone.jar");
            if (winstone != null) {
                war = Which.jarFile(Class.forName("executable.Main"));
            } else {
                File coreArtifactDir;
                String version;
                File core = Which.jarFile(Jenkins.class);
                if (HEX_DIGITS.matcher(core.getParentFile().getName()).matches()) {
                    version = core.getParentFile().getParentFile().getName();
                    coreArtifactDir = core.getParentFile().getParentFile().getParentFile();
                } else {
                    version = core.getParentFile().getName();
                    coreArtifactDir = core.getParentFile().getParentFile();
                }
                if (core.getName().equals("jenkins-core-" + version + ".jar") && coreArtifactDir.getName().equals("jenkins-core")) {
                    File warArtifactDir = new File(coreArtifactDir.getParentFile(), "jenkins-war");
                    war = new File(new File(warArtifactDir, version), "jenkins-war-" + version + ".war");
                    if (!war.isFile()) {
                        File[] hashes = new File(warArtifactDir, version).listFiles();
                        if (hashes != null) {
                            File hash;
                            File[] fileArray = hashes;
                            int n = fileArray.length;
                            for (int i = 0; !(i >= n || HEX_DIGITS.matcher((hash = fileArray[i]).getName()).matches() && (war = new File(hash, "jenkins-war-" + version + ".war")).isFile()); ++i) {
                            }
                        }
                        if (!war.isFile()) {
                            throw new AssertionError((Object)(war + " does not yet exist. Prime your development environment by running `mvn validate`."));
                        }
                    }
                    LOGGER.log(Level.FINE, "{0} is the continuation of the classpath by other means", war);
                } else {
                    throw new AssertionError((Object)(core + " is not in the expected location, and jenkins-war-*.war was not in " + System.getProperty("java.class.path")));
                }
            }
        }
        return war;
    }

    private static File explode() throws Exception {
        for (File d = new File(".").getAbsoluteFile(); d != null; d = d.getParentFile()) {
            File dir;
            if (!new File(d, ".jenkins").exists() || !(dir = new File(d, "war/target/jenkins")).exists()) continue;
            LOGGER.log(Level.INFO, "Using jenkins.war resources from {0}", dir);
            return dir;
        }
        File war = WarExploder.findJenkinsWar();
        File buildDirectory = new File(System.getProperty("buildDirectory", "target"));
        File explodeDir = new File(buildDirectory, "jenkins-for-test").getAbsoluteFile();
        explodeDir.getParentFile().mkdirs();
        Path lock = new File(explodeDir + ".lock").toPath();
        try (FileChannel lockChannel = FileChannel.open(lock, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
             FileLock fl = WarExploder.getLockForChannel(lockChannel);){
            File timestamp = new File(explodeDir, ".timestamp");
            if (!timestamp.exists() || timestamp.lastModified() != war.lastModified()) {
                LOGGER.log(Level.INFO, "Exploding {0} into {1}", new Object[]{war, explodeDir});
                new FilePath(explodeDir).deleteRecursive();
                new FilePath(war).unzip(new FilePath(explodeDir));
                timestamp.createNewFile();
                timestamp.setLastModified(war.lastModified());
            } else {
                LOGGER.log(Level.INFO, "Picking up existing exploded jenkins.war at {0}", explodeDir.getAbsolutePath());
            }
        }
        return explodeDir;
    }

    private static FileLock getLockForChannel(FileChannel channel) throws IOException, InterruptedException {
        int iteration = 0;
        while (true) {
            try {
                FileLock lock = channel.tryLock();
                if (lock != null) {
                    return lock;
                }
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                // empty catch block
            }
            if (++iteration % 50 == 0) {
                LOGGER.log(Level.INFO, "Waiting for a different JVM or thread to finish unpacking the war");
            }
            Thread.sleep(100L);
        }
    }

    private WarExploder() {
    }
}

