/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.console.PlainTextConsoleOutputStream;
import hudson.model.Run;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Semaphore;
import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.TailerListener;
import org.apache.commons.io.input.TailerListenerAdapter;
import org.jvnet.hudson.test.DeltaSupportLogFormatter;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.PrefixedOutputStream;
import org.jvnet.hudson.test.RealJenkinsRule;

@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="irrelevant")
public final class TailLog
implements AutoCloseable {
    private final Semaphore finished = new Semaphore(0);
    private final Tailer tailer;
    private final PrefixedOutputStream.Builder prefixedOutputStreamBuilder = PrefixedOutputStream.builder();

    public TailLog(Run<?, ?> b) {
        this(b.getRootDir(), b.getParent().getFullName(), b.getNumber());
    }

    public TailLog(JenkinsRule jr, String job, int number) {
        this(TailLog.runRootDir(jr.jenkins.getRootDir(), job, number), job, number);
    }

    public TailLog(RealJenkinsRule rjr, String job, int number) {
        this(TailLog.runRootDir(rjr.getHome(), job, number), job, number);
    }

    private static File runRootDir(File home, String job, int number) {
        return new File(home, "jobs/" + job.replace("/", "/jobs/") + "/builds/" + number);
    }

    public TailLog withColor(PrefixedOutputStream.AnsiColor color) {
        this.prefixedOutputStreamBuilder.withColor(color);
        return this;
    }

    public TailLog(File buildDirectory, final String job, final int number) {
        this.tailer = Tailer.create((File)new File(buildDirectory, "log"), (TailerListener)new TailerListenerAdapter(){
            PrintStream ps;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(String line) {
                if (this.ps == null) {
                    this.ps = new PrintStream((OutputStream)new PlainTextConsoleOutputStream(TailLog.this.prefixedOutputStreamBuilder.withName(job + "#" + number).build(System.out)), false, StandardCharsets.UTF_8);
                }
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    this.ps.append(DeltaSupportLogFormatter.elapsedTime());
                    this.ps.print(' ');
                    this.ps.print(line);
                    this.ps.println();
                    this.ps.flush();
                }
                if (line.startsWith("Finished: ")) {
                    TailLog.this.finished.release();
                }
            }
        }, (long)50L);
    }

    public void waitForCompletion() throws InterruptedException {
        this.finished.acquire();
    }

    @Override
    public void close() {
        this.tailer.stop();
    }
}

