/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.commons.io.FileUtils;
import org.dom4j.Document;
import org.dom4j.ProcessingInstruction;
import org.dom4j.io.SAXReader;
import org.jvnet.hudson.test.HudsonTestCase;
import org.jvnet.hudson.test.junit.GroupedTest;
import org.kohsuke.stapler.MetaClassLoader;
import org.kohsuke.stapler.jelly.JellyClassLoaderTearOff;

public class JellyTestSuiteBuilder {
    static Map<URL, String> scan(File resources, String extension) throws IOException {
        HashMap<URL, String> result = new HashMap<URL, String>();
        if (resources.isDirectory()) {
            for (File f : FileUtils.listFiles((File)resources, (String[])new String[]{extension}, (boolean)true)) {
                result.put(f.toURI().toURL(), f.getAbsolutePath().substring((resources.getAbsolutePath() + File.separator).length()));
            }
        } else if (resources.getName().endsWith(".jar")) {
            String jarUrl = resources.toURI().toURL().toExternalForm();
            JarFile jf = new JarFile(resources);
            Enumeration<JarEntry> e = jf.entries();
            while (e.hasMoreElements()) {
                JarEntry ent = e.nextElement();
                if (!ent.getName().endsWith("." + extension)) continue;
                result.put(new URL("jar:" + jarUrl + "!/" + ent.getName()), ent.getName());
            }
            jf.close();
        }
        return result;
    }

    public static TestSuite build(File res, boolean requirePI) throws Exception {
        JellyTestSuite ts = new JellyTestSuite();
        JellyClassLoaderTearOff jct = (JellyClassLoaderTearOff)new MetaClassLoader(JellyTestSuiteBuilder.class.getClassLoader()).loadTearOff(JellyClassLoaderTearOff.class);
        for (Map.Entry<URL, String> entry : JellyTestSuiteBuilder.scan(res, "jelly").entrySet()) {
            ts.addTest((Test)new JellyCheck(entry.getKey(), entry.getValue(), jct, requirePI));
        }
        return ts;
    }

    private static final class JellyTestSuite
    extends GroupedTest {
        HudsonTestCase h = new HudsonTestCase("Jelly test wrapper"){};

        private JellyTestSuite() {
        }

        @Override
        protected void setUp() throws Exception {
            this.h.setUp();
        }

        @Override
        protected void tearDown() throws Exception {
            this.h.tearDown();
        }

        private void doTests(TestResult result) throws Exception {
            super.runGroupedTests(result);
        }

        @Override
        protected void runGroupedTests(final TestResult result) throws Exception {
            this.h.executeOnServer(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    this.doTests(result);
                    return null;
                }
            });
        }
    }

    private static class JellyCheck
    extends TestCase {
        private final URL jelly;
        private final JellyClassLoaderTearOff jct;
        private final boolean requirePI;

        JellyCheck(URL jelly, String name, JellyClassLoaderTearOff jct, boolean requirePI) {
            super(name);
            this.jelly = jelly;
            this.jct = jct;
            this.requirePI = requirePI;
        }

        protected void runTest() throws Exception {
            ProcessingInstruction pi;
            this.jct.createContext().compileScript(this.jelly);
            Document dom = new SAXReader().read(this.jelly);
            if (this.requirePI && ((pi = dom.processingInstruction("jelly")) == null || !pi.getText().contains("escape-by-default"))) {
                throw new AssertionError((Object)("<?jelly escape-by-default='true'?> is missing in " + this.jelly));
            }
        }

        private boolean isConfigJelly() {
            return this.jelly.toString().endsWith("/config.jelly");
        }

        private boolean isGlobalJelly() {
            return this.jelly.toString().endsWith("/global.jelly");
        }
    }
}

