/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.htmlunit.WebRequest;
import org.htmlunit.WebResponse;

public interface WebResponseListener {
    public void onLoadWebResponse(WebRequest var1, WebResponse var2) throws IOException;

    public static final class StatusListener
    implements WebResponseListener {
        private final int statusCode;
        private final List<WebResponse> responses = new CopyOnWriteArrayList<WebResponse>();

        public StatusListener(int statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public void onLoadWebResponse(WebRequest webRequest, WebResponse webResponse) throws IOException {
            if (webResponse.getStatusCode() == this.statusCode) {
                this.responses.add(webResponse);
            }
        }

        public void assertHasResponses() {
            MatcherAssert.assertThat(this.responses, (Matcher)Matchers.not((Matcher)Matchers.empty()));
        }

        public List<WebResponse> getResponses() {
            return this.responses;
        }
    }
}

