/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.cli.CLICommand;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import hudson.security.SidACL;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.jvnet.hudson.test.JenkinsRule;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class CLICommandInvoker {
    private static final String username = "user";
    private final JenkinsRule rule;
    private final CLICommand command;
    @Deprecated
    private SecurityRealm originalSecurityRealm = null;
    @Deprecated
    private AuthorizationStrategy originalAuthorizationStrategy = null;
    @Deprecated
    private SecurityContext originalSecurityContext = null;
    private InputStream stdin;
    private List<String> args = List.of();
    @Deprecated
    private List<Permission> permissions = List.of();
    private Locale locale = Locale.ENGLISH;

    public CLICommandInvoker(JenkinsRule rule, CLICommand command) {
        ExtensionList.lookupSingleton(command.getClass());
        this.rule = rule;
        this.command = command;
    }

    public CLICommandInvoker(JenkinsRule rule, String command) {
        this.rule = rule;
        this.command = CLICommand.clone((String)command);
        if (this.command == null) {
            throw new AssertionError((Object)("No such command: " + command));
        }
    }

    @Deprecated
    public CLICommandInvoker authorizedTo(Permission ... permissions) {
        this.permissions = List.of(permissions);
        return this;
    }

    public CLICommandInvoker asUser(String user) {
        this.command.setTransportAuth2(User.getById((String)user, (boolean)true).impersonate2());
        return this;
    }

    public CLICommandInvoker withStdin(InputStream stdin) {
        if (stdin == null) {
            throw new NullPointerException("No stdin provided");
        }
        this.stdin = stdin;
        return this;
    }

    public CLICommandInvoker withArgs(String ... args) {
        this.args = List.of(args);
        return this;
    }

    public Result invokeWithArgs(String ... args) {
        return this.withArgs(args).invoke();
    }

    public Result invoke() {
        Charset outCharset;
        Charset errCharset;
        this.setAuth();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            outCharset = errCharset = this.command.getClientCharset();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        int returnCode = this.command.main(this.args, this.locale, this.stdin, new PrintStream((OutputStream)out, false, outCharset), new PrintStream((OutputStream)err, false, errCharset));
        this.restoreAuth();
        return new Result(returnCode, out, outCharset, err, errCharset);
    }

    @Deprecated
    private void setAuth() {
        if (this.permissions.isEmpty()) {
            return;
        }
        JenkinsRule.DummySecurityRealm realm = this.rule.createDummySecurityRealm();
        realm.addGroups(username, "group");
        this.originalSecurityRealm = this.rule.jenkins.getSecurityRealm();
        this.rule.jenkins.setSecurityRealm((SecurityRealm)realm);
        this.originalAuthorizationStrategy = this.rule.jenkins.getAuthorizationStrategy();
        this.rule.jenkins.setAuthorizationStrategy((AuthorizationStrategy)new GrantPermissions(username, this.permissions));
        this.command.setTransportAuth2(this.user().impersonate2());
        this.originalSecurityContext = ACL.impersonate2((Authentication)Jenkins.ANONYMOUS2);
    }

    @Deprecated
    private void restoreAuth() {
        if (this.originalSecurityRealm != null) {
            this.rule.jenkins.setSecurityRealm(this.originalSecurityRealm);
            this.originalSecurityRealm = null;
        }
        if (this.originalAuthorizationStrategy != null) {
            this.rule.jenkins.setAuthorizationStrategy(this.originalAuthorizationStrategy);
            this.originalAuthorizationStrategy = null;
        }
        if (this.originalSecurityContext != null) {
            SecurityContextHolder.setContext((SecurityContext)this.originalSecurityContext);
            this.originalSecurityContext = null;
        }
    }

    @Deprecated
    public User user() {
        return User.get((String)username);
    }

    public static class Result {
        private final int result;
        private final ByteArrayOutputStream out;
        private final Charset outCharset;
        private final ByteArrayOutputStream err;
        private final Charset errCharset;

        private Result(int result, ByteArrayOutputStream out, Charset outCharset, ByteArrayOutputStream err, Charset errCharset) {
            this.result = result;
            this.out = out;
            this.outCharset = outCharset;
            this.err = err;
            this.errCharset = errCharset;
        }

        public int returnCode() {
            return this.result;
        }

        public String stdout() {
            return this.out.toString(this.outCharset);
        }

        public byte[] stdoutBinary() {
            return this.out.toByteArray();
        }

        public String stderr() {
            return this.err.toString(this.errCharset);
        }

        public byte[] stderrBinary() {
            return this.err.toByteArray();
        }

        public String toString() {
            String stderr;
            StringBuilder builder = new StringBuilder("CLI command exited with ").append(this.result);
            String stdout = this.stdout();
            if (!"".equals(stdout)) {
                builder.append("\nSTDOUT:\n").append(stdout);
            }
            if (!"".equals(stderr = this.stderr())) {
                builder.append("\nSTDERR:\n").append(stderr);
            }
            return builder.toString();
        }
    }

    private static class GrantPermissions
    extends AuthorizationStrategy {
        final String username;
        final Set<String> permissions;

        GrantPermissions(String username, List<Permission> permissions) {
            this.username = username;
            this.permissions = permissions.stream().map(Permission::getId).collect(Collectors.toSet());
            for (Permission p : permissions) {
                p.setEnabled(true);
            }
        }

        @NonNull
        public ACL getRootACL() {
            return new SidACL(){

                protected Boolean hasPermission(Sid u, Permission permission) {
                    if (u instanceof PrincipalSid && ((PrincipalSid)u).getPrincipal().equals(username)) {
                        Permission p = permission;
                        while (p != null) {
                            if (permissions.contains(p.getId())) {
                                return true;
                            }
                            p = p.impliedBy;
                        }
                    }
                    return false;
                }
            };
        }

        @NonNull
        public Collection<String> getGroups() {
            return Set.of();
        }
    }

    public static abstract class Matcher
    extends TypeSafeMatcher<Result> {
        private final String description;

        private Matcher(String description) {
            this.description = description;
        }

        protected void describeMismatchSafely(Result result, Description description) {
            description.appendText(result.toString());
        }

        public void describeTo(Description description) {
            description.appendText(this.description);
        }

        public static Matcher hasNoStandardOutput() {
            return new Matcher("No standard output"){

                protected boolean matchesSafely(Result result) {
                    return "".equals(result.stdout());
                }
            };
        }

        public static Matcher hasNoErrorOutput() {
            return new Matcher("No error output"){

                protected boolean matchesSafely(Result result) {
                    return "".equals(result.stderr());
                }
            };
        }

        public static Matcher succeeded() {
            return new Matcher("Exited with 0 return code"){

                protected boolean matchesSafely(Result result) {
                    return result.result == 0;
                }
            };
        }

        public static Matcher succeededSilently() {
            return new Matcher("Succeeded silently"){

                protected boolean matchesSafely(Result result) {
                    return result.result == 0 && "".equals(result.stderr()) && "".equals(result.stdout());
                }
            };
        }

        public static Matcher failedWith(final long expectedCode) {
            return new Matcher("Exited with " + expectedCode + " return code"){

                protected boolean matchesSafely(Result result) {
                    return (long)result.result == expectedCode;
                }
            };
        }
    }
}

