/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.html.HtmlParagraph;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.commons.lang3.ArrayUtils;

@JsxClass(domClass=HtmlParagraph.class)
public class HTMLParagraphElement
extends HTMLElement {
    private static final String[] VALID_CLEAR_VALUES = new String[]{"left", "right", "all", "none"};

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public HTMLParagraphElement() {
    }

    @JsxGetter
    public String getAlign() {
        return this.getAlign(true);
    }

    @JsxSetter
    public void setAlign(String align) {
        this.setAlign(align, false);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getClear() {
        String clear = this.getDomNodeOrDie().getAttributeDirect("clear");
        if (!ArrayUtils.contains(VALID_CLEAR_VALUES, clear)) {
            return "";
        }
        return clear;
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setClear(String clear) {
        if (!ArrayUtils.contains(VALID_CLEAR_VALUES, clear)) {
            throw Context.reportRuntimeError("Invalid clear property value: '" + clear + "'.");
        }
        this.getDomNodeOrDie().setAttribute("clear", clear);
    }
}

