/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.DOMTokenList;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.commons.lang3.StringUtils;

@JsxClass(domClass=HtmlAnchor.class)
public class HTMLAnchorElement
extends HTMLElement {
    private static final List<String> REFERRER_POLICIES = Arrays.asList("no-referrer", "origin", "unsafe-url");

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public HTMLAnchorElement() {
    }

    @JsxSetter
    public void setHref(String href) {
        this.getDomNodeOrDie().setAttribute("href", href);
    }

    @JsxGetter
    public String getHref() {
        HtmlAnchor anchor = (HtmlAnchor)this.getDomNodeOrDie();
        String hrefAttr = anchor.getHrefAttribute();
        if (hrefAttr == DomElement.ATTRIBUTE_NOT_DEFINED) {
            return "";
        }
        try {
            return this.getUrl().toString();
        }
        catch (MalformedURLException e) {
            return hrefAttr;
        }
    }

    @Override
    public void focus() {
        HtmlAnchor anchor = (HtmlAnchor)this.getDomNodeOrDie();
        String hrefAttr = anchor.getHrefAttribute();
        if (hrefAttr != DomElement.ATTRIBUTE_NOT_DEFINED) {
            anchor.focus();
        }
    }

    @Override
    @JsxSetter
    public void setName(String name) {
        this.getDomNodeOrDie().setAttribute("name", name);
    }

    @Override
    @JsxGetter
    public String getName() {
        return this.getDomNodeOrDie().getAttributeDirect("name");
    }

    @JsxSetter
    public void setTarget(String target) {
        this.getDomNodeOrDie().setAttribute("target", target);
    }

    @JsxGetter
    public String getTarget() {
        return this.getDomNodeOrDie().getAttributeDirect("target");
    }

    private URL getUrl() throws MalformedURLException {
        HtmlAnchor anchor = (HtmlAnchor)this.getDomNodeOrDie();
        return ((HtmlPage)anchor.getPage()).getFullyQualifiedUrl(anchor.getHrefAttribute());
    }

    private void setUrl(URL url) {
        this.getDomNodeOrDie().setAttribute("href", url.toString());
    }

    @JsxSetter
    public void setRel(String rel) {
        this.getDomNodeOrDie().setAttribute("rel", rel);
    }

    @JsxGetter
    public String getRel() {
        return ((HtmlAnchor)this.getDomNodeOrDie()).getRelAttribute();
    }

    @JsxGetter
    public String getRev() {
        return ((HtmlAnchor)this.getDomNodeOrDie()).getRevAttribute();
    }

    @JsxSetter
    public void setRev(String rel) {
        this.getDomNodeOrDie().setAttribute("rev", rel);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public String getReferrerPolicy() {
        String attrib = ((HtmlAnchor)this.getDomNodeOrDie()).getAttribute("referrerPolicy");
        if (StringUtils.isEmpty(attrib)) {
            return "";
        }
        if (REFERRER_POLICIES.contains(attrib = attrib.toLowerCase(Locale.ROOT))) {
            return attrib;
        }
        return "";
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public void setReferrerPolicy(String referrerPolicy) {
        this.getDomNodeOrDie().setAttribute("referrerPolicy", referrerPolicy);
    }

    @JsxGetter
    public String getSearch() {
        try {
            String query = this.getUrl().getQuery();
            if (query == null) {
                return "";
            }
            return "?" + query;
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    @JsxSetter
    public void setSearch(String search) throws Exception {
        String query = search == null || "?".equals(search) || "".equals(search) ? null : (search.charAt(0) == '?' ? search.substring(1) : search);
        this.setUrl(UrlUtils.getUrlWithNewQuery(this.getUrl(), query));
    }

    @JsxGetter
    public String getHash() {
        try {
            String hash = this.getUrl().getRef();
            if (hash == null) {
                return "";
            }
            return "#" + hash;
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    @JsxSetter
    public void setHash(String hash) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewRef(this.getUrl(), hash));
    }

    @JsxGetter
    public String getHost() {
        try {
            URL url = this.getUrl();
            int port = url.getPort();
            String host = url.getHost();
            if (port == -1) {
                return host;
            }
            return host + ":" + port;
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    @JsxSetter
    public void setHost(String host) throws Exception {
        int port;
        String hostname;
        int index = host.indexOf(58);
        if (index != -1) {
            hostname = host.substring(0, index);
            port = Integer.parseInt(host.substring(index + 1));
        } else {
            hostname = host;
            port = -1;
        }
        URL url = UrlUtils.getUrlWithNewHostAndPort(this.getUrl(), hostname, port);
        this.setUrl(url);
    }

    @JsxGetter
    public String getHostname() {
        try {
            return this.getUrl().getHost();
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    @JsxSetter
    public void setHostname(String hostname) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewHost(this.getUrl(), hostname));
    }

    @JsxGetter
    public String getPathname() {
        try {
            HtmlAnchor anchor;
            String href;
            URL url = this.getUrl();
            if (!url.getProtocol().startsWith("http") && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ANCHOR_PATHNAME_NONE_FOR_NONE_HTTP_URL)) {
                return "";
            }
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ANCHOR_PATHNAME_DETECT_WIN_DRIVES_URL) && (href = (anchor = (HtmlAnchor)this.getDomNodeOrDie()).getHrefAttribute()).length() > 1 && Character.isLetter(href.charAt(0)) && ':' == href.charAt(1)) {
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ANCHOR_PROTOCOL_COLON_UPPER_CASE_DRIVE_LETTERS)) {
                    href = StringUtils.capitalize(href);
                }
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ANCHOR_PATHNAME_PREFIX_WIN_DRIVES_URL)) {
                    href = "/" + href;
                }
                return href;
            }
            return url.getPath();
        }
        catch (MalformedURLException e) {
            HtmlAnchor anchor = (HtmlAnchor)this.getDomNodeOrDie();
            if (anchor.getHrefAttribute().startsWith("http") && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ANCHOR_PATHNAME_NONE_FOR_BROKEN_URL)) {
                return "";
            }
            return "/";
        }
    }

    @JsxSetter
    public void setPathname(String pathname) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewPath(this.getUrl(), pathname));
    }

    @JsxGetter
    public String getPort() {
        try {
            int port = this.getUrl().getPort();
            if (port == -1) {
                return "";
            }
            return Integer.toString(port);
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    @JsxSetter
    public void setPort(String port) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewPort(this.getUrl(), Integer.parseInt(port)));
    }

    @JsxGetter
    public String getProtocol() {
        BrowserVersion browser = this.getBrowserVersion();
        try {
            HtmlAnchor anchor;
            String href;
            if (browser.hasFeature(BrowserVersionFeatures.JS_ANCHOR_PATHNAME_DETECT_WIN_DRIVES_URL) && (href = (anchor = (HtmlAnchor)this.getDomNodeOrDie()).getHrefAttribute().toLowerCase(Locale.ROOT)).length() > 1 && Character.isLetter(href.charAt(0)) && ':' == href.charAt(1)) {
                return "file:";
            }
            return this.getUrl().getProtocol() + ":";
        }
        catch (MalformedURLException e) {
            HtmlAnchor anchor = (HtmlAnchor)this.getDomNodeOrDie();
            if (anchor.getHrefAttribute().startsWith("http")) {
                if (browser.hasFeature(BrowserVersionFeatures.JS_ANCHOR_PROTOCOL_COLON_FOR_BROKEN_URL)) {
                    return ":";
                }
                if (browser.hasFeature(BrowserVersionFeatures.JS_ANCHOR_PROTOCOL_HTTP_FOR_BROKEN_URL)) {
                    return "http:";
                }
            }
            return StringUtils.substringBefore(anchor.getHrefAttribute(), "/");
        }
    }

    @JsxSetter
    public void setProtocol(String protocol) throws Exception {
        String bareProtocol = StringUtils.substringBefore(protocol, ":");
        this.setUrl(UrlUtils.getUrlWithNewProtocol(this.getUrl(), bareProtocol));
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        HtmlElement element = this.getDomNodeOrNull();
        if (element == null) {
            return super.getDefaultValue(null);
        }
        return HTMLAnchorElement.getDefaultValue(element);
    }

    static String getDefaultValue(HtmlElement element) {
        String href = element.getAttributeDirect("href");
        if (DomElement.ATTRIBUTE_NOT_DEFINED == href) {
            return "";
        }
        href = href.trim();
        SgmlPage page = element.getPage();
        if (page == null || !page.isHtmlPage()) {
            return href;
        }
        try {
            return HtmlAnchor.getTargetUrl(href, (HtmlPage)page).toExternalForm();
        }
        catch (MalformedURLException e) {
            return href;
        }
    }

    @JsxGetter
    public String getText() {
        HtmlElement htmlElement = this.getDomNodeOrDie();
        return htmlElement.asText();
    }

    @JsxSetter
    public void setText(String text) {
        HtmlElement htmlElement = this.getDomNodeOrDie();
        htmlElement.setTextContent(text);
    }

    @JsxGetter
    public String getCharset() {
        return this.getDomNodeOrDie().getAttributeDirect("charset");
    }

    @JsxSetter
    public void setCharset(String charset) {
        this.getDomNodeOrDie().setAttribute("charset", charset);
    }

    @JsxGetter
    public String getCoords() {
        return this.getDomNodeOrDie().getAttributeDirect("coords");
    }

    @JsxSetter
    public void setCoords(String coords) {
        this.getDomNodeOrDie().setAttribute("coords", coords);
    }

    @JsxGetter
    public String getHreflang() {
        return this.getDomNodeOrDie().getAttributeDirect("hreflang");
    }

    @JsxSetter
    public void setHreflang(String hreflang) {
        this.getDomNodeOrDie().setAttribute("hreflang", hreflang);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public String getOrigin() {
        if (!this.getDomNodeOrDie().hasAttribute("href")) {
            return "";
        }
        try {
            return this.getUrl().getProtocol() + "://" + this.getHost();
        }
        catch (Exception e) {
            return "";
        }
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public void setOrigin(String origin) {
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public String getUsername() {
        try {
            String userName = this.getUrl().getUserInfo();
            if (userName == null) {
                return "";
            }
            return StringUtils.substringBefore(userName, ":");
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public void setUsername(String username) {
        try {
            HtmlAnchor anchor = (HtmlAnchor)this.getDomNodeOrDie();
            String href = anchor.getHrefAttribute();
            if (href == DomElement.ATTRIBUTE_NOT_DEFINED) {
                return;
            }
            URL url = ((HtmlPage)anchor.getPage()).getFullyQualifiedUrl(href);
            this.setUrl(UrlUtils.getUrlWithNewUserName(url, username));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public String getPassword() {
        try {
            String userName = this.getUrl().getUserInfo();
            if (userName == null) {
                return "";
            }
            return StringUtils.substringAfter(userName, ":");
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public void setPassword(String password) {
        try {
            HtmlAnchor anchor = (HtmlAnchor)this.getDomNodeOrDie();
            String href = anchor.getHrefAttribute();
            if (href == DomElement.ATTRIBUTE_NOT_DEFINED) {
                return;
            }
            URL url = ((HtmlPage)anchor.getPage()).getFullyQualifiedUrl(href);
            this.setUrl(UrlUtils.getUrlWithNewUserPassword(url, password));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public String getDownload() {
        return this.getDomNodeOrDie().getAttribute("download");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public void setDownload(String download) {
        this.getDomNodeOrDie().setAttribute("download", download);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public String getPing() {
        return ((HtmlAnchor)this.getDomNodeOrDie()).getPingAttribute();
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public void setPing(String ping) {
        this.getDomNodeOrDie().setAttribute("ping", ping);
    }

    @JsxGetter
    public String getShape() {
        return this.getDomNodeOrDie().getAttribute("shape");
    }

    @JsxSetter
    public void setShape(String shape) {
        this.getDomNodeOrDie().setAttribute("shape", shape);
    }

    @JsxGetter
    public String getType() {
        return this.getDomNodeOrDie().getAttributeDirect("type");
    }

    @JsxSetter
    public void setType(String type) {
        this.getDomNodeOrDie().setAttribute("type", type);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public DOMTokenList getRelList() {
        return new DOMTokenList(this, "rel");
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getProtocolLong() {
        throw Context.throwAsScriptRuntimeEx(new UnsupportedOperationException());
    }

    @JsxGetter(propertyName="Methods", value={SupportedBrowser.IE})
    public String getMethods() {
        throw Context.throwAsScriptRuntimeEx(new UnsupportedOperationException());
    }

    @JsxSetter(propertyName="Methods", value={SupportedBrowser.IE})
    public void setMethods(String methods) {
        throw Context.throwAsScriptRuntimeEx(new UnsupportedOperationException());
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getMimeType() {
        throw Context.throwAsScriptRuntimeEx(new UnsupportedOperationException());
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setMimeType(String mimeType) {
        throw Context.throwAsScriptRuntimeEx(new UnsupportedOperationException());
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getNameProp() {
        throw Context.throwAsScriptRuntimeEx(new UnsupportedOperationException());
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getUrn() {
        throw Context.throwAsScriptRuntimeEx(new UnsupportedOperationException());
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setUrn(String urn) {
        throw Context.throwAsScriptRuntimeEx(new UnsupportedOperationException());
    }
}

