/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.impl.SimpleRange;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Range;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;

@JsxClass
public class Selection
extends SimpleScriptable {
    private static final String TYPE_NONE = "None";
    private static final String TYPE_CARET = "Caret";
    private static final String TYPE_RANGE = "Range";
    private String type_ = "None";

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public Selection() {
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (this.getPrototype() != null && (String.class.equals(hint) || hint == null)) {
            StringBuilder sb = new StringBuilder();
            for (org.w3c.dom.ranges.Range r : this.getRanges()) {
                sb.append(r.toString());
            }
            return sb.toString();
        }
        return super.getDefaultValue(hint);
    }

    @JsxGetter
    public Node getAnchorNode() {
        org.w3c.dom.ranges.Range last = this.getLastRange();
        if (last == null) {
            return null;
        }
        return (Node)this.getScriptableNullSafe(last.getStartContainer());
    }

    @JsxGetter
    public int getAnchorOffset() {
        org.w3c.dom.ranges.Range last = this.getLastRange();
        if (last == null) {
            return 0;
        }
        return last.getStartOffset();
    }

    @JsxGetter
    public Node getFocusNode() {
        org.w3c.dom.ranges.Range last = this.getLastRange();
        if (last == null) {
            return null;
        }
        return (Node)this.getScriptableNullSafe(last.getEndContainer());
    }

    @JsxGetter
    public int getFocusOffset() {
        org.w3c.dom.ranges.Range last = this.getLastRange();
        if (last == null) {
            return 0;
        }
        return last.getEndOffset();
    }

    @JsxGetter
    public boolean isIsCollapsed() {
        List<org.w3c.dom.ranges.Range> ranges = this.getRanges();
        return ranges.isEmpty() || ranges.size() == 1 && ranges.get(0).getCollapsed();
    }

    @JsxGetter
    public int getRangeCount() {
        return this.getRanges().size();
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public String getType() {
        return this.type_;
    }

    @JsxFunction
    public void addRange(Range range) {
        SimpleRange rg = range.toW3C();
        this.getRanges().add(rg);
        if (TYPE_CARET.equals(this.type_) && rg.getCollapsed()) {
            return;
        }
        this.type_ = TYPE_RANGE;
    }

    @JsxFunction
    public void removeRange(Range range) {
        this.getRanges().remove(range.toW3C());
        if (this.getRangeCount() < 1) {
            this.type_ = TYPE_NONE;
        }
    }

    @JsxFunction
    public void removeAllRanges() {
        this.getRanges().clear();
        this.type_ = TYPE_NONE;
    }

    @JsxFunction
    public Range getRangeAt(int index) {
        List<org.w3c.dom.ranges.Range> ranges = this.getRanges();
        if (index < 0 || index >= ranges.size()) {
            throw Context.reportRuntimeError("Invalid range index: " + index);
        }
        org.w3c.dom.ranges.Range range = ranges.get(index);
        Range jsRange = new Range(range);
        jsRange.setParentScope(this.getWindow());
        jsRange.setPrototype(this.getPrototype(Range.class));
        return jsRange;
    }

    @JsxFunction
    public void collapse(Node parentNode, int offset) {
        List<org.w3c.dom.ranges.Range> ranges = this.getRanges();
        ranges.clear();
        ranges.add(new SimpleRange(parentNode.getDomNodeOrDie(), offset));
        this.type_ = TYPE_CARET;
    }

    @JsxFunction
    public void collapseToEnd() {
        org.w3c.dom.ranges.Range last = this.getLastRange();
        if (last != null) {
            List<org.w3c.dom.ranges.Range> ranges = this.getRanges();
            ranges.clear();
            ranges.add(last);
            last.collapse(false);
        }
        this.type_ = TYPE_CARET;
    }

    @JsxFunction
    public void collapseToStart() {
        org.w3c.dom.ranges.Range first = this.getFirstRange();
        if (first != null) {
            List<org.w3c.dom.ranges.Range> ranges = this.getRanges();
            ranges.clear();
            ranges.add(first);
            first.collapse(true);
        }
        this.type_ = TYPE_CARET;
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public void empty() {
        this.removeAllRanges();
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public void extend(Node parentNode, int offset) {
        org.w3c.dom.ranges.Range last = this.getLastRange();
        if (last != null) {
            last.setEnd(parentNode.getDomNodeOrDie(), offset);
            this.type_ = TYPE_RANGE;
        }
    }

    @JsxFunction
    public void selectAllChildren(Node parentNode) {
        List<org.w3c.dom.ranges.Range> ranges = this.getRanges();
        ranges.clear();
        SimpleRange rg = new SimpleRange(parentNode.getDomNodeOrDie());
        ranges.add(rg);
        this.type_ = rg.getCollapsed() ? TYPE_CARET : TYPE_RANGE;
    }

    private List<org.w3c.dom.ranges.Range> getRanges() {
        HtmlPage page = (HtmlPage)this.getWindow().getDomNodeOrDie();
        return page.getSelectionRanges();
    }

    private org.w3c.dom.ranges.Range getFirstRange() {
        ArrayList<org.w3c.dom.ranges.Range> ranges = new ArrayList<org.w3c.dom.ranges.Range>(this.getRanges());
        org.w3c.dom.ranges.Range first = null;
        for (org.w3c.dom.ranges.Range range : ranges) {
            org.w3c.dom.Node rangeStart;
            if (first == null) {
                first = range;
                continue;
            }
            org.w3c.dom.Node firstStart = first.getStartContainer();
            if ((firstStart.compareDocumentPosition(rangeStart = range.getStartContainer()) & 2) == 0) continue;
            first = range;
        }
        return first;
    }

    private org.w3c.dom.ranges.Range getLastRange() {
        ArrayList<org.w3c.dom.ranges.Range> ranges = new ArrayList<org.w3c.dom.ranges.Range>(this.getRanges());
        org.w3c.dom.ranges.Range last = null;
        for (org.w3c.dom.ranges.Range range : ranges) {
            org.w3c.dom.Node rangeStart;
            if (last == null) {
                last = range;
                continue;
            }
            org.w3c.dom.Node lastStart = last.getStartContainer();
            if ((lastStart.compareDocumentPosition(rangeStart = range.getStartContainer()) & 4) == 0) continue;
            last = range;
        }
        return last;
    }

    private SimpleScriptable getScriptableNullSafe(Object object) {
        SimpleScriptable scriptable = object != null ? this.getScriptableFor(object) : null;
        return scriptable;
    }
}

